/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIGDBShowDirectoriesInfo
extends MIInfo {
    String[] dirs = new String[0];

    public MIGDBShowDirectoriesInfo(MIOutput o) {
        super(o);
        this.parse();
    }

    public String[] getDirectories() {
        return this.dirs;
    }

    void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                int j;
                MIStreamRecord cons;
                String str;
                if (oobs[i] instanceof MIConsoleStreamOutput && (str = (cons = (MIStreamRecord)oobs[i]).getString()).startsWith("Source directories searched:") && (j = str.indexOf(58)) != -1) {
                    String sub = str.substring(j + 1).trim();
                    this.parseDirectories(sub);
                }
                ++i;
            }
        }
    }

    void parseDirectories(String d) {
        String sep = System.getProperty("path.separator", ":");
        StringTokenizer st = new StringTokenizer(d, sep);
        int count = st.countTokens();
        this.dirs = new String[count];
        int i = 0;
        while (st.hasMoreTokens() && i < count) {
            this.dirs[i] = st.nextToken();
            ++i;
        }
    }
}

