/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.core;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SyncUtils {
    public static void flushNode(final Preferences prefNode) {
        Throwable firstException = null;
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            if (!ws.isTreeLocked()) {
                prefNode.flush();
                return;
            }
        }
        catch (BackingStoreException e) {
            firstException = e;
        }
        catch (IllegalStateException e) {
            firstException = e;
            return;
        }
        final BackingStoreException currentException = firstException;
        Thread flushThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int sleepCount = 0;
                Throwable lastException = currentException;
                block4: while (true) {
                    try {
                        do {
                            Thread.sleep(1000L);
                            if (++sleepCount <= 30) continue;
                            if (lastException != null) {
                                RDTSyncCorePlugin.log(Messages.SyncUtils_Unable_to_flush, lastException);
                                break block4;
                            }
                            RDTSyncCorePlugin.log(Messages.SyncUtils_Unable_to_flush);
                            break block4;
                        } while (ws.isTreeLocked());
                        prefNode.flush();
                    }
                    catch (InterruptedException e) {
                        lastException = e;
                        continue;
                    }
                    catch (BackingStoreException e) {
                        lastException = e;
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                    break;
                }
            }
        }, "Flush project data thread");
        flushThread.start();
    }
}

