/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.util.Observable;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.StringDialogField;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TCPSettingsBlock
extends Observable {
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_PORT_NUMBER = "10000";
    private Shell fShell;
    private StringDialogField fHostNameField = this.createHostNameField();
    private StringDialogField fPortNumberField = this.createPortNumberField();
    private Control fControl;
    private String fErrorMessage = null;

    public void createBlock(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(parent.getFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fHostNameField.doFillIntoGrid(comp, 2);
        LayoutUtil.setWidthHint((Control)this.fHostNameField.getTextControl(null), (int)converter.convertWidthInCharsToPixels(20));
        this.fPortNumberField.doFillIntoGrid(comp, 2);
        ((GridData)this.fPortNumberField.getTextControl(null).getLayoutData()).horizontalAlignment = 1;
        LayoutUtil.setWidthHint((Control)this.fPortNumberField.getTextControl(null), (int)converter.convertWidthInCharsToPixels(10));
        this.setControl((Control)comp);
    }

    protected Shell getShell() {
        return this.fShell;
    }

    public void dispose() {
        this.deleteObservers();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeHostName(configuration);
        this.initializePortNumber(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", DEFAULT_HOST_NAME);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", DEFAULT_PORT_NUMBER);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fHostNameField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", this.fHostNameField.getText().trim());
        }
        if (this.fPortNumberField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", this.fPortNumberField.getText().trim());
        }
    }

    private StringDialogField createHostNameField() {
        StringDialogField field = new StringDialogField();
        field.setLabelText(LaunchUIMessages.getString("TCPSettingsBlock.0"));
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                TCPSettingsBlock.this.hostNameFieldChanged();
            }
        });
        return field;
    }

    private StringDialogField createPortNumberField() {
        StringDialogField field = new StringDialogField();
        field.setLabelText(LaunchUIMessages.getString("TCPSettingsBlock.1"));
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                TCPSettingsBlock.this.portNumberFieldChanged();
            }
        });
        return field;
    }

    protected void hostNameFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void portNumberFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    private void initializeHostName(ILaunchConfiguration configuration) {
        if (this.fHostNameField != null) {
            try {
                this.fHostNameField.setText(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", DEFAULT_HOST_NAME));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializePortNumber(ILaunchConfiguration configuration) {
        if (this.fPortNumberField != null) {
            try {
                this.fPortNumberField.setText(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", DEFAULT_PORT_NUMBER));
            }
            catch (CoreException coreException) {}
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.updateErrorMessage();
        return this.getErrorMessage() == null;
    }

    private void updateErrorMessage() {
        this.setErrorMessage(null);
        if (this.fHostNameField != null && this.fPortNumberField != null) {
            if (this.fHostNameField.getText().trim().length() == 0) {
                this.setErrorMessage(LaunchUIMessages.getString("TCPSettingsBlock.2"));
            } else if (!this.hostNameIsValid(this.fHostNameField.getText().trim())) {
                this.setErrorMessage(LaunchUIMessages.getString("TCPSettingsBlock.3"));
            } else if (this.fPortNumberField.getText().trim().length() == 0) {
                this.setErrorMessage(LaunchUIMessages.getString("TCPSettingsBlock.4"));
            } else if (!this.portNumberIsValid(this.fPortNumberField.getText().trim())) {
                this.setErrorMessage(LaunchUIMessages.getString("TCPSettingsBlock.5"));
            }
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    private boolean hostNameIsValid(String hostName) {
        return true;
    }

    private boolean portNumberIsValid(String portNumber) {
        try {
            int port = Integer.parseInt(portNumber);
            return port > 0 && port <= 65535;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

