/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions;

import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.IBreakpointActionPage;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.CollectAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.MessagesForTracepointActions;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CollectActionPage
extends PlatformObject
implements IBreakpointActionPage {
    private Text fCollectString;
    private Button fTreatCharPtrAsStrings;
    private Text fTreatCharPtrAsStringsLimit;
    private CollectAction fCollectAction;

    private Composite createCollectActionComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label collectLabel = new Label(composite, 0);
        collectLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        collectLabel.setText(MessagesForTracepointActions.TracepointActions_Collect_Label);
        this.fCollectString = new Text(composite, 2048);
        this.fCollectString.setText(this.fCollectAction.getCollectString());
        this.fCollectString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fTreatCharPtrAsStrings = new Button(composite, 32);
        GridData gd = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd.verticalIndent = 15;
        int buttonWidth = this.fTreatCharPtrAsStrings.computeSize((int)-1, (int)-1).x;
        this.fTreatCharPtrAsStrings.setText(MessagesForTracepointActions.TracepointActions_Collect_Strings_Label);
        this.fTreatCharPtrAsStrings.setLayoutData((Object)gd);
        this.fTreatCharPtrAsStrings.setSelection(this.fCollectAction.getCharPtrAsStrings());
        this.fTreatCharPtrAsStrings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CollectActionPage.this.fTreatCharPtrAsStringsLimit.setEnabled(CollectActionPage.this.fTreatCharPtrAsStrings.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CollectActionPage.this.fTreatCharPtrAsStringsLimit.setEnabled(CollectActionPage.this.fTreatCharPtrAsStrings.getSelection());
            }
        });
        Label limitLabel = new Label(composite, 0);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.horizontalIndent = buttonWidth;
        limitLabel.setLayoutData((Object)gd);
        limitLabel.setText(MessagesForTracepointActions.TracepointActions_Collect_Strings_Limit_Label);
        this.fTreatCharPtrAsStringsLimit = new Text(composite, 2048);
        this.fTreatCharPtrAsStringsLimit.setText(this.getCharPtrAsStringLimit(this.fCollectAction.getCharPtrAsStringsLimit()));
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.fTreatCharPtrAsStringsLimit.setLayoutData((Object)gd);
        this.fTreatCharPtrAsStringsLimit.setEnabled(this.fTreatCharPtrAsStrings.getSelection());
        final ControlDecoration decoration = new ControlDecoration((Control)this.fTreatCharPtrAsStringsLimit, 16512, composite);
        decoration.hide();
        this.fTreatCharPtrAsStringsLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    CollectActionPage.this.getCharPtrAsStringLimit(CollectActionPage.this.fTreatCharPtrAsStringsLimit.getText());
                    decoration.hide();
                }
                catch (IllegalCollectStringLimitException exception) {
                    decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                    decoration.setDescriptionText(exception.getMessage());
                    decoration.show();
                }
            }
        });
        return composite;
    }

    public CollectAction getCollectAction() {
        return this.fCollectAction;
    }

    public void actionDialogCanceled() {
    }

    public void actionDialogOK() {
        this.fCollectAction.setCollectString(this.fCollectString.getText());
        this.fCollectAction.setCharPtrAsStrings(this.fTreatCharPtrAsStrings.getSelection());
        try {
            Integer limit = this.getCharPtrAsStringLimit(this.fTreatCharPtrAsStringsLimit.getText());
            this.fCollectAction.setCharPtrAsStringsLimit(limit);
        }
        catch (IllegalCollectStringLimitException illegalCollectStringLimitException) {}
    }

    public Composite createComposite(IBreakpointAction action, Composite composite, int style) {
        this.fCollectAction = (CollectAction)action;
        return this.createCollectActionComposite(composite, style);
    }

    private Integer getCharPtrAsStringLimit(String limitStr) throws IllegalCollectStringLimitException {
        Integer limit;
        block3: {
            limitStr = limitStr.trim();
            limit = null;
            try {
                limit = Integer.parseInt(limitStr);
                if (limit < 0) {
                    throw new IllegalCollectStringLimitException(MessagesForTracepointActions.TracepointActions_Collect_Strings_Limit_Error);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (limitStr.isEmpty()) break block3;
                throw new IllegalCollectStringLimitException(MessagesForTracepointActions.TracepointActions_Collect_Strings_Limit_Error);
            }
        }
        return limit;
    }

    private String getCharPtrAsStringLimit(Integer limit) {
        if (limit == null || limit < 0) {
            return "";
        }
        return Integer.toString(limit);
    }

    private class IllegalCollectStringLimitException
    extends Exception {
        private static final long serialVersionUID = -2087722354642237691L;

        public IllegalCollectStringLimitException(String message) {
            super(message);
        }
    }
}

