/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.util;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.ProjectMetaManager;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class CudaProjectUtil {
    public static final String FILE_EXTENSION_CU = "cu";
    public static final String NVCC_COMPILER = "nvcc.compiler";
    public static final String NVCC_LINKER = "nvcc.linker";

    public static String getArchitectureOptions(ICConfigurationDescription configuration) throws CoreException {
        ICudaProjectConfiguration cpc = ProjectMetaManager.load(configuration);
        ICudaModule exe = cpc.getExecutable();
        ICubinModule[] modules = cpc.getModules();
        return CudaProjectUtil.getArchitectureOptions(exe, modules);
    }

    public static String getArchitectureOptions(ICConfigurationDescription configuration, IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            ICudaProjectConfiguration cpc = ProjectMetaManager.load(configuration);
            IFile file = (IFile)resource;
            ICudaModule exe = cpc.getExecutable();
            if (!exe.includes(file)) {
                exe = null;
            }
            ICubinModule[] modules = cpc.getModules(file);
            return CudaProjectUtil.getArchitectureOptions(exe, modules);
        }
        return "";
    }

    private static String getArchitectureOptions(ICudaModule exe, ICubinModule[] modules) {
        StringBuilder builder = new StringBuilder();
        TreeSet<String> options = new TreeSet<String>();
        if (exe != null) {
            options.addAll(CudaProjectUtil.toStringArray(exe.getVirtualArchitectures()));
            options.addAll(CudaProjectUtil.toStringArray(exe.getPhysicalArchitectures()));
        }
        ICubinModule[] iCubinModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ICubinModule module = iCubinModuleArray[n2];
            options.addAll(CudaProjectUtil.toStringArray(module.getVirtualArchitectures()));
            options.addAll(CudaProjectUtil.toStringArray(module.getPhysicalArchitectures()));
            ++n2;
        }
        for (String option : options) {
            builder.append(option).append(' ');
        }
        return builder.toString().trim();
    }

    private static ITool getCompiler(ICResourceDescription cfg) {
        if (cfg != null) {
            ITool[] tools;
            IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfg.getConfiguration());
            IPath path = cfg.getPath();
            Object info = path.segmentCount() == 0 ? configuration.getRootFolderInfo() : configuration.createFileInfo(path);
            ITool[] iToolArray = tools = info.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (CudaProjectUtil.isCompiler(tool)) {
                    return tool;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Object getCompilerOptionValue(ICResourceDescription cfg, String optionName) {
        ITool tools = CudaProjectUtil.getCompiler(cfg);
        if (tools != null) {
            IOption option = tools.getOptionBySuperClassId(optionName);
            return option.getValue();
        }
        return null;
    }

    public static Architecture getEditorArch(ICProjectDescription projectDesc) {
        ICConfigurationDescription configuration = projectDesc.getActiveConfiguration();
        return CudaProjectUtil.getEditorArch((ICResourceDescription)configuration.getRootFolderDescription());
    }

    public static Architecture getEditorArch(ICResourceDescription cfg) {
        try {
            if (cfg != null) {
                ICConfigurationDescription conf = cfg.getConfiguration();
                ICudaProjectConfiguration configuration = ProjectMetaManager.load(conf);
                return configuration.getEditorArchitecture();
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return Architecture.get(1, 0);
    }

    public static ICResourceDescription getFileDescription(IResource file, ICConfigurationDescription configuration) throws CoreException {
        IPath path = file.getProjectRelativePath();
        ICResourceDescription description = configuration.getResourceDescription(path, false);
        if (!description.getPath().equals((Object)path.makeRelative())) {
            description = configuration.createFileDescription(path, description);
        }
        return description;
    }

    private static boolean isCompiler(ITool tool) {
        if (tool == null) {
            return false;
        }
        if (NVCC_COMPILER.equals(tool.getId())) {
            return true;
        }
        return CudaProjectUtil.isCompiler(tool.getSuperClass());
    }

    public static boolean isToolWithId(ITool tool, String id) {
        if (tool == null) {
            return false;
        }
        if (id.equals(tool.getId())) {
            return true;
        }
        return CudaProjectUtil.isToolWithId(tool.getSuperClass(), id);
    }

    public static void setCompilerOptionValue(ICResourceDescription cfg, String optionName, boolean value) {
        ITool tool = CudaProjectUtil.getCompiler(cfg);
        if (tool != null) {
            IOption option = tool.getOptionBySuperClassId(optionName);
            ManagedBuildManager.setOption((IResourceInfo)tool.getParentResourceInfo(), (IHoldsOptions)tool, (IOption)option, (boolean)value);
        }
    }

    public static void setCompilerOptionValue(ICResourceDescription cfg, String optionName, String value) {
        ITool tool = CudaProjectUtil.getCompiler(cfg);
        if (tool != null) {
            IOption option = tool.getOptionBySuperClassId(optionName);
            ManagedBuildManager.setOption((IResourceInfo)tool.getParentResourceInfo(), (IHoldsOptions)tool, (IOption)option, (String)value);
        }
    }

    public static void setCompilerOptionValue(ICResourceDescription cfg, String optionName, String[] value) {
        ITool tool = CudaProjectUtil.getCompiler(cfg);
        if (tool != null) {
            IOption option = tool.getOptionBySuperClassId(optionName);
            ManagedBuildManager.setOption((IResourceInfo)tool.getParentResourceInfo(), (IHoldsOptions)tool, (IOption)option, (String[])value);
        }
    }

    private static List<String> toStringArray(int archs) {
        return Arrays.asList(Architecture.convertToCommandLineOptions(true, archs));
    }
}

