/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ext.SourceRange;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.SelectionHistory;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public abstract class StructureSelectionAction
extends TextEditorAction {
    protected final SelectionHistory history;
    public static final String ENCLOSING = "StructureSelectEnclosing";
    public static final String NEXT = "StructureSelectNext";
    public static final String PREVIOUS = "StructureSelectPrevious";
    public static final String HISTORY = "StructureSelectHistory";

    protected StructureSelectionAction(ResourceBundle bundle, String prefix, ITextEditor editor, SelectionHistory history) {
        super(bundle, prefix, editor);
        this.history = history;
    }

    public void run() {
        ITextSelection selection;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof CEditor)) {
            return;
        }
        CEditor cEditor = (CEditor)editorPart;
        ITranslationUnit tu = (ITranslationUnit)CDTUITools.getEditorInputCElement(cEditor.getEditorInput());
        try {
            selection = (ITextSelection)cEditor.getSelectionProvider().getSelection();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        ExpandSelectionJob expandSelectionJob = new ExpandSelectionJob("expand selection", tu, cEditor, new SourceRange(offset, length));
        expandSelectionJob.schedule();
        try {
            expandSelectionJob.join();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (expandSelectionJob.newSourceRange != null) {
            this.history.ignoreSelectionChanges();
            cEditor.setSelection(expandSelectionJob.newSourceRange, true);
            this.history.listenToSelectionChanges();
        }
    }

    protected abstract ISourceRange doExpand(IASTTranslationUnit var1, SourceRange var2);

    protected boolean nodeContains(IASTNode node, int position) {
        IASTFileLocation fl = node.getFileLocation();
        return position >= fl.getNodeOffset() && position <= fl.getNodeOffset() + fl.getNodeLength();
    }

    protected boolean samePosition(IASTNode node, SourceRange current) {
        IASTFileLocation fl = node.getFileLocation();
        return fl.getNodeOffset() == current.getStartPos() && fl.getNodeLength() == current.getLength();
    }

    private final class ExpandSelectionJob
    extends SharedASTJob {
        public ISourceRange newSourceRange;
        private SourceRange currentSourceRange;

        private ExpandSelectionJob(String name, ITranslationUnit tUnit, CEditor cEditor, SourceRange range) {
            super(name, tUnit);
            this.currentSourceRange = range;
            this.newSourceRange = null;
        }

        @Override
        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
            this.newSourceRange = StructureSelectionAction.this.doExpand(ast, this.currentSourceRange);
            return Status.OK_STATUS;
        }
    }
}

