/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;

public class CrosstabMeasureRowExecutor
extends BaseRowExecutor {
    private static Logger logger = Logger.getLogger(CrosstabMeasureRowExecutor.class.getName());

    public CrosstabMeasureRowExecutor(BaseCrosstabExecutor parent, int rowIndex) {
        super(parent, rowIndex);
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.processRowHeight(this.findMeasureRowCell(this.rowIndex));
        this.prepareChildren();
        return content;
    }

    protected void prepareChildren() {
        super.prepareChildren();
        this.initMeasureCache();
        this.walker.reload();
    }

    private AggregationCellHandle getRowSubTotalCell(int colDimensionIndex, int colLevelIndex, int measureIndex) {
        return this.getAggregationCell(-1, -1, colDimensionIndex, colLevelIndex, measureIndex);
    }

    protected void advance() {
        int mx;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        this.nextExecutor = new CrosstabCellExecutor(this, null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        int n = mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        if (this.measureDetailStarted && this.isMeetMeasureDetailEnd(ev, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null)) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureDetailStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (this.measureSubTotalStarted) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureSubTotalStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.measureGrandTotalStarted) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.measureGrandTotalStarted = false;
                        this.hasLast = false;
                    }
                }
                if (this.isMeasureDetailNeedStart(ev)) {
                    this.measureDetailStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureSubTotalNeedStart(ev)) {
                    this.measureSubTotalStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureGrandTotalNeedStart(ev)) {
                    this.measureGrandTotalStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (ev.type == 1) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentEdgePosition = ev.dataPosition;
                this.currentChangeType = ev.type;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureRowExecutor.error.generate.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    this.nextExecutor = new CrosstabCellExecutor(this, null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 5: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
            }
            if (this.measureDetailStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureDetailStarted = false;
            } else if (this.measureSubTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureSubTotalStarted = false;
            } else if (this.measureGrandTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureGrandTotalStarted = false;
            }
        }
    }
}

