/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import org.eclipse.cdt.debug.core.model.IDisassemblyLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyRetrieval;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class DisassemblyElementProxy
extends AbstractModelProxy
implements IDebugEventSetListener {
    private Object fElement;

    public DisassemblyElementProxy(Object element) {
        this.fElement = element;
    }

    public void installed(Viewer viewer) {
        super.installed(viewer);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fireModelChanged((IModelDelta)new ModelDelta(this.fElement, 1024));
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            int kind = event.getKind();
            int detail = event.getDetail();
            if (source instanceof IDisassemblyLine && kind == 16 && detail == 256) {
                IDisassemblyLine line = (IDisassemblyLine)source;
                DisassemblyRetrieval dr = ((CDebugTarget)line.getDebugTarget()).getDisassemblyRetrieval();
                if (this.getElement().equals(dr)) {
                    this.fireModelChanged(this.createDelta(line));
                }
            }
            ++n2;
        }
    }

    public synchronized void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    protected Object getElement() {
        return this.fElement;
    }

    protected IModelDelta createDelta(IDisassemblyLine line) {
        DisassemblyRetrieval dr = ((CDebugTarget)line.getDebugTarget()).getDisassemblyRetrieval();
        ModelDelta delta = new ModelDelta((Object)dr, 0);
        delta.addNode((Object)line, 2048);
        return delta;
    }
}

