/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.NewDateTagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.CVSFileElement;
import org.eclipse.team.internal.ccvs.ui.tags.MultiFolderTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFileTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagSourceResourceAdapter;
import org.eclipse.team.internal.ccvs.ui.tags.TagSourceWorkbenchAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagConfigurationDialog
extends TrayDialog {
    private TreeViewer cvsResourceTree;
    private CheckboxTableViewer cvsTagTree;
    private TreeViewer cvsDefinedTagsTree;
    private TagSourceWorkbenchAdapter cvsDefinedTagsRootElement;
    private org.eclipse.swt.widgets.List autoRefreshFileList;
    private boolean allowSettingAutoRefreshFiles = true;
    private final String ALLOWREFRESH_WIDTH_KEY = "AllowRefreshWidth";
    private final String ALLOWREFRESH_HEIGHT_KEY = "AllowRefreshHeight";
    private final String NOREFRESH_WIDTH_KEY = "NoRefreshWidth";
    private final String NOREFRESH_HEIGHT_KEY = "NoRefreshHeight";
    private Button addSelectedTagsButton;
    private Button addSelectedFilesButton;
    private Button removeFileButton;
    private Button removeTagButton;
    private IDialogSettings settings;
    private final TagSource tagSource;
    private final TagSourceWrapper wrappedTagSource;

    public TagConfigurationDialog(Shell shell, TagSource tagSource) {
        super(shell);
        this.tagSource = tagSource;
        this.wrappedTagSource = new TagSourceWrapper(tagSource);
        this.setShellStyle(65616);
        this.allowSettingAutoRefreshFiles = this.getSingleFolder(tagSource, false) != null;
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("TagConfigurationDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("TagConfigurationDialog");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)CVSUIMessages.TagConfigurationDialog_1, (Object[])new String[]{this.tagSource.getShortDescription()}));
    }

    protected Control createDialogArea(Composite parent) {
        Composite shell = new Composite(parent, 0);
        GridData data = new GridData(1808);
        shell.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        shell.setLayout((Layout)gridLayout);
        Composite comp = new Composite(shell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label cvsResourceTreeLabel = new Label(comp, 0);
        cvsResourceTreeLabel.setText(CVSUIMessages.TagConfigurationDialog_5);
        data = new GridData();
        data.horizontalSpan = 1;
        cvsResourceTreeLabel.setLayoutData((Object)data);
        Tree tree = new Tree(comp, 2050);
        this.cvsResourceTree = new TreeViewer(tree);
        this.cvsResourceTree.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.cvsResourceTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 1;
        this.cvsResourceTree.getTree().setLayoutData((Object)data);
        this.cvsResourceTree.setComparator((ViewerComparator)new FileComparator());
        this.cvsResourceTree.setInput(TagSourceResourceAdapter.getViewerInput(this.tagSource));
        this.cvsResourceTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        comp = new Composite(shell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label cvsTagTreeLabel = new Label(comp, 0);
        cvsTagTreeLabel.setText(CVSUIMessages.TagConfigurationDialog_6);
        data = new GridData();
        data.horizontalSpan = 1;
        cvsTagTreeLabel.setLayoutData((Object)data);
        final Table table = new Table(comp, 68386);
        data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        this.cvsTagTree = new CheckboxTableViewer(table);
        this.cvsTagTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.cvsTagTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.cvsTagTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        Composite selectComp = new Composite(comp, 0);
        GridLayout selectLayout = new GridLayout(2, true);
        selectLayout.marginWidth = 0;
        selectLayout.marginHeight = 0;
        selectComp.setLayout((Layout)selectLayout);
        selectComp.setLayoutData((Object)new GridData(768));
        Button selectAllButton = new Button(selectComp, 8);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText(CVSUIMessages.ReleaseCommentDialog_selectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nItems = table.getItemCount();
                int j = 0;
                while (j < nItems) {
                    table.getItem(j).setChecked(true);
                    ++j;
                }
            }
        });
        Button deselectAllButton = new Button(selectComp, 8);
        deselectAllButton.setLayoutData((Object)new GridData(768));
        deselectAllButton.setText(CVSUIMessages.ReleaseCommentDialog_deselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nItems = table.getItemCount();
                int j = 0;
                while (j < nItems) {
                    table.getItem(j).setChecked(false);
                    ++j;
                }
            }
        });
        this.cvsTagTree.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof TagElement) || !(e2 instanceof TagElement)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = ((TagElement)e1).getTag();
                CVSTag tag2 = ((TagElement)e2).getTag();
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type1 - type2;
                }
                return -tag1.compareTo(tag2);
            }
        });
        Composite rememberedTags = new Composite(shell, 0);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        rememberedTags.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rememberedTags.setLayout((Layout)gridLayout);
        Label rememberedTagsLabel = new Label(rememberedTags, 0);
        rememberedTagsLabel.setText(CVSUIMessages.TagConfigurationDialog_7);
        data = new GridData();
        data.horizontalSpan = 2;
        rememberedTagsLabel.setLayoutData((Object)data);
        tree = new Tree(rememberedTags, 2050);
        this.cvsDefinedTagsTree = new TreeViewer(tree);
        this.cvsDefinedTagsTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.cvsDefinedTagsTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.cvsDefinedTagsTree.getTree().setLayoutData((Object)data);
        this.cvsDefinedTagsRootElement = new TagSourceWorkbenchAdapter(this.wrappedTagSource, 28);
        this.cvsDefinedTagsTree.setInput((Object)this.cvsDefinedTagsRootElement);
        this.cvsDefinedTagsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        this.cvsDefinedTagsTree.setComparator((ViewerComparator)new TagSourceWorkbenchAdapter.ProjectElementComparator());
        Composite buttonComposite = new Composite(rememberedTags, 0);
        data = new GridData();
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        this.addSelectedTagsButton = new Button(buttonComposite, 8);
        this.addSelectedTagsButton.setText(CVSUIMessages.TagConfigurationDialog_8);
        data = this.getStandardButtonData(this.addSelectedTagsButton);
        data.horizontalAlignment = 4;
        this.addSelectedTagsButton.setLayoutData((Object)data);
        this.addSelectedTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.rememberCheckedTags();
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        Button addDatesButton = new Button(buttonComposite, 8);
        addDatesButton.setText(CVSUIMessages.TagConfigurationDialog_0);
        data = this.getStandardButtonData(addDatesButton);
        data.horizontalAlignment = 4;
        addDatesButton.setLayoutData((Object)data);
        addDatesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSTag dateTag = NewDateTagAction.getDateTag(TagConfigurationDialog.this.getShell(), TagConfigurationDialog.this.tagSource.getLocation());
                TagConfigurationDialog.this.addDateTagsSelected(dateTag);
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        this.removeTagButton = new Button(buttonComposite, 8);
        this.removeTagButton.setText(CVSUIMessages.TagConfigurationDialog_9);
        data = this.getStandardButtonData(this.removeTagButton);
        data.horizontalAlignment = 4;
        this.removeTagButton.setLayoutData((Object)data);
        this.removeTagButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.deleteSelected();
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        Button removeAllTags = new Button(buttonComposite, 8);
        removeAllTags.setText(CVSUIMessages.TagConfigurationDialog_10);
        data = this.getStandardButtonData(removeAllTags);
        data.horizontalAlignment = 4;
        removeAllTags.setLayoutData((Object)data);
        removeAllTags.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.removeAllKnownTags();
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        if (this.allowSettingAutoRefreshFiles) {
            Label explanation = new Label(rememberedTags, 64);
            explanation.setText(CVSUIMessages.TagConfigurationDialog_11);
            data = new GridData();
            data.horizontalSpan = 2;
            explanation.setLayoutData((Object)data);
            this.autoRefreshFileList = new org.eclipse.swt.widgets.List(rememberedTags, 2050);
            data = new GridData();
            data.heightHint = 45;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.autoRefreshFileList.setLayoutData((Object)data);
            try {
                this.autoRefreshFileList.setItems(CVSUIPlugin.getPlugin().getRepositoryManager().getAutoRefreshFiles(this.getSingleFolder(this.tagSource, false)));
            }
            catch (CVSException e) {
                this.autoRefreshFileList.setItems(new String[0]);
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            this.autoRefreshFileList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TagConfigurationDialog.this.updateEnablements();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TagConfigurationDialog.this.updateEnablements();
                }
            });
            Composite buttonComposite2 = new Composite(rememberedTags, 0);
            data = new GridData();
            data.verticalAlignment = 1;
            buttonComposite2.setLayoutData((Object)data);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonComposite2.setLayout((Layout)gridLayout);
            this.addSelectedFilesButton = new Button(buttonComposite2, 8);
            this.addSelectedFilesButton.setText(CVSUIMessages.TagConfigurationDialog_12);
            data = this.getStandardButtonData(this.addSelectedFilesButton);
            data.horizontalAlignment = 4;
            this.addSelectedFilesButton.setLayoutData((Object)data);
            this.addSelectedFilesButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TagConfigurationDialog.this.addSelectionToAutoRefreshList();
                }
            });
            this.removeFileButton = new Button(buttonComposite2, 8);
            this.removeFileButton.setText(CVSUIMessages.TagConfigurationDialog_13);
            data = this.getStandardButtonData(this.removeFileButton);
            data.horizontalAlignment = 4;
            this.removeFileButton.setLayoutData((Object)data);
            this.removeFileButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String[] selected = TagConfigurationDialog.this.autoRefreshFileList.getSelection();
                    int i = 0;
                    while (i < selected.length) {
                        TagConfigurationDialog.this.autoRefreshFileList.remove(selected[i]);
                        TagConfigurationDialog.this.autoRefreshFileList.setFocus();
                        ++i;
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.autoRefreshFileList, "org.eclipse.team.cvs.ui.tag_configuration_refreshlist");
        }
        Label seperator = new Label(shell, 258);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.team.cvs.ui.tag_configuration_overview");
        this.updateEnablements();
        Dialog.applyDialogFont((Control)parent);
        return shell;
    }

    private void updateShownTags() {
        final CVSFileElement[] filesSelection = this.getSelectedFiles();
        final HashSet tags = new HashSet();
        if (filesSelection.length != 0) {
            try {
                CVSUIPlugin.runWithProgress(this.getShell(), true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(CVSUIMessages.TagConfigurationDialog_22, filesSelection.length);
                        try {
                            try {
                                int i = 0;
                                while (i < filesSelection.length) {
                                    ICVSFile file = filesSelection[i].getCVSFile();
                                    tags.addAll(Arrays.asList(TagConfigurationDialog.this.getTagsFor(file, Policy.subMonitorFor(monitor, 1))));
                                    ++i;
                                }
                            }
                            catch (TeamException teamException) {
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            this.cvsTagTree.getTable().removeAll();
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                CVSTag tag = (CVSTag)it.next();
                ArrayList<CVSTag> knownTags = new ArrayList<CVSTag>();
                knownTags.addAll(Arrays.asList(this.wrappedTagSource.getTags(new int[]{2, 1, 3})));
                if (knownTags.contains(tag)) continue;
                TagElement tagElem = new TagElement(tag);
                this.cvsTagTree.add((Object)tagElem);
                this.cvsTagTree.setChecked((Object)tagElem, true);
            }
        }
    }

    private CVSFileElement[] getSelectedFiles() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsResourceTree.getSelection();
        if (!selection.isEmpty()) {
            ArrayList filesSelection = new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof CVSFileElement)) continue;
                filesSelection.add(o);
            }
            return filesSelection.toArray(new CVSFileElement[filesSelection.size()]);
        }
        return new CVSFileElement[0];
    }

    private void addSelectionToAutoRefreshList() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsResourceTree.getSelection();
        if (!selection.isEmpty()) {
            ArrayList filesSelection = new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof CVSFileElement)) continue;
                filesSelection.add(o);
            }
            if (!filesSelection.isEmpty()) {
                it = filesSelection.iterator();
                while (it.hasNext()) {
                    try {
                        ICVSFile file = ((CVSFileElement)it.next()).getCVSFile();
                        ICVSFolder fileParent = file.getParent();
                        String filePath = new Path(null, fileParent.getFolderSyncInfo().getRepository()).append(file.getRelativePath(fileParent)).toString();
                        if (this.autoRefreshFileList.indexOf(filePath) != -1) continue;
                        this.autoRefreshFileList.add(filePath);
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.openError(this.getShell(), null, null, e);
                    }
                }
            }
        }
    }

    private CVSTag[] getTagsFor(ICVSFile file, IProgressMonitor monitor) throws TeamException {
        return SingleFileTagSource.fetchTagsFor(file, monitor);
    }

    private void rememberCheckedTags() {
        Object[] checked = this.cvsTagTree.getCheckedElements();
        ArrayList<CVSTag> tagsToAdd = new ArrayList<CVSTag>();
        int i = 0;
        while (i < checked.length) {
            CVSTag tag = ((TagElement)checked[i]).getTag();
            tagsToAdd.add(tag);
            ++i;
        }
        if (!tagsToAdd.isEmpty()) {
            this.wrappedTagSource.add(tagsToAdd.toArray(new CVSTag[tagsToAdd.size()]));
            this.cvsDefinedTagsTree.refresh();
        }
    }

    private void deleteSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsDefinedTagsTree.getSelection();
        ArrayList<CVSTag> tagsToRemove = new ArrayList<CVSTag>();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof TagElement)) continue;
                CVSTag tag = ((TagElement)o).getTag();
                tagsToRemove.add(tag);
            }
        }
        if (!tagsToRemove.isEmpty()) {
            this.wrappedTagSource.remove(tagsToRemove.toArray(new CVSTag[tagsToRemove.size()]));
            this.cvsDefinedTagsTree.refresh();
            this.cvsDefinedTagsTree.getTree().setFocus();
        }
    }

    private void addDateTagsSelected(CVSTag tag) {
        if (tag == null) {
            return;
        }
        ArrayList<CVSTag> knownTags = new ArrayList<CVSTag>();
        knownTags.addAll(Arrays.asList(this.wrappedTagSource.getTags(3)));
        if (!knownTags.contains(tag)) {
            this.wrappedTagSource.add(new CVSTag[]{tag});
            this.cvsDefinedTagsTree.refresh();
            this.cvsDefinedTagsTree.getTree().setFocus();
        }
    }

    private boolean isTagSelectedInKnownTagTree() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsDefinedTagsTree.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof TagElement)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeAllKnownTags() {
        this.wrappedTagSource.removeAll();
        this.cvsDefinedTagsTree.refresh();
    }

    private void updateEnablements() {
        Object[] checked = this.cvsTagTree.getCheckedElements();
        this.addSelectedTagsButton.setEnabled(checked.length != 0);
        this.removeTagButton.setEnabled(this.isTagSelectedInKnownTagTree());
        if (this.allowSettingAutoRefreshFiles) {
            this.addSelectedFilesButton.setEnabled(this.getSelectedFiles().length != 0);
            this.removeFileButton.setEnabled(this.autoRefreshFileList.getSelection().length != 0);
        }
    }

    protected void okPressed() {
        try {
            if (this.allowSettingAutoRefreshFiles) {
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                manager.setAutoRefreshFiles(this.getSingleFolder(this.tagSource, false), this.autoRefreshFileList.getItems());
            }
            this.wrappedTagSource.commit(null);
            super.okPressed();
        }
        catch (CVSException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
    }

    protected ICVSFolder getSingleFolder(TagSource tagSource, boolean bestEffort) {
        if (!bestEffort && tagSource instanceof MultiFolderTagSource) {
            return null;
        }
        if (tagSource instanceof SingleFolderTagSource) {
            return ((SingleFolderTagSource)tagSource).getFolder();
        }
        return null;
    }

    protected Point getInitialSize() {
        int width;
        int height;
        if (this.allowSettingAutoRefreshFiles) {
            try {
                height = this.settings.getInt("AllowRefreshHeight");
                width = this.settings.getInt("AllowRefreshWidth");
            }
            catch (NumberFormatException numberFormatException) {
                return super.getInitialSize();
            }
        }
        try {
            height = this.settings.getInt("NoRefreshHeight");
            width = this.settings.getInt("NoRefreshWidth");
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
        return new Point(width, height);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private GridData getStandardButtonData(Button button) {
        GridData data = new GridData();
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        return data;
    }

    public boolean close() {
        if (this.getTray() != null) {
            this.closeTray();
        }
        Rectangle bounds = this.getShell().getBounds();
        if (this.allowSettingAutoRefreshFiles) {
            this.settings.put("AllowRefreshHeight", bounds.height);
            this.settings.put("AllowRefreshWidth", bounds.width);
        } else {
            this.settings.put("NoRefreshHeight", bounds.height);
            this.settings.put("NoRefreshWidth", bounds.width);
        }
        return super.close();
    }

    class FileComparator
    extends ViewerComparator {
        FileComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean oneIsFile = e1 instanceof CVSFileElement;
            boolean twoIsFile = e2 instanceof CVSFileElement;
            if (oneIsFile != twoIsFile) {
                return oneIsFile ? 1 : -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class TagSourceWrapper
    extends TagSource {
        private final TagSource tagSource;
        private final List branches = new ArrayList();
        private final List versions = new ArrayList();
        private final List dates = new ArrayList();

        public TagSourceWrapper(TagSource tagSource) {
            this.tagSource = tagSource;
            this.branches.addAll(Arrays.asList(tagSource.getTags(1)));
            this.versions.addAll(Arrays.asList(tagSource.getTags(2)));
            this.dates.addAll(Arrays.asList(tagSource.getTags(3)));
        }

        public CVSTag[] getTags(int type) {
            if (type == 0 || type == -1) {
                return super.getTags(type);
            }
            List list = this.getTagList(type);
            if (list != null) {
                return list.toArray(new CVSTag[list.size()]);
            }
            return this.tagSource.getTags(type);
        }

        private List getTagList(int type) {
            switch (type) {
                case 2: {
                    return this.versions;
                }
                case 1: {
                    return this.branches;
                }
                case 3: {
                    return this.dates;
                }
            }
            return null;
        }

        public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
            return new CVSTag[0];
        }

        public ICVSRepositoryLocation getLocation() {
            return this.tagSource.getLocation();
        }

        public String getShortDescription() {
            return this.tagSource.getShortDescription();
        }

        public void remove(CVSTag[] tags) {
            int i = 0;
            while (i < tags.length) {
                CVSTag tag = tags[i];
                List list = this.getTagList(tag.getType());
                if (list != null) {
                    list.remove(tag);
                }
                ++i;
            }
        }

        public void add(CVSTag[] tags) {
            int i = 0;
            while (i < tags.length) {
                CVSTag tag = tags[i];
                List list = this.getTagList(tag.getType());
                if (list != null) {
                    list.add(tag);
                }
                ++i;
            }
        }

        public void removeAll() {
            this.versions.clear();
            this.branches.clear();
            this.dates.clear();
        }

        public void commit(IProgressMonitor monitor) throws CVSException {
            this.tagSource.commit(this.getTags(new int[]{2, 1, 3}), true, monitor);
        }

        public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
        }

        public ICVSResource[] getCVSResources() {
            return this.tagSource.getCVSResources();
        }
    }
}

