/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitUtil {
    private CommitUtil() {
    }

    public static List<RevCommit> sortCommits(Collection<RevCommit> commits) {
        RevCommit childCommit;
        HashMap<RevCommit, RevCommit> parentToChild = new HashMap<RevCommit, RevCommit>();
        RevCommit firstCommit = null;
        for (RevCommit commit : commits) {
            RevCommit parentCommit = commit.getParent(0);
            parentToChild.put(parentCommit, commit);
            if (commits.contains(parentCommit)) continue;
            firstCommit = commit;
        }
        ArrayList<RevCommit> sortedCommits = new ArrayList<RevCommit>();
        sortedCommits.add(firstCommit);
        RevCommit parentCommit = firstCommit;
        while ((childCommit = (RevCommit)parentToChild.get(parentCommit)) != null) {
            sortedCommits.add(childCommit);
            parentCommit = childCommit;
        }
        return sortedCommits;
    }

    public static boolean isCommitInCurrentBranch(RevCommit commit, Repository repository) throws IOException {
        return CommitUtil.areCommitsInCurrentBranch(Collections.singleton(commit), repository);
    }

    public static boolean areCommitsInCurrentBranch(Collection<RevCommit> commits, Repository repository) throws IOException {
        RevWalk walk = new RevWalk(repository);
        ObjectId headCommitId = repository.resolve("HEAD");
        RevCommit headCommit = walk.parseCommit((AnyObjectId)headCommitId);
        for (final RevCommit commit : commits) {
            walk.reset();
            walk.markStart(headCommit);
            RevFilter revFilter = new RevFilter(){

                public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
                    return cmit.equals((AnyObjectId)commit);
                }

                public RevFilter clone() {
                    return null;
                }
            };
            walk.setRevFilter(revFilter);
            if (walk.next() != null) continue;
            return false;
        }
        return true;
    }
}

