/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_DNSProtocolEndpoint.h"
#include "OpenDRIM_DNSProtocolEndpointAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define DNS_OpenDRIM_DNSProtocolEndpointProviderSetInstance DNS_OpenDRIM_DNSProtocolEndpointProviderModifyInstance
#endif

int DNS_OpenDRIM_DNSProtocolEndpoint_init(const CMPIBroker* broker);

int DNS_OpenDRIM_DNSProtocolEndpoint_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_DNSProtocolEndpoint> instances;
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = DNS_OpenDRIM_DNSProtocolEndpoint_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_DNSProtocolEndpoint> instances;
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = DNS_OpenDRIM_DNSProtocolEndpoint_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_DNSProtocolEndpoint instance;
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = DNS_OpenDRIM_DNSProtocolEndpoint_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_DNSProtocolEndpoint newInstance, oldInstance;
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, ci, newInstance);
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_DNSProtocolEndpoint instance;
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = DNS_OpenDRIM_DNSProtocolEndpoint_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_DNSProtocolEndpoint instance;
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus DNS_OpenDRIM_DNSProtocolEndpointProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_DNSProtocolEndpoint instance;
	DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"SystemCreationClassName", "Name", "SystemName", "CreationClassName"};
	int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_DNSProtocolEndpoint_RequestStateChange_In inArgs;
		DNS_OpenDRIM_DNSProtocolEndpoint_toCPP(_broker, in, inArgs);
		OpenDRIM_DNSProtocolEndpoint_RequestStateChange_Out outArgs;
		
		errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		DNS_OpenDRIM_DNSProtocolEndpoint_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int DNS_OpenDRIM_DNSProtocolEndpoint_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "DNS_OpenDRIM_DNSProtocolEndpoint_init FAILED: " + (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSProtocolEndpoint_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = DNS_OpenDRIM_DNSProtocolEndpoint_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "DNS_OpenDRIM_DNSProtocolEndpoint_unload FAILED: " + (string) OpenDRIM_DNSProtocolEndpoint_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define DNS_OpenDRIM_DNSProtocolEndpoint_INIT if (DNS_OpenDRIM_DNSProtocolEndpoint_init(_broker) < 0) return NULL

CMInstanceMIStub(DNS_OpenDRIM_DNSProtocolEndpointProvider, DNS_OpenDRIM_DNSProtocolEndpointProvider, _broker, DNS_OpenDRIM_DNSProtocolEndpoint_INIT);
CMMethodMIStub(DNS_OpenDRIM_DNSProtocolEndpointProvider, DNS_OpenDRIM_DNSProtocolEndpointProvider, _broker, DNS_OpenDRIM_DNSProtocolEndpoint_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
