# Print Arch Linux packages providing given commands list.
# USAGE: dependencies_commands_list_archlinux $dependencies_commands
dependencies_commands_list_archlinux() {
	local dependencies_commands
	dependencies_commands="$1"

	local dependency_command
	while read -r dependency_command; do
		dependencies_command_single_archlinux "$dependency_command"
	done <<- EOL
	$(printf '%s' "$dependencies_commands")
	EOL
}

# Print Arch Linux packages providing given single command.
# USAGE: dependencies_command_single_archlinux $dependency_command
dependencies_command_single_archlinux() {
	local dependency_command
	dependency_command="$1"

	local package_names
	case "$dependency_command" in
		('7za')
			package_names='
			extra/p7zip'
		;;
		('corsix-th')
			package_names='
			corsix-th'
		;;
		('dos2unix')
			package_names='
			dos2unix'
		;;
		('dosbox')
			package_names='
			dosbox'
		;;
		('godot3-runner')
			# The Godot 3 runtime is not provided by Arch Linux, not even in the AUR
			return 0
		;;
		('firefox')
			package_names='
			firefox'
		;;
		('java')
			package_names='
			jre8-openjdk'
		;;
		('julius')
			package_names='
			julius'
		;;
		('mono')
			package_names='
			mono'
		;;
		('mpv')
			package_names='
			mpv'
		;;
		('openmw-iniimporter')
			package_names='
			openmw'
		;;
		('openmw-launcher')
			package_names='
			openmw'
		;;
		('pidwait')
			package_names='
			procps-ng'
		;;
		('pulseaudio')
			package_names='
			pulseaudio'
		;;
		('python3')
			package_names='
			python'
		;;
		('renpy')
			package_names='
			renpy'
		;;
		('scummvm')
			package_names='
			scummvm'
		;;
		('sed')
			package_names='
			sed'
		;;
		('setxkbmap')
			package_names='
			xorg-setxkbmap'
		;;
		('terminal_wrapper')
			package_names='
			xterm'
		;;
		('vcmilauncher')
			package_names='
			vcmi'
		;;
		('wine')
			package_names='
			wine'
		;;
		('winetricks')
			package_names='
			winetricks'
		;;
		('xgamma')
			package_names='
			xorg-xgamma'
		;;
		('xrandr')
			package_names='
			xorg-xrandr'
		;;
		(*)
			dependencies_unknown_command_add "$dependency_command"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

