# Print Gentoo packages providing given GStreamer decoders list.
# USAGE: dependencies_gstreamer_list_gentoo $dependencies_gstreamer
dependencies_gstreamer_list_gentoo() {
	local dependencies_gstreamer
	dependencies_gstreamer="$1"

	local package package_architecture dependency_gstreamer
	package=$(current_package)
	package_architecture=$(package_architecture "$package")
	while read -r dependency_gstreamer; do
		case "$package_architecture" in
			('32')
				dependencies_gstreamer_single_gentoo_32bit "$dependency_gstreamer"
			;;
			(*)
				dependencies_gstreamer_single_gentoo "$dependency_gstreamer"
			;;
		esac
	done <<- EOL
	$(printf '%s' "$dependencies_gstreamer")
	EOL
}

# Print Gentoo packages providing given single GStreamer decoder.
# USAGE: dependencies_gstreamer_single_gentoo $dependency_gstreamer
dependencies_gstreamer_single_gentoo() {
	local dependency_gstreamer
	dependency_gstreamer="$1"

	local package_names
	case "$dependency_gstreamer" in
		('audioconvert')
			package_names='
			media-libs/gst-plugins-base'
		;;
		('avidemux')
			package_names='
			media-libs/gst-plugins-good'
		;;
		('decodebin')
			package_names='
			media-libs/gst-plugins-base'
		;;
		('deinterlace')
			package_names='
			media-libs/gst-plugins-good'
		;;
		('application/x-id3')
			package_names='
			media-libs/gst-plugins-good'
		;;
		('audio/mpeg, mpegversion=(int)1, layer=(int)3')
			package_names='
			media-libs/gst-plugins-good'
		;;
		( \
			'audio/x-wma' | \
			'audio/x-wma, wmaversion=(int)1' \
		)
			package_names='
			media-plugins/gst-plugins-libav'
		;;
		('video/mpeg, systemstream=(boolean)true, mpegversion=(int)1')
			package_names='
			media-libs/gst-plugins-ugly
			media-libs/gst-plugins-bad'
		;;
		('video/quicktime, variant=(string)iso')
			package_names='
			media-libs/gst-plugins-good
			media-plugins/gst-plugins-libav'
		;;
		('video/x-ms-asf')
			package_names='
			media-libs/gst-plugins-ugly
			media-plugins/gst-plugins-libav'
		;;
		('video/x-msvideo')
			package_names='
			media-libs/gst-plugins-good
			media-plugins/gst-plugins-libav'
		;;
		( \
			'video/x-wmv' | \
			'video/x-wmv, wmvversion=(int)1' \
		)
			package_names='
			media-plugins/gst-plugins-libav'
		;;
		(*)
			dependencies_unknown_gstreamer_media_formats_add "$dependency_gstreamer"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

# Print 32-bit Gentoo packages providing given single GStreamer decoder.
# USAGE: dependencies_gstreamer_single_gentoo_32bit $dependency_gstreamer
dependencies_gstreamer_single_gentoo_32bit() {
	local dependency_gstreamer
	dependency_gstreamer="$1"

	local package_names
	case "$dependency_gstreamer" in
		('audioconvert')
			package_names='
			media-libs/gst-plugins-base[abi_x86_32]'
		;;
		('avidemux')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]'
		;;
		('decodebin')
			package_names='
			media-libs/gst-plugins-base[abi_x86_32]'
		;;
		('deinterlace')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]'
		;;
		('application/x-id3')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]'
		;;
		('audio/mpeg, mpegversion=(int)1, layer=(int)3')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]'
		;;
		( \
			'audio/x-wma' | \
			'audio/x-wma, wmaversion=(int)1' \
		)
			package_names='
			media-plugins/gst-plugins-libav[abi_x86_32]'
		;;
		('video/mpeg, systemstream=(boolean)true, mpegversion=(int)1')
			package_names='
			media-libs/gst-plugins-ugly[abi_x86_32]
			media-libs/gst-plugins-bad[abi_x86_32]'
		;;
		('video/quicktime, variant=(string)iso')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]
			media-plugins/gst-plugins-libav[abi_x86_32]'
		;;
		('video/x-ms-asf')
			package_names='
			media-libs/gst-plugins-ugly[abi_x86_32]
			media-plugins/gst-plugins-libav[abi_x86_32]'
		;;
		('video/x-msvideo')
			package_names='
			media-libs/gst-plugins-good[abi_x86_32]
			media-plugins/gst-plugins-libav[abi_x86_32]'
		;;
		( \
			'video/x-wmv' | \
			'video/x-wmv, wmvversion=(int)1' \
		)
			package_names='
			media-plugins/gst-plugins-libav[abi_x86_32]'
		;;
		(*)
			dependencies_unknown_gstreamer_media_formats_add "$dependency_gstreamer"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

