/*
 * This file is part of FFmpeg.
 *
 * This table was generated from the long and short names of AVCodecs
 * please see the respective codec sources for authorship
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <string.h>

#include "libavutil/common.h"
#include "libavutil/internal.h"
#include "avcodec.h"
#include "version.h"

#if !defined(IDE_COMPILE) || (defined(IDE_COMPILE) && (_MSC_VER >= 1400))
#define MT(...) (const char *const[]){ __VA_ARGS__, NULL }
#endif

static const char *const tmp0[] = { "image/jpeg", ((void *)0) };
static const char *const tmp1[] = { "image/x-ms-bmp", ((void *)0) };
static const char *const tmp2[] = { "image/jp2", ((void *)0) };
static const char *const tmp3[] = { "image/gif", ((void *)0) };
static const char *const tmp4[] = { "image/x-portable-pixmap", ((void *)0) };
static const char *const tmp5[] = { "image/x-pcx", ((void *)0) };
static const char *const tmp6[] = { "image/png", ((void *)0) };
static const char *const tmp7[] = { "image/x-targa", "image/x-tga", ((void *)0) };
static const char *const tmp8[] = { "image/tiff", ((void *)0) };
static const char *const tmp9[] = { "image/webp", ((void *)0) };
static const char *const tmp10[] = { "image/x-xwindowdump", ((void *)0) };
static const char *const tmp11[] = { "application/x-truetype-font", "application/x-font", ((void *)0) };
static const char *const tmp12[] = { "application/vnd.ms-opentype", ((void *)0) };
static const char *const tmp13[] = { "application/octet-stream", ((void *)0) };

static const AVCodecDescriptor codec_descriptors[] = {
#ifdef IDE_COMPILE
	/* video codecs */
    {
        AV_CODEC_ID_MPEG1VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "mpeg1video",
        "MPEG-1 video",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_MPEG2VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "mpeg2video",
        "MPEG-2 video",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
#if FF_API_XVMC
    {
        AV_CODEC_ID_MPEG2VIDEO_XVMC,
        AVMEDIA_TYPE_VIDEO,
        "mpegvideo_xvmc",
        "MPEG-1/2 video XvMC (X-Video Motion Compensation)",
        AV_CODEC_PROP_LOSSY,
    },
#endif /* FF_API_XVMC */
    {
        AV_CODEC_ID_H261,
        AVMEDIA_TYPE_VIDEO,
        "h261",
        "H.261",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_H263,
        AVMEDIA_TYPE_VIDEO,
        "h263",
        "H.263 / H.263-1996, H.263+ / H.263-1998 / H.263 version 2",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_RV10,
        AVMEDIA_TYPE_VIDEO,
        "rv10",
        "RealVideo 1.0",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_RV20,
        AVMEDIA_TYPE_VIDEO,
        "rv20",
        "RealVideo 2.0",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_MJPEG,
        AVMEDIA_TYPE_VIDEO,
        "mjpeg",
        "Motion JPEG",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
        tmp0,
    },
    {
        AV_CODEC_ID_MJPEGB,
        AVMEDIA_TYPE_VIDEO,
        "mjpegb",
        "Apple MJPEG-B",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MPEG4,
        AVMEDIA_TYPE_VIDEO,
        "mpeg4",
        "MPEG-4 part 2",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_RAWVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "rawvideo",
        "raw video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MSMPEG4V1,
        AVMEDIA_TYPE_VIDEO,
        "msmpeg4v1",
        "MPEG-4 part 2 Microsoft variant version 1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MSMPEG4V2,
        AVMEDIA_TYPE_VIDEO,
        "msmpeg4v2",
        "MPEG-4 part 2 Microsoft variant version 2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MSMPEG4V3,
        AVMEDIA_TYPE_VIDEO,
        "msmpeg4v3",
        "MPEG-4 part 2 Microsoft variant version 3",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMV1,
        AVMEDIA_TYPE_VIDEO,
        "wmv1",
        "Windows Media Video 7",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMV2,
        AVMEDIA_TYPE_VIDEO,
        "wmv2",
        "Windows Media Video 8",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_H263P,
        AVMEDIA_TYPE_VIDEO,
        "h263p",
        "H.263+ / H.263-1998 / H.263 version 2",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_H263I,
        AVMEDIA_TYPE_VIDEO,
        "h263i",
        "Intel H.263",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_FLV1,
        AVMEDIA_TYPE_VIDEO,
        "flv1",
        "FLV / Sorenson Spark / Sorenson H.263 (Flash Video)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SVQ1,
        AVMEDIA_TYPE_VIDEO,
        "svq1",
        "Sorenson Vector Quantizer 1 / Sorenson Video 1 / SVQ1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SVQ3,
        AVMEDIA_TYPE_VIDEO,
        "svq3",
        "Sorenson Vector Quantizer 3 / Sorenson Video 3 / SVQ3",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_DVVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "dvvideo",
        "DV (Digital Video)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_HUFFYUV,
        AVMEDIA_TYPE_VIDEO,
        "huffyuv",
        "HuffYUV",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_CYUV,
        AVMEDIA_TYPE_VIDEO,
        "cyuv",
        "Creative YUV (CYUV)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_H264,
        AVMEDIA_TYPE_VIDEO,
        "h264",
        "H.264 / AVC / MPEG-4 AVC / MPEG-4 part 10",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_INDEO3,
        AVMEDIA_TYPE_VIDEO,
        "indeo3",
        "Intel Indeo 3",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP3,
        AVMEDIA_TYPE_VIDEO,
        "vp3",
        "On2 VP3",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_THEORA,
        AVMEDIA_TYPE_VIDEO,
        "theora",
        "Theora",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ASV1,
        AVMEDIA_TYPE_VIDEO,
        "asv1",
        "ASUS V1",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ASV2,
        AVMEDIA_TYPE_VIDEO,
        "asv2",
        "ASUS V2",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FFV1,
        AVMEDIA_TYPE_VIDEO,
        "ffv1",
        "FFmpeg video codec #1",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_4XM,
        AVMEDIA_TYPE_VIDEO,
        "4xm",
        "4X Movie",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VCR1,
        AVMEDIA_TYPE_VIDEO,
        "vcr1",
        "ATI VCR1",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CLJR,
        AVMEDIA_TYPE_VIDEO,
        "cljr",
        "Cirrus Logic AccuPak",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MDEC,
        AVMEDIA_TYPE_VIDEO,
        "mdec",
        "Sony PlayStation MDEC (Motion DECoder)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ROQ,
        AVMEDIA_TYPE_VIDEO,
        "roq",
        "id RoQ video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_INTERPLAY_VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "interplayvideo",
        "Interplay MVE video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_XAN_WC3,
        AVMEDIA_TYPE_VIDEO,
        "xan_wc3",
        "Wing Commander III / Xan",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_XAN_WC4,
        AVMEDIA_TYPE_VIDEO,
        "xan_wc4",
        "Wing Commander IV / Xxan",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_RPZA,
        AVMEDIA_TYPE_VIDEO,
        "rpza",
        "QuickTime video (RPZA)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CINEPAK,
        AVMEDIA_TYPE_VIDEO,
        "cinepak",
        "Cinepak",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WS_VQA,
        AVMEDIA_TYPE_VIDEO,
        "ws_vqa",
        "Westwood Studios VQA (Vector Quantized Animation) video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MSRLE,
        AVMEDIA_TYPE_VIDEO,
        "msrle",
        "Microsoft RLE",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MSVIDEO1,
        AVMEDIA_TYPE_VIDEO,
        "msvideo1",
        "Microsoft Video 1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_IDCIN,
        AVMEDIA_TYPE_VIDEO,
        "idcin",
        "id Quake II CIN video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_8BPS,
        AVMEDIA_TYPE_VIDEO,
        "8bps",
        "QuickTime 8BPS video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_SMC,
        AVMEDIA_TYPE_VIDEO,
        "smc",
        "QuickTime Graphics (SMC)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FLIC,
        AVMEDIA_TYPE_VIDEO,
        "flic",
        "Autodesk Animator Flic video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TRUEMOTION1,
        AVMEDIA_TYPE_VIDEO,
        "truemotion1",
        "Duck TrueMotion 1.0",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VMDVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "vmdvideo",
        "Sierra VMD video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MSZH,
        AVMEDIA_TYPE_VIDEO,
        "mszh",
        "LCL (LossLess Codec Library) MSZH",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ZLIB,
        AVMEDIA_TYPE_VIDEO,
        "zlib",
        "LCL (LossLess Codec Library) ZLIB",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_QTRLE,
        AVMEDIA_TYPE_VIDEO,
        "qtrle",
        "QuickTime Animation (RLE) video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_SNOW,
        AVMEDIA_TYPE_VIDEO,
        "snow",
        "Snow",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TSCC,
        AVMEDIA_TYPE_VIDEO,
        "tscc",
        "TechSmith Screen Capture Codec",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ULTI,
        AVMEDIA_TYPE_VIDEO,
        "ulti",
        "IBM UltiMotion",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_QDRAW,
        AVMEDIA_TYPE_VIDEO,
        "qdraw",
        "Apple QuickDraw",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_VIXL,
        AVMEDIA_TYPE_VIDEO,
        "vixl",
        "Miro VideoXL",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_QPEG,
        AVMEDIA_TYPE_VIDEO,
        "qpeg",
        "Q-team QPEG",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FFVHUFF,
        AVMEDIA_TYPE_VIDEO,
        "ffvhuff",
        "Huffyuv FFmpeg variant",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_RV30,
        AVMEDIA_TYPE_VIDEO,
        "rv30",
        "RealVideo 3.0",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_RV40,
        AVMEDIA_TYPE_VIDEO,
        "rv40",
        "RealVideo 4.0",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_VC1,
        AVMEDIA_TYPE_VIDEO,
        "vc1",
        "SMPTE VC-1",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_WMV3,
        AVMEDIA_TYPE_VIDEO,
        "wmv3",
        "Windows Media Video 9",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_LOCO,
        AVMEDIA_TYPE_VIDEO,
        "loco",
        "LOCO",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_WNV1,
        AVMEDIA_TYPE_VIDEO,
        "wnv1",
        "Winnov WNV1",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AASC,
        AVMEDIA_TYPE_VIDEO,
        "aasc",
        "Autodesk RLE",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_INDEO2,
        AVMEDIA_TYPE_VIDEO,
        "indeo2",
        "Intel Indeo 2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FRAPS,
        AVMEDIA_TYPE_VIDEO,
        "fraps",
        "Fraps",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TRUEMOTION2,
        AVMEDIA_TYPE_VIDEO,
        "truemotion2",
        "Duck TrueMotion 2.0",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BMP,
        AVMEDIA_TYPE_VIDEO,
        "bmp",
        "BMP (Windows and OS/2 bitmap)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp1,
    },
    {
        AV_CODEC_ID_CSCD,
        AVMEDIA_TYPE_VIDEO,
        "cscd",
        "CamStudio",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MMVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "mmvideo",
        "American Laser Games MM Video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ZMBV,
        AVMEDIA_TYPE_VIDEO,
        "zmbv",
        "Zip Motion Blocks Video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_AVS,
        AVMEDIA_TYPE_VIDEO,
        "avs",
        "AVS (Audio Video Standard) video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SMACKVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "smackvideo",
        "Smacker video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_NUV,
        AVMEDIA_TYPE_VIDEO,
        "nuv",
        "NuppelVideo/RTJPEG",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_KMVC,
        AVMEDIA_TYPE_VIDEO,
        "kmvc",
        "Karl Morton's video codec",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FLASHSV,
        AVMEDIA_TYPE_VIDEO,
        "flashsv",
        "Flash Screen Video v1",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_CAVS,
        AVMEDIA_TYPE_VIDEO,
        "cavs",
        "Chinese AVS (Audio Video Standard) (AVS1-P2, JiZhun profile)",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_JPEG2000,
        AVMEDIA_TYPE_VIDEO,
        "jpeg2000",
        "JPEG 2000",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
        tmp2,
    },
    {
        AV_CODEC_ID_VMNC,
        AVMEDIA_TYPE_VIDEO,
        "vmnc",
        "VMware Screen Codec / VMware Video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_VP5,
        AVMEDIA_TYPE_VIDEO,
        "vp5",
        "On2 VP5",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP6,
        AVMEDIA_TYPE_VIDEO,
        "vp6",
        "On2 VP6",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP6F,
        AVMEDIA_TYPE_VIDEO,
        "vp6f",
        "On2 VP6 (Flash version)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DSICINVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "dsicinvideo",
        "Delphine Software International CIN video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TIERTEXSEQVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "tiertexseqvideo",
        "Tiertex Limited SEQ video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DXA,
        AVMEDIA_TYPE_VIDEO,
        "dxa",
        "Feeble Files/ScummVM DXA",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_DNXHD,
        AVMEDIA_TYPE_VIDEO,
        "dnxhd",
        "VC3/DNxHD",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_THP,
        AVMEDIA_TYPE_VIDEO,
        "thp",
        "Nintendo Gamecube THP video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_C93,
        AVMEDIA_TYPE_VIDEO,
        "c93",
        "Interplay C93",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BETHSOFTVID,
        AVMEDIA_TYPE_VIDEO,
        "bethsoftvid",
        "Bethesda VID video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP6A,
        AVMEDIA_TYPE_VIDEO,
        "vp6a",
        "On2 VP6 (Flash version, with alpha channel)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AMV,
        AVMEDIA_TYPE_VIDEO,
        "amv",
        "AMV Video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VB,
        AVMEDIA_TYPE_VIDEO,
        "vb",
        "Beam Software VB",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_INDEO4,
        AVMEDIA_TYPE_VIDEO,
        "indeo4",
        "Intel Indeo Video Interactive 4",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_INDEO5,
        AVMEDIA_TYPE_VIDEO,
        "indeo5",
        "Intel Indeo Video Interactive 5",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MIMIC,
        AVMEDIA_TYPE_VIDEO,
        "mimic",
        "Mimic",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_RL2,
        AVMEDIA_TYPE_VIDEO,
        "rl2",
        "RL2 video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
         AV_CODEC_ID_ESCAPE124,
        AVMEDIA_TYPE_VIDEO,
        "escape124",
        "Escape 124",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DIRAC,
        AVMEDIA_TYPE_VIDEO,
        "dirac",
        "Dirac",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_BFI,
        AVMEDIA_TYPE_VIDEO,
        "bfi",
        "Brute Force & Ignorance",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CMV,
        AVMEDIA_TYPE_VIDEO,
        "cmv",
        "Electronic Arts CMV video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MOTIONPIXELS,
        AVMEDIA_TYPE_VIDEO,
        "motionpixels",
        "Motion Pixels video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TGV,
        AVMEDIA_TYPE_VIDEO,
        "tgv",
        "Electronic Arts TGV video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TGQ,
        AVMEDIA_TYPE_VIDEO,
        "tgq",
        "Electronic Arts TGQ video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TQI,
        AVMEDIA_TYPE_VIDEO,
        "tqi",
        "Electronic Arts TQI video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AURA,
        AVMEDIA_TYPE_VIDEO,
        "aura",
        "Auravision AURA",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AURA2,
        AVMEDIA_TYPE_VIDEO,
        "aura2",
        "Auravision Aura 2",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_V210X,
        AVMEDIA_TYPE_VIDEO,
        "v210x",
        "Uncompressed 4:2:2 10-bit",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TMV,
        AVMEDIA_TYPE_VIDEO,
        "tmv",
        "8088flex TMV",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_V210,
        AVMEDIA_TYPE_VIDEO,
        "v210",
        "Uncompressed 4:2:2 10-bit",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MAD,
        AVMEDIA_TYPE_VIDEO,
        "mad",
        "Electronic Arts Madcow Video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FRWU,
        AVMEDIA_TYPE_VIDEO,
        "frwu",
        "Forward Uncompressed",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_FLASHSV2,
        AVMEDIA_TYPE_VIDEO,
        "flashsv2",
        "Flash Screen Video v2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CDGRAPHICS,
        AVMEDIA_TYPE_VIDEO,
        "cdgraphics",
        "CD Graphics video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_R210,
        AVMEDIA_TYPE_VIDEO,
        "r210",
        "Uncompressed RGB 10-bit",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ANM,
        AVMEDIA_TYPE_VIDEO,
        "anm",
        "Deluxe Paint Animation",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BINKVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "binkvideo",
        "Bink video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_IFF_ILBM,
        AVMEDIA_TYPE_VIDEO,
        "iff_ilbm",
        "IFF ILBM",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_IFF_BYTERUN1,
        AVMEDIA_TYPE_VIDEO,
        "iff_byterun1",
        "IFF ByteRun1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_KGV1,
        AVMEDIA_TYPE_VIDEO,
        "kgv1",
        "Kega Game Video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_YOP,
        AVMEDIA_TYPE_VIDEO,
        "yop",
        "Psygnosis YOP Video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP8,
        AVMEDIA_TYPE_VIDEO,
        "vp8",
        "On2 VP8",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP9,
        AVMEDIA_TYPE_VIDEO,
        "vp9",
        "Google VP9",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PICTOR,
        AVMEDIA_TYPE_VIDEO,
        "pictor",
        "Pictor/PC Paint",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_A64_MULTI,
        AVMEDIA_TYPE_VIDEO,
        "a64_multi",
        "Multicolor charset for Commodore 64",
        (1 << 0) | (1 << 1),
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_A64_MULTI5,
        AVMEDIA_TYPE_VIDEO,
        "a64_multi5",
        "Multicolor charset for Commodore 64, extended with 5th color (colram)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_R10K,
        AVMEDIA_TYPE_VIDEO,
        "r10k",
        "AJA Kona 10-bit RGB Codec",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MVC1,
        AVMEDIA_TYPE_VIDEO,
        "mvc1",
        "Silicon Graphics Motion Video Compressor 1",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MVC2,
        AVMEDIA_TYPE_VIDEO,
        "mvc2",
        "Silicon Graphics Motion Video Compressor 2",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MXPEG,
        AVMEDIA_TYPE_VIDEO,
        "mxpeg",
        "Mobotix MxPEG video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_LAGARITH,
        AVMEDIA_TYPE_VIDEO,
        "lagarith",
        "Lagarith lossless",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PRORES,
        AVMEDIA_TYPE_VIDEO,
        "prores",
        "Apple ProRes (iCodec Pro)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_JV,
        AVMEDIA_TYPE_VIDEO,
        "jv",
        "Bitmap Brothers JV video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DFA,
        AVMEDIA_TYPE_VIDEO,
        "dfa",
        "Chronomaster DFA",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_UTVIDEO,
        AVMEDIA_TYPE_VIDEO,
        "utvideo",
        "Ut Video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_BMV_VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "bmv_video",
        "Discworld II BMV video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_VBLE,
        AVMEDIA_TYPE_VIDEO,
        "vble",
        "VBLE Lossless Codec",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_DXTORY,
        AVMEDIA_TYPE_VIDEO,
        "dxtory",
        "Dxtory",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_V410,
        AVMEDIA_TYPE_VIDEO,
        "v410",
        "Uncompressed 4:4:4 10-bit",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_CDXL,
        AVMEDIA_TYPE_VIDEO,
        "cdxl",
        "Commodore CDXL video",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ZEROCODEC,
        AVMEDIA_TYPE_VIDEO,
        "zerocodec",
        "ZeroCodec Lossless Video",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MSS1,
        AVMEDIA_TYPE_VIDEO,
        "mss1",
        "MS Screen 1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MSA1,
        AVMEDIA_TYPE_VIDEO,
        "msa1",
        "MS ATC Screen",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TSCC2,
        AVMEDIA_TYPE_VIDEO,
        "tscc2",
        "TechSmith Screen Codec 2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MTS2,
        AVMEDIA_TYPE_VIDEO,
        "mts2",
        "MS Expression Encoder Screen",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CLLC,
        AVMEDIA_TYPE_VIDEO,
        "cllc",
        "Canopus Lossless Codec",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MSS2,
        AVMEDIA_TYPE_VIDEO,
        "mss2",
        "MS Windows Media Video V9 Screen",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AIC,
        AVMEDIA_TYPE_VIDEO,
        "aic",
        "Apple Intermediate Codec",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_Y41P,
        AVMEDIA_TYPE_VIDEO,
        "y41p",
        "Uncompressed YUV 4:1:1 12-bit",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_ESCAPE130,
        AVMEDIA_TYPE_VIDEO,
        "escape130",
        "Escape 130",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AVRP,
        AVMEDIA_TYPE_VIDEO,
        "avrp",
        "Avid 1:1 10-bit RGB Packer",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_012V,
        AVMEDIA_TYPE_VIDEO,
        "012v",
        "Uncompressed 4:2:2 10-bit",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_AVUI,
        AVMEDIA_TYPE_VIDEO,
        "avui",
        "Avid Meridien Uncompressed",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_AYUV,
        AVMEDIA_TYPE_VIDEO,
        "ayuv",
        "Uncompressed packed MS 4:4:4:4",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_TARGA_Y216,
        AVMEDIA_TYPE_VIDEO,
        "targa_y216",
        "Pinnacle TARGA CineWave YUV16",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_V308,
        AVMEDIA_TYPE_VIDEO,
        "v308",
        "Uncompressed packed 4:4:4",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_V408,
        AVMEDIA_TYPE_VIDEO,
        "v408",
        "Uncompressed packed QT 4:4:4:4",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_YUV4,
        AVMEDIA_TYPE_VIDEO,
        "yuv4",
        "Uncompressed packed 4:2:0",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_AVRN,
        AVMEDIA_TYPE_VIDEO,
        "avrn",
        "Avid AVI Codec",
    },
    {
        AV_CODEC_ID_CPIA,
        AVMEDIA_TYPE_VIDEO,
        "cpia",
        "CPiA video format",
    },
    {
        AV_CODEC_ID_XFACE,
        AVMEDIA_TYPE_VIDEO,
        "xface",
        "X-face image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SMVJPEG,
        AVMEDIA_TYPE_VIDEO,
        "smv",
        "Sigmatel Motion Video",
    },

    {
        AV_CODEC_ID_G2M,
        AVMEDIA_TYPE_VIDEO,
        "g2m",
        "Go2Meeting",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_HNM4_VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "hnm4video",
        "HNM 4 video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_HEVC,
        AVMEDIA_TYPE_VIDEO,
        "hevc",
        "H.265 / HEVC (High Efficiency Video Coding)",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        AV_CODEC_ID_FIC,
        AVMEDIA_TYPE_VIDEO,
        "fic",
        "Mirillis FIC",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PAF_VIDEO,
        AVMEDIA_TYPE_VIDEO,
        "paf_video",
        "Amazing Studio Packed Animation File Video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP7,
        AVMEDIA_TYPE_VIDEO,
        "vp7",
        "On2 VP7",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SANM,
        AVMEDIA_TYPE_VIDEO,
        "sanm",
        "LucasArts SANM/SMUSH video",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SGIRLE,
        AVMEDIA_TYPE_VIDEO,
        "sgirle",
        "SGI RLE 8-bit",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },

    /* image codecs */
    {
        AV_CODEC_ID_ALIAS_PIX,
        AVMEDIA_TYPE_VIDEO,
        "alias_pix",
        "Alias/Wavefront PIX image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ANSI,
        AVMEDIA_TYPE_VIDEO,
        "ansi",
        "ASCII/ANSI art",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BRENDER_PIX,
        AVMEDIA_TYPE_VIDEO,
        "brender_pix",
        "BRender PIX image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_DPX,
        AVMEDIA_TYPE_VIDEO,
        "dpx",
        "DPX (Digital Picture Exchange) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_EXR,
        AVMEDIA_TYPE_VIDEO,
        "exr",
        "OpenEXR image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_GIF,
        AVMEDIA_TYPE_VIDEO,
        "gif",
        "GIF (Graphics Interchange Format)",
        AV_CODEC_PROP_LOSSLESS,
        tmp3,
    },
    {
        AV_CODEC_ID_JPEGLS,
        AVMEDIA_TYPE_VIDEO,
        "jpegls",
        "JPEG-LS",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_LJPEG,
        AVMEDIA_TYPE_VIDEO,
        "ljpeg",
        "Lossless JPEG",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PAM,
        AVMEDIA_TYPE_VIDEO,
        "pam",
        "PAM (Portable AnyMap) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp4,
    },
    {
        AV_CODEC_ID_PBM,
        AVMEDIA_TYPE_VIDEO,
        "pbm",
        "PBM (Portable BitMap) image",
        (1 << 0) | (1 << 2),
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCX,
        AVMEDIA_TYPE_VIDEO,
        "pcx",
        "PC Paintbrush PCX image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp5,
    },
    {
        AV_CODEC_ID_PGM,
        AVMEDIA_TYPE_VIDEO,
        "pgm",
        "PGM (Portable GrayMap) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PGMYUV,
        AVMEDIA_TYPE_VIDEO,
        "pgmyuv",
        "PGMYUV (Portable GrayMap YUV) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PNG,
        AVMEDIA_TYPE_VIDEO,
        "png",
        "PNG (Portable Network Graphics) image",
        AV_CODEC_PROP_LOSSLESS,
        tmp6,
    },
    {
        AV_CODEC_ID_PPM,
        AVMEDIA_TYPE_VIDEO,
        "ppm",
        "PPM (Portable PixelMap) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PTX,
        AVMEDIA_TYPE_VIDEO,
        "ptx",
        "V.Flash PTX image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SGI,
        AVMEDIA_TYPE_VIDEO,
        "sgi",
        "SGI image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_SP5X,
        AVMEDIA_TYPE_VIDEO,
        "sp5x",
        "Sunplus JPEG (SP5X)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SUNRAST,
        AVMEDIA_TYPE_VIDEO,
        "sunrast",
        "Sun Rasterfile image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TARGA,
        AVMEDIA_TYPE_VIDEO,
        "targa",
        "Truevision Targa image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp7,
    },
    {
        AV_CODEC_ID_TIFF,
        AVMEDIA_TYPE_VIDEO,
        "tiff",
        "TIFF image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp8,
    },
    {
        AV_CODEC_ID_TXD,
        AVMEDIA_TYPE_VIDEO,
        "txd",
        "Renderware TXD (TeXture Dictionary) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VC1IMAGE,
        AVMEDIA_TYPE_VIDEO,
        "vc1image",
        "Windows Media Video 9 Image v2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WEBP,
        AVMEDIA_TYPE_VIDEO,
        "webp",
        "WebP",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
        tmp9,
    },
    {
        AV_CODEC_ID_WMV3IMAGE,
        AVMEDIA_TYPE_VIDEO,
        "wmv3image",
        "Windows Media Video 9 Image",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_XBM,
        AVMEDIA_TYPE_VIDEO,
        "xbm",
        "XBM (X BitMap) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_XWD,
        AVMEDIA_TYPE_VIDEO,
        "xwd",
        "XWD (X Window Dump) image",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        tmp10,
    },

    /* various PCM "codecs" */
    {
        AV_CODEC_ID_PCM_S16LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s16le",
        "PCM signed 16-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S16BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s16be",
        "PCM signed 16-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U16LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u16le",
        "PCM unsigned 16-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U16BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u16be",
        "PCM unsigned 16-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S8,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s8",
        "PCM signed 8-bit",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U8,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u8",
        "PCM unsigned 8-bit",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_MULAW,
        AVMEDIA_TYPE_AUDIO,
        "pcm_mulaw",
        "PCM mu-law / G.711 mu-law",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PCM_ALAW,
        AVMEDIA_TYPE_AUDIO,
        "pcm_alaw",
        "PCM A-law / G.711 A-law",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PCM_S32LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s32le",
        "PCM signed 32-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S32BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s32be",
        "PCM signed 32-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U32LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u32le",
        "PCM unsigned 32-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U32BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u32be",
        "PCM unsigned 32-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S24LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s24le",
        "PCM signed 24-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S24BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s24be",
        "PCM signed 24-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U24LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u24le",
        "PCM unsigned 24-bit little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_U24BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_u24be",
        "PCM unsigned 24-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S24DAUD,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s24daud",
        "PCM D-Cinema audio signed 24-bit",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_ZORK,
        AVMEDIA_TYPE_AUDIO,
        "pcm_zork",
        "PCM Zork",
       AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PCM_S16BE_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s16be_planar",
        "PCM signed 16-bit big-endian planar",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S16LE_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s16le_planar",
        "PCM signed 16-bit little-endian planar",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S24LE_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s24le_planar",
        "PCM signed 24-bit little-endian planar",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S32LE_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s32le_planar",
        "PCM signed 32-bit little-endian planar",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_DVD,
        AVMEDIA_TYPE_AUDIO,
        "pcm_dvd",
        "PCM signed 20|24-bit big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_F32BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_f32be",
        "PCM 32-bit floating point big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_F32LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_f32le",
        "PCM 32-bit floating point little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_F64BE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_f64be",
        "PCM 64-bit floating point big-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_F64LE,
        AVMEDIA_TYPE_AUDIO,
        "pcm_f64le",
        "PCM 64-bit floating point little-endian",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_BLURAY,
        AVMEDIA_TYPE_AUDIO,
        "pcm_bluray",
        "PCM signed 16|20|24-bit big-endian for Blu-ray media",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_LXF,
        AVMEDIA_TYPE_AUDIO,
        "pcm_lxf",
        "PCM signed 20-bit little-endian planar",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_S302M,
        AVMEDIA_TYPE_AUDIO,
        "s302m",
        "SMPTE 302M",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S8_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s8_planar",
        "PCM signed 8-bit planar",
        AV_CODEC_PROP_LOSSLESS,
    },

    /* various ADPCM codecs */
    {
        AV_CODEC_ID_ADPCM_IMA_QT,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_qt",
        "ADPCM IMA QuickTime",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_WAV,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_wav",
        "ADPCM IMA WAV",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_DK3,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_dk3",
        "ADPCM IMA Duck DK3",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_DK4,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_dk4",
        "ADPCM IMA Duck DK4",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_WS,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_ws",
        "ADPCM IMA Westwood",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_SMJPEG,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_smjpeg",
        "ADPCM IMA Loki SDL MJPEG",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_MS,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ms",
        "ADPCM Microsoft",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_4XM,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_4xm",
        "ADPCM 4X Movie",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_XA,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_xa",
        "ADPCM CDROM XA",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_ADX,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_adx",
        "SEGA CRI ADX ADPCM",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea",
        "ADPCM Electronic Arts",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_G726,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_g726",
        "G.726 ADPCM",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_CT,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ct",
        "ADPCM Creative Technology",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_SWF,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_swf",
        "ADPCM Shockwave Flash",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_YAMAHA,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_yamaha",
        "ADPCM Yamaha",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_SBPRO_4,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_sbpro_4",
        "ADPCM Sound Blaster Pro 4-bit",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_SBPRO_3,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_sbpro_3",
        "ADPCM Sound Blaster Pro 2.6-bit",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_SBPRO_2,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_sbpro_2",
        "ADPCM Sound Blaster Pro 2-bit",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_THP,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_thp",
        "ADPCM Nintendo Gamecube THP",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_AMV,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_amv",
        "ADPCM IMA AMV",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA_R1,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea_r1",
        "ADPCM Electronic Arts R1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA_R3,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea_r3",
        "ADPCM Electronic Arts R3",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA_R2,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea_r2",
        "ADPCM Electronic Arts R2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_EA_SEAD,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_ea_sead",
        "ADPCM IMA Electronic Arts SEAD",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_EA_EACS,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_ea_eacs",
        "ADPCM IMA Electronic Arts EACS",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA_XAS,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea_xas",
        "ADPCM Electronic Arts XAS",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_EA_MAXIS_XA,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ea_maxis_xa",
        "ADPCM Electronic Arts Maxis CDROM XA",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_ISS,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_iss",
        "ADPCM IMA Funcom ISS",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_G722,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_g722",
        "G.722 ADPCM",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_APC,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_apc",
        "ADPCM IMA CRYO APC",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_AFC,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_afc",
        "ADPCM Nintendo Gamecube AFC",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_OKI,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_oki",
        "ADPCM IMA Dialogic OKI",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_DTK,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_dtk",
        "ADPCM Nintendo Gamecube DTK",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_IMA_RAD,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_ima_rad",
        "ADPCM IMA Radical",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_G726LE,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_g726le",
        "G.726 ADPCM little-endian",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_VIMA,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_vima",
        "LucasArts VIMA audio",
        AV_CODEC_PROP_LOSSY,
    },

    /* AMR */
    {
        AV_CODEC_ID_AMR_NB,
        AVMEDIA_TYPE_AUDIO,
        "amr_nb",
        "AMR-NB (Adaptive Multi-Rate NarrowBand)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AMR_WB,
        AVMEDIA_TYPE_AUDIO,
        "amr_wb",
        "AMR-WB (Adaptive Multi-Rate WideBand)",
        AV_CODEC_PROP_LOSSY,
    },

    /* RealAudio codecs*/
    {
        AV_CODEC_ID_RA_144,
        AVMEDIA_TYPE_AUDIO,
        "ra_144",
        "RealAudio 1.0 (14.4K)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_RA_288,
        AVMEDIA_TYPE_AUDIO,
        "ra_288",
        "RealAudio 2.0 (28.8K)",
        AV_CODEC_PROP_LOSSY,
    },

    /* various DPCM codecs */
    {
        AV_CODEC_ID_ROQ_DPCM,
        AVMEDIA_TYPE_AUDIO,
        "roq_dpcm",
        "DPCM id RoQ",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_INTERPLAY_DPCM,
        AVMEDIA_TYPE_AUDIO,
        "interplay_dpcm",
        "DPCM Interplay",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_XAN_DPCM,
        AVMEDIA_TYPE_AUDIO,
        "xan_dpcm",
        "DPCM Xan",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SOL_DPCM,
        AVMEDIA_TYPE_AUDIO,
        "sol_dpcm",
        "DPCM Sol",
        AV_CODEC_PROP_LOSSY,
    },

    /* audio codecs */
    {
        AV_CODEC_ID_MP2,
        AVMEDIA_TYPE_AUDIO,
        "mp2",
        "MP2 (MPEG audio layer 2)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MP3,
        AVMEDIA_TYPE_AUDIO,
        "mp3",
        "MP3 (MPEG audio layer 3)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AAC,
        AVMEDIA_TYPE_AUDIO,
        "aac",
        "AAC (Advanced Audio Coding)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AC3,
        AVMEDIA_TYPE_AUDIO,
        "ac3",
        "ATSC A/52A (AC-3)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DTS,
        AVMEDIA_TYPE_AUDIO,
        "dts",
        "DCA (DTS Coherent Acoustics)",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_VORBIS,
        AVMEDIA_TYPE_AUDIO,
        "vorbis",
        "Vorbis",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DVAUDIO,
        AVMEDIA_TYPE_AUDIO,
        "dvaudio",
        "DV audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMAV1,
        AVMEDIA_TYPE_AUDIO,
        "wmav1",
        "Windows Media Audio 1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMAV2,
        AVMEDIA_TYPE_AUDIO,
        "wmav2",
        "Windows Media Audio 2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MACE3,
        AVMEDIA_TYPE_AUDIO,
        "mace3",
        "MACE (Macintosh Audio Compression/Expansion) 3:1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MACE6,
        AVMEDIA_TYPE_AUDIO,
        "mace6",
        "MACE (Macintosh Audio Compression/Expansion) 6:1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VMDAUDIO,
        AVMEDIA_TYPE_AUDIO,
        "vmdaudio",
        "Sierra VMD audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FLAC,
        AVMEDIA_TYPE_AUDIO,
        "flac",
        "FLAC (Free Lossless Audio Codec)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MP3ADU,
        AVMEDIA_TYPE_AUDIO,
        "mp3adu",
        "ADU (Application Data Unit) MP3 (MPEG audio layer 3)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MP3ON4,
        AVMEDIA_TYPE_AUDIO,
        "mp3on4",
        "MP3onMP4",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SHORTEN,
        AVMEDIA_TYPE_AUDIO,
        "shorten",
        "Shorten",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ALAC,
        AVMEDIA_TYPE_AUDIO,
        "alac",
        "ALAC (Apple Lossless Audio Codec)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_WESTWOOD_SND1,
        AVMEDIA_TYPE_AUDIO,
        "westwood_snd1",
        "Westwood Audio (SND1)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_GSM,
        AVMEDIA_TYPE_AUDIO,
        "gsm",
        "GSM",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_QDM2,
        AVMEDIA_TYPE_AUDIO,
        "qdm2",
        "QDesign Music Codec 2",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_COOK,
        AVMEDIA_TYPE_AUDIO,
        "cook",
        "Cook / Cooker / Gecko (RealAudio G2)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TRUESPEECH,
        AVMEDIA_TYPE_AUDIO,
        "truespeech",
        "DSP Group TrueSpeech",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TTA,
        AVMEDIA_TYPE_AUDIO,
        "tta",
        "TTA (True Audio)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_SMACKAUDIO,
        AVMEDIA_TYPE_AUDIO,
        "smackaudio",
        "Smacker audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_QCELP,
        AVMEDIA_TYPE_AUDIO,
        "qcelp",
        "QCELP / PureVoice",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WAVPACK,
        AVMEDIA_TYPE_AUDIO,
        "wavpack",
        "WavPack",
        AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_DSICINAUDIO,
        AVMEDIA_TYPE_AUDIO,
        "dsicinaudio",
        "Delphine Software International CIN audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_IMC,
        AVMEDIA_TYPE_AUDIO,
        "imc",
        "IMC (Intel Music Coder)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MUSEPACK7,
        AVMEDIA_TYPE_AUDIO,
        "musepack7",
        "Musepack SV7",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MLP,
        AVMEDIA_TYPE_AUDIO,
        "mlp",
        "MLP (Meridian Lossless Packing)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_GSM_MS,
        AVMEDIA_TYPE_AUDIO,
        "gsm_ms",
        "GSM Microsoft variant",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ATRAC3,
        AVMEDIA_TYPE_AUDIO,
        "atrac3",
        "ATRAC3 (Adaptive TRansform Acoustic Coding 3)",
        AV_CODEC_PROP_LOSSY,
    },
#if FF_API_VOXWARE
    {
        AV_CODEC_ID_VOXWARE,
        AVMEDIA_TYPE_AUDIO,
        "voxware",
        "Voxware RT29 Metasound",
        AV_CODEC_PROP_LOSSY,
    },
#endif
    {
        AV_CODEC_ID_APE,
        AVMEDIA_TYPE_AUDIO,
        "ape",
        "Monkey's Audio",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_NELLYMOSER,
        AVMEDIA_TYPE_AUDIO,
        "nellymoser",
        "Nellymoser Asao",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MUSEPACK8,
        AVMEDIA_TYPE_AUDIO,
        "musepack8",
        "Musepack SV8",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SPEEX,
        AVMEDIA_TYPE_AUDIO,
        "speex",
        "Speex",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMAVOICE,
        AVMEDIA_TYPE_AUDIO,
        "wmavoice",
        "Windows Media Audio Voice",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMAPRO,
        AVMEDIA_TYPE_AUDIO,
        "wmapro",
        "Windows Media Audio 9 Professional",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WMALOSSLESS,
        AVMEDIA_TYPE_AUDIO,
        "wmalossless",
        "Windows Media Audio Lossless",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ATRAC3P,
        AVMEDIA_TYPE_AUDIO,
        "atrac3p",
        "ATRAC3+ (Adaptive TRansform Acoustic Coding 3+)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_EAC3,
        AVMEDIA_TYPE_AUDIO,
        "eac3",
        "ATSC A/52B (AC-3, E-AC-3)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SIPR,
        AVMEDIA_TYPE_AUDIO,
        "sipr",
        "RealAudio SIPR / ACELP.NET",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_MP1,
        AVMEDIA_TYPE_AUDIO,
        "mp1",
        "MP1 (MPEG audio layer 1)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TWINVQ,
        AVMEDIA_TYPE_AUDIO,
        "twinvq",
        "VQF TwinVQ",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TRUEHD,
        AVMEDIA_TYPE_AUDIO,
        "truehd",
        "TrueHD",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_MP4ALS,
        AVMEDIA_TYPE_AUDIO,
        "mp4als",
        "MPEG-4 Audio Lossless Coding (ALS)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ATRAC1,
        AVMEDIA_TYPE_AUDIO,
        "atrac1",
        "ATRAC1 (Adaptive TRansform Acoustic Coding)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BINKAUDIO_RDFT,
        AVMEDIA_TYPE_AUDIO,
        "binkaudio_rdft",
        "Bink Audio (RDFT)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BINKAUDIO_DCT,
        AVMEDIA_TYPE_AUDIO,
        "binkaudio_dct",
        "Bink Audio (DCT)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_AAC_LATM,
        AVMEDIA_TYPE_AUDIO,
        "aac_latm",
        "AAC LATM (Advanced Audio Coding LATM syntax)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_QDMC,
        AVMEDIA_TYPE_AUDIO,
        "qdmc",
        "QDesign Music",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_CELT,
        AVMEDIA_TYPE_AUDIO,
        "celt",
        "Constrained Energy Lapped Transform (CELT)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_G723_1,
        AVMEDIA_TYPE_AUDIO,
        "g723_1",
        "G.723.1",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_G729,
        AVMEDIA_TYPE_AUDIO,
        "g729",
        "G.729",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_8SVX_EXP,
        AVMEDIA_TYPE_AUDIO,
        "8svx_exp",
        "8SVX exponential",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_8SVX_FIB,
        AVMEDIA_TYPE_AUDIO,
        "8svx_fib",
        "8SVX fibonacci",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_BMV_AUDIO,
        AVMEDIA_TYPE_AUDIO,
        "bmv_audio",
        "Discworld II BMV audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_RALF,
        AVMEDIA_TYPE_AUDIO,
        "ralf",
        "RealAudio Lossless",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_IAC,
        AVMEDIA_TYPE_AUDIO,
        "iac",
        "IAC (Indeo Audio Coder)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ILBC,
        AVMEDIA_TYPE_AUDIO,
        "ilbc",
        "iLBC (Internet Low Bitrate Codec)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_FFWAVESYNTH,
        AVMEDIA_TYPE_AUDIO,
        "wavesynth",
        "Wave synthesis pseudo-codec",
    },
    {
        AV_CODEC_ID_SONIC,
        AVMEDIA_TYPE_AUDIO,
        "sonic",
        "Sonic",
    },
    {
        AV_CODEC_ID_SONIC_LS,
        AVMEDIA_TYPE_AUDIO,
        "sonicls",
        "Sonic lossless",
    },
    {
        AV_CODEC_ID_OPUS,
        AVMEDIA_TYPE_AUDIO,
        "opus",
        "Opus (Opus Interactive Audio Codec)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_COMFORT_NOISE,
        AVMEDIA_TYPE_AUDIO,
        "comfortnoise",
        "RFC 3389 Comfort Noise",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_TAK,
        AVMEDIA_TYPE_AUDIO,
        "tak",
        "TAK (Tom's lossless Audio Kompressor)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_METASOUND,
        AVMEDIA_TYPE_AUDIO,
        "metasound",
        "Voxware MetaSound",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PAF_AUDIO,
        AVMEDIA_TYPE_AUDIO,
        "paf_audio",
        "Amazing Studio Packed Animation File Audio",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ON2AVC,
        AVMEDIA_TYPE_AUDIO,
        "avc",
        "On2 Audio for Video Codec",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_EVRC,
        AVMEDIA_TYPE_AUDIO,
        "evrc",
        "EVRC (Enhanced Variable Rate Codec)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_SMV,
        AVMEDIA_TYPE_AUDIO,
        "smv",
        "SMV (Selectable Mode Vocoder)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DSD_LSBF,
        AVMEDIA_TYPE_AUDIO,
        "dsd_lsbf",
        "DSD (Direct Stream Digital), least significant bit first",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DSD_MSBF,
        AVMEDIA_TYPE_AUDIO,
        "dsd_msbf",
        "DSD (Direct Stream Digital), most significant bit first",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DSD_LSBF_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "dsd_lsbf_planar",
        "DSD (Direct Stream Digital), least significant bit first, planar",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_DSD_MSBF_PLANAR,
        AVMEDIA_TYPE_AUDIO,
        "dsd_msbf_planar",
        "DSD (Direct Stream Digital), most significant bit first, planar",
        AV_CODEC_PROP_LOSSY,
    },

    /* subtitle codecs */
    {
        AV_CODEC_ID_DVD_SUBTITLE,
        AVMEDIA_TYPE_SUBTITLE,
        "dvd_subtitle",
        "DVD subtitles",
        AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        AV_CODEC_ID_DVB_SUBTITLE,
        AVMEDIA_TYPE_SUBTITLE,
        "dvb_subtitle",
        "DVB subtitles",
        AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        AV_CODEC_ID_TEXT,
        AVMEDIA_TYPE_SUBTITLE,
        "text",
        "raw UTF-8 text",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_XSUB,
        AVMEDIA_TYPE_SUBTITLE,
        "xsub",
        "XSUB",
        AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        AV_CODEC_ID_ASS,
        AVMEDIA_TYPE_SUBTITLE,
        "ass",
        "ASS (Advanced SSA) subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_SSA,
        AVMEDIA_TYPE_SUBTITLE,
        "ssa",
        "SSA (SubStation Alpha) subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_MOV_TEXT,
        AVMEDIA_TYPE_SUBTITLE,
        "mov_text",
        "MOV text",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_HDMV_PGS_SUBTITLE,
        AVMEDIA_TYPE_SUBTITLE,
        "hdmv_pgs_subtitle",
        "HDMV Presentation Graphic Stream subtitles",
        AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        AV_CODEC_ID_DVB_TELETEXT,
        AVMEDIA_TYPE_SUBTITLE,
        "dvb_teletext",
        "DVB teletext",
    },
    {
        AV_CODEC_ID_SRT,
        AVMEDIA_TYPE_SUBTITLE,
        "srt",
        "SubRip subtitle with embedded timing",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_SUBRIP,
        AVMEDIA_TYPE_SUBTITLE,
        "subrip",
        "SubRip subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_MICRODVD,
        AVMEDIA_TYPE_SUBTITLE,
        "microdvd",
        "MicroDVD subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_MPL2,
        AVMEDIA_TYPE_SUBTITLE,
        "mpl2",
        "MPL2 subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_EIA_608,
        AVMEDIA_TYPE_SUBTITLE,
        "eia_608",
        "EIA-608 closed captions",
    },
    {
        AV_CODEC_ID_JACOSUB,
        AVMEDIA_TYPE_SUBTITLE,
        "jacosub",
        "JACOsub subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_PJS,
        AVMEDIA_TYPE_SUBTITLE,
        "pjs",
        "PJS (Phoenix Japanimation Society) subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_SAMI,
        AVMEDIA_TYPE_SUBTITLE,
        "sami",
        "SAMI subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_REALTEXT,
        AVMEDIA_TYPE_SUBTITLE,
        "realtext",
        "RealText subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_SUBVIEWER1,
        AVMEDIA_TYPE_SUBTITLE,
        "subviewer1",
        "SubViewer v1 subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_SUBVIEWER,
        AVMEDIA_TYPE_SUBTITLE,
        "subviewer",
        "SubViewer subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_VPLAYER,
        AVMEDIA_TYPE_SUBTITLE,
        "vplayer",
        "VPlayer subtitle",
        AV_CODEC_PROP_TEXT_SUB,
    },
    {
        AV_CODEC_ID_WEBVTT,
        AVMEDIA_TYPE_SUBTITLE,
        "webvtt",
        "WebVTT subtitle",
        (1 << 17),
        AV_CODEC_PROP_TEXT_SUB,
    },

    /* other kind of codecs and pseudo-codecs */
    {
        AV_CODEC_ID_TTF,
        AVMEDIA_TYPE_DATA,
        "ttf",
        "TrueType font",
        0, tmp11,
    },
    {
        AV_CODEC_ID_BINTEXT,
        AVMEDIA_TYPE_VIDEO,
        "bintext",
        "Binary text",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_XBIN,
        AVMEDIA_TYPE_VIDEO,
        "xbin",
        "eXtended BINary text",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_IDF,
        AVMEDIA_TYPE_VIDEO,
        "idf",
        "iCEDraw text",
        AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        AV_CODEC_ID_OTF,
        AVMEDIA_TYPE_DATA,
        "otf",
        "OpenType font",
        0, tmp12,
    },
    {
        AV_CODEC_ID_SMPTE_KLV,
        AVMEDIA_TYPE_DATA,
        "klv",
        "SMPTE 336M Key-Length-Value (KLV) metadata",
    },
    {
        AV_CODEC_ID_DVD_NAV,
        AVMEDIA_TYPE_DATA,
        "dvd_nav_packet",
        "DVD Nav packet",
    },
    {
        AV_CODEC_ID_TIMED_ID3,
        AVMEDIA_TYPE_DATA,
        "timed_id3",
        "timed ID3 metadata",
    },
    {
        AV_CODEC_ID_BIN_DATA,
        AVMEDIA_TYPE_DATA,
        "bin_data",
        "binary data",
        0, tmp13,
    },

    /* deprecated codec ids */
    {
        AV_CODEC_ID_BRENDER_PIX_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "brender_pix_deprecated",
        "BRender PIX image (deprecated id)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_ESCAPE130_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "escape130_deprecated",
        "Escape 130 (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_EXR_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "exr_deprecated",
        "OpenEXR image (deprecated id)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_G2M_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "g2m_deprecated",
        "Go2Meeting (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_HEVC_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "hevc_deprecated",
        "H.265 / HEVC (High Efficiency Video Coding) (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PAF_VIDEO_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "paf_video_deprecated",
        "Amazing Studio Packed Animation File Video (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PAF_VIDEO_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "paf_video_deprecated",
        "Amazing Studio Packed Animation File Video (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_VP7_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "vp7_deprecated",
        "On2 VP7 (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_WEBP_DEPRECATED,
        AVMEDIA_TYPE_VIDEO,
        "webp_deprecated",
        "WebP (deprecated id)",
        AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },

    {
        AV_CODEC_ID_VIMA,
        AVMEDIA_TYPE_AUDIO,
        "vima",
        "LucasArts VIMA audio (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_ADPCM_VIMA_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "adpcm_vima_deprecated",
        "LucasArts VIMA audio (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_OPUS_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "opus_deprecated",
        "Opus (Opus Interactive Audio Codec) (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PAF_AUDIO_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "paf_audio_deprecated",
        "Amazing Studio Packed Animation File Audio (deprecated id)",
        AV_CODEC_PROP_LOSSY,
    },
    {
        AV_CODEC_ID_PCM_S24LE_PLANAR_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s24le_planar_deprecated",
        "PCM signed 24-bit little-endian planar (deprecated id)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_PCM_S32LE_PLANAR_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "pcm_s32le_planar_deprecated",
        "PCM signed 32-bit little-endian planar (deprecated id)",
        AV_CODEC_PROP_LOSSLESS,
    },
    {
        AV_CODEC_ID_TAK_DEPRECATED,
        AVMEDIA_TYPE_AUDIO,
        "tak_deprecated",
        "TAK (Tom's lossless Audio Kompressor) (deprecated id)",
        AV_CODEC_PROP_LOSSLESS,
    },
#else
	/* video codecs */
    {
        .id        = AV_CODEC_ID_MPEG1VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mpeg1video",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-1 video"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_MPEG2VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mpeg2video",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-2 video"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
#if FF_API_XVMC
    {
        .id        = AV_CODEC_ID_MPEG2VIDEO_XVMC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mpegvideo_xvmc",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-1/2 video XvMC (X-Video Motion Compensation)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
#endif /* FF_API_XVMC */
    {
        .id        = AV_CODEC_ID_H261,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "h261",
        .long_name = NULL_IF_CONFIG_SMALL("H.261"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_H263,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "h263",
        .long_name = NULL_IF_CONFIG_SMALL("H.263 / H.263-1996, H.263+ / H.263-1998 / H.263 version 2"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_RV10,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rv10",
        .long_name = NULL_IF_CONFIG_SMALL("RealVideo 1.0"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_RV20,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rv20",
        .long_name = NULL_IF_CONFIG_SMALL("RealVideo 2.0"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_MJPEG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mjpeg",
        .long_name = NULL_IF_CONFIG_SMALL("Motion JPEG"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
        .mime_types= MT("image/jpeg"),
    },
    {
        .id        = AV_CODEC_ID_MJPEGB,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mjpegb",
        .long_name = NULL_IF_CONFIG_SMALL("Apple MJPEG-B"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MPEG4,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mpeg4",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-4 part 2"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_RAWVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rawvideo",
        .long_name = NULL_IF_CONFIG_SMALL("raw video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MSMPEG4V1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msmpeg4v1",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-4 part 2 Microsoft variant version 1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MSMPEG4V2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msmpeg4v2",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-4 part 2 Microsoft variant version 2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MSMPEG4V3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msmpeg4v3",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-4 part 2 Microsoft variant version 3"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "wmv1",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Video 7"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMV2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "wmv2",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Video 8"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_H263P,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "h263p",
        .long_name = NULL_IF_CONFIG_SMALL("H.263+ / H.263-1998 / H.263 version 2"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_H263I,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "h263i",
        .long_name = NULL_IF_CONFIG_SMALL("Intel H.263"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_FLV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "flv1",
        .long_name = NULL_IF_CONFIG_SMALL("FLV / Sorenson Spark / Sorenson H.263 (Flash Video)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SVQ1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "svq1",
        .long_name = NULL_IF_CONFIG_SMALL("Sorenson Vector Quantizer 1 / Sorenson Video 1 / SVQ1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SVQ3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "svq3",
        .long_name = NULL_IF_CONFIG_SMALL("Sorenson Vector Quantizer 3 / Sorenson Video 3 / SVQ3"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_DVVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dvvideo",
        .long_name = NULL_IF_CONFIG_SMALL("DV (Digital Video)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_HUFFYUV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "huffyuv",
        .long_name = NULL_IF_CONFIG_SMALL("HuffYUV"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_CYUV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cyuv",
        .long_name = NULL_IF_CONFIG_SMALL("Creative YUV (CYUV)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_H264,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "h264",
        .long_name = NULL_IF_CONFIG_SMALL("H.264 / AVC / MPEG-4 AVC / MPEG-4 part 10"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_INDEO3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "indeo3",
        .long_name = NULL_IF_CONFIG_SMALL("Intel Indeo 3"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp3",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP3"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_THEORA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "theora",
        .long_name = NULL_IF_CONFIG_SMALL("Theora"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ASV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "asv1",
        .long_name = NULL_IF_CONFIG_SMALL("ASUS V1"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ASV2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "asv2",
        .long_name = NULL_IF_CONFIG_SMALL("ASUS V2"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FFV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ffv1",
        .long_name = NULL_IF_CONFIG_SMALL("FFmpeg video codec #1"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_4XM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "4xm",
        .long_name = NULL_IF_CONFIG_SMALL("4X Movie"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VCR1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vcr1",
        .long_name = NULL_IF_CONFIG_SMALL("ATI VCR1"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CLJR,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cljr",
        .long_name = NULL_IF_CONFIG_SMALL("Cirrus Logic AccuPak"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MDEC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mdec",
        .long_name = NULL_IF_CONFIG_SMALL("Sony PlayStation MDEC (Motion DECoder)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ROQ,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "roq",
        .long_name = NULL_IF_CONFIG_SMALL("id RoQ video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_INTERPLAY_VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "interplayvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Interplay MVE video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_XAN_WC3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xan_wc3",
        .long_name = NULL_IF_CONFIG_SMALL("Wing Commander III / Xan"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_XAN_WC4,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xan_wc4",
        .long_name = NULL_IF_CONFIG_SMALL("Wing Commander IV / Xxan"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_RPZA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rpza",
        .long_name = NULL_IF_CONFIG_SMALL("QuickTime video (RPZA)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CINEPAK,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cinepak",
        .long_name = NULL_IF_CONFIG_SMALL("Cinepak"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WS_VQA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ws_vqa",
        .long_name = NULL_IF_CONFIG_SMALL("Westwood Studios VQA (Vector Quantized Animation) video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MSRLE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msrle",
        .long_name = NULL_IF_CONFIG_SMALL("Microsoft RLE"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MSVIDEO1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msvideo1",
        .long_name = NULL_IF_CONFIG_SMALL("Microsoft Video 1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_IDCIN,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "idcin",
        .long_name = NULL_IF_CONFIG_SMALL("id Quake II CIN video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_8BPS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "8bps",
        .long_name = NULL_IF_CONFIG_SMALL("QuickTime 8BPS video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_SMC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "smc",
        .long_name = NULL_IF_CONFIG_SMALL("QuickTime Graphics (SMC)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FLIC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "flic",
        .long_name = NULL_IF_CONFIG_SMALL("Autodesk Animator Flic video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TRUEMOTION1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "truemotion1",
        .long_name = NULL_IF_CONFIG_SMALL("Duck TrueMotion 1.0"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VMDVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vmdvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Sierra VMD video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MSZH,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mszh",
        .long_name = NULL_IF_CONFIG_SMALL("LCL (LossLess Codec Library) MSZH"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ZLIB,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "zlib",
        .long_name = NULL_IF_CONFIG_SMALL("LCL (LossLess Codec Library) ZLIB"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_QTRLE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "qtrle",
        .long_name = NULL_IF_CONFIG_SMALL("QuickTime Animation (RLE) video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_SNOW,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "snow",
        .long_name = NULL_IF_CONFIG_SMALL("Snow"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TSCC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tscc",
        .long_name = NULL_IF_CONFIG_SMALL("TechSmith Screen Capture Codec"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ULTI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ulti",
        .long_name = NULL_IF_CONFIG_SMALL("IBM UltiMotion"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_QDRAW,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "qdraw",
        .long_name = NULL_IF_CONFIG_SMALL("Apple QuickDraw"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_VIXL,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vixl",
        .long_name = NULL_IF_CONFIG_SMALL("Miro VideoXL"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_QPEG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "qpeg",
        .long_name = NULL_IF_CONFIG_SMALL("Q-team QPEG"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FFVHUFF,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ffvhuff",
        .long_name = NULL_IF_CONFIG_SMALL("Huffyuv FFmpeg variant"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_RV30,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rv30",
        .long_name = NULL_IF_CONFIG_SMALL("RealVideo 3.0"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_RV40,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rv40",
        .long_name = NULL_IF_CONFIG_SMALL("RealVideo 4.0"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_VC1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vc1",
        .long_name = NULL_IF_CONFIG_SMALL("SMPTE VC-1"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_WMV3,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "wmv3",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Video 9"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_LOCO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "loco",
        .long_name = NULL_IF_CONFIG_SMALL("LOCO"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_WNV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "wnv1",
        .long_name = NULL_IF_CONFIG_SMALL("Winnov WNV1"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AASC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "aasc",
        .long_name = NULL_IF_CONFIG_SMALL("Autodesk RLE"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_INDEO2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "indeo2",
        .long_name = NULL_IF_CONFIG_SMALL("Intel Indeo 2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FRAPS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "fraps",
        .long_name = NULL_IF_CONFIG_SMALL("Fraps"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TRUEMOTION2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "truemotion2",
        .long_name = NULL_IF_CONFIG_SMALL("Duck TrueMotion 2.0"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BMP,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "bmp",
        .long_name = NULL_IF_CONFIG_SMALL("BMP (Windows and OS/2 bitmap)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/x-ms-bmp"),
    },
    {
        .id        = AV_CODEC_ID_CSCD,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cscd",
        .long_name = NULL_IF_CONFIG_SMALL("CamStudio"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MMVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mmvideo",
        .long_name = NULL_IF_CONFIG_SMALL("American Laser Games MM Video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ZMBV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "zmbv",
        .long_name = NULL_IF_CONFIG_SMALL("Zip Motion Blocks Video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_AVS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "avs",
        .long_name = NULL_IF_CONFIG_SMALL("AVS (Audio Video Standard) video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SMACKVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "smackvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Smacker video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_NUV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "nuv",
        .long_name = NULL_IF_CONFIG_SMALL("NuppelVideo/RTJPEG"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_KMVC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "kmvc",
        .long_name = NULL_IF_CONFIG_SMALL("Karl Morton's video codec"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FLASHSV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "flashsv",
        .long_name = NULL_IF_CONFIG_SMALL("Flash Screen Video v1"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_CAVS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cavs",
        .long_name = NULL_IF_CONFIG_SMALL("Chinese AVS (Audio Video Standard) (AVS1-P2, JiZhun profile)"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_JPEG2000,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "jpeg2000",
        .long_name = NULL_IF_CONFIG_SMALL("JPEG 2000"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/jp2"),
    },
    {
        .id        = AV_CODEC_ID_VMNC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vmnc",
        .long_name = NULL_IF_CONFIG_SMALL("VMware Screen Codec / VMware Video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_VP5,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp5",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP5"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP6,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp6",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP6"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP6F,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp6f",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP6 (Flash version)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DSICINVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dsicinvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Delphine Software International CIN video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TIERTEXSEQVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tiertexseqvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Tiertex Limited SEQ video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DXA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dxa",
        .long_name = NULL_IF_CONFIG_SMALL("Feeble Files/ScummVM DXA"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_DNXHD,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dnxhd",
        .long_name = NULL_IF_CONFIG_SMALL("VC3/DNxHD"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_THP,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "thp",
        .long_name = NULL_IF_CONFIG_SMALL("Nintendo Gamecube THP video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_C93,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "c93",
        .long_name = NULL_IF_CONFIG_SMALL("Interplay C93"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BETHSOFTVID,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "bethsoftvid",
        .long_name = NULL_IF_CONFIG_SMALL("Bethesda VID video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP6A,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp6a",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP6 (Flash version, with alpha channel)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AMV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "amv",
        .long_name = NULL_IF_CONFIG_SMALL("AMV Video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VB,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vb",
        .long_name = NULL_IF_CONFIG_SMALL("Beam Software VB"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_INDEO4,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "indeo4",
        .long_name = NULL_IF_CONFIG_SMALL("Intel Indeo Video Interactive 4"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_INDEO5,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "indeo5",
        .long_name = NULL_IF_CONFIG_SMALL("Intel Indeo Video Interactive 5"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MIMIC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mimic",
        .long_name = NULL_IF_CONFIG_SMALL("Mimic"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_RL2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "rl2",
        .long_name = NULL_IF_CONFIG_SMALL("RL2 video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ESCAPE124,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "escape124",
        .long_name = NULL_IF_CONFIG_SMALL("Escape 124"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DIRAC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dirac",
        .long_name = NULL_IF_CONFIG_SMALL("Dirac"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_BFI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "bfi",
        .long_name = NULL_IF_CONFIG_SMALL("Brute Force & Ignorance"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CMV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cmv",
        .long_name = NULL_IF_CONFIG_SMALL("Electronic Arts CMV video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MOTIONPIXELS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "motionpixels",
        .long_name = NULL_IF_CONFIG_SMALL("Motion Pixels video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TGV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tgv",
        .long_name = NULL_IF_CONFIG_SMALL("Electronic Arts TGV video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TGQ,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tgq",
        .long_name = NULL_IF_CONFIG_SMALL("Electronic Arts TGQ video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TQI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tqi",
        .long_name = NULL_IF_CONFIG_SMALL("Electronic Arts TQI video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AURA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "aura",
        .long_name = NULL_IF_CONFIG_SMALL("Auravision AURA"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AURA2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "aura2",
        .long_name = NULL_IF_CONFIG_SMALL("Auravision Aura 2"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_V210X,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "v210x",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed 4:2:2 10-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TMV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tmv",
        .long_name = NULL_IF_CONFIG_SMALL("8088flex TMV"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_V210,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "v210",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed 4:2:2 10-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MAD,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mad",
        .long_name = NULL_IF_CONFIG_SMALL("Electronic Arts Madcow Video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FRWU,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "frwu",
        .long_name = NULL_IF_CONFIG_SMALL("Forward Uncompressed"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_FLASHSV2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "flashsv2",
        .long_name = NULL_IF_CONFIG_SMALL("Flash Screen Video v2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CDGRAPHICS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cdgraphics",
        .long_name = NULL_IF_CONFIG_SMALL("CD Graphics video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_R210,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "r210",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed RGB 10-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ANM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "anm",
        .long_name = NULL_IF_CONFIG_SMALL("Deluxe Paint Animation"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BINKVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "binkvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Bink video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_IFF_ILBM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "iff_ilbm",
        .long_name = NULL_IF_CONFIG_SMALL("IFF ILBM"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_IFF_BYTERUN1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "iff_byterun1",
        .long_name = NULL_IF_CONFIG_SMALL("IFF ByteRun1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_KGV1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "kgv1",
        .long_name = NULL_IF_CONFIG_SMALL("Kega Game Video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_YOP,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "yop",
        .long_name = NULL_IF_CONFIG_SMALL("Psygnosis YOP Video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP8,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp8",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP8"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP9,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp9",
        .long_name = NULL_IF_CONFIG_SMALL("Google VP9"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PICTOR,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pictor",
        .long_name = NULL_IF_CONFIG_SMALL("Pictor/PC Paint"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_A64_MULTI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "a64_multi",
        .long_name = NULL_IF_CONFIG_SMALL("Multicolor charset for Commodore 64"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_A64_MULTI5,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "a64_multi5",
        .long_name = NULL_IF_CONFIG_SMALL("Multicolor charset for Commodore 64, extended with 5th color (colram)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_R10K,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "r10k",
        .long_name = NULL_IF_CONFIG_SMALL("AJA Kona 10-bit RGB Codec"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MVC1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mvc1",
        .long_name = NULL_IF_CONFIG_SMALL("Silicon Graphics Motion Video Compressor 1"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MVC2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mvc2",
        .long_name = NULL_IF_CONFIG_SMALL("Silicon Graphics Motion Video Compressor 2"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MXPEG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mxpeg",
        .long_name = NULL_IF_CONFIG_SMALL("Mobotix MxPEG video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_LAGARITH,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "lagarith",
        .long_name = NULL_IF_CONFIG_SMALL("Lagarith lossless"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PRORES,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "prores",
        .long_name = NULL_IF_CONFIG_SMALL("Apple ProRes (iCodec Pro)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_JV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "jv",
        .long_name = NULL_IF_CONFIG_SMALL("Bitmap Brothers JV video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DFA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dfa",
        .long_name = NULL_IF_CONFIG_SMALL("Chronomaster DFA"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_UTVIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "utvideo",
        .long_name = NULL_IF_CONFIG_SMALL("Ut Video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_BMV_VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "bmv_video",
        .long_name = NULL_IF_CONFIG_SMALL("Discworld II BMV video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_VBLE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vble",
        .long_name = NULL_IF_CONFIG_SMALL("VBLE Lossless Codec"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_DXTORY,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dxtory",
        .long_name = NULL_IF_CONFIG_SMALL("Dxtory"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_V410,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "v410",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed 4:4:4 10-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_CDXL,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cdxl",
        .long_name = NULL_IF_CONFIG_SMALL("Commodore CDXL video"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ZEROCODEC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "zerocodec",
        .long_name = NULL_IF_CONFIG_SMALL("ZeroCodec Lossless Video"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MSS1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mss1",
        .long_name = NULL_IF_CONFIG_SMALL("MS Screen 1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MSA1,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "msa1",
        .long_name = NULL_IF_CONFIG_SMALL("MS ATC Screen"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TSCC2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tscc2",
        .long_name = NULL_IF_CONFIG_SMALL("TechSmith Screen Codec 2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MTS2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mts2",
        .long_name = NULL_IF_CONFIG_SMALL("MS Expression Encoder Screen"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CLLC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cllc",
        .long_name = NULL_IF_CONFIG_SMALL("Canopus Lossless Codec"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MSS2,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "mss2",
        .long_name = NULL_IF_CONFIG_SMALL("MS Windows Media Video V9 Screen"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AIC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "aic",
        .long_name = NULL_IF_CONFIG_SMALL("Apple Intermediate Codec"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_Y41P,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "y41p",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed YUV 4:1:1 12-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_ESCAPE130,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "escape130",
        .long_name = NULL_IF_CONFIG_SMALL("Escape 130"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AVRP,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "avrp",
        .long_name = NULL_IF_CONFIG_SMALL("Avid 1:1 10-bit RGB Packer"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_012V,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "012v",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed 4:2:2 10-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_AVUI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "avui",
        .long_name = NULL_IF_CONFIG_SMALL("Avid Meridien Uncompressed"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_AYUV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ayuv",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed packed MS 4:4:4:4"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_TARGA_Y216,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "targa_y216",
        .long_name = NULL_IF_CONFIG_SMALL("Pinnacle TARGA CineWave YUV16"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_V308,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "v308",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed packed 4:4:4"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_V408,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "v408",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed packed QT 4:4:4:4"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_YUV4,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "yuv4",
        .long_name = NULL_IF_CONFIG_SMALL("Uncompressed packed 4:2:0"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_AVRN,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "avrn",
        .long_name = NULL_IF_CONFIG_SMALL("Avid AVI Codec"),
    },
    {
        .id        = AV_CODEC_ID_CPIA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "cpia",
        .long_name = NULL_IF_CONFIG_SMALL("CPiA video format"),
    },
    {
        .id        = AV_CODEC_ID_XFACE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xface",
        .long_name = NULL_IF_CONFIG_SMALL("X-face image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SMVJPEG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "smv",
        .long_name = NULL_IF_CONFIG_SMALL("Sigmatel Motion Video"),
    },

    {
        .id        = AV_CODEC_ID_G2M,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "g2m",
        .long_name = NULL_IF_CONFIG_SMALL("Go2Meeting"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_HNM4_VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "hnm4video",
        .long_name = NULL_IF_CONFIG_SMALL("HNM 4 video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_HEVC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "hevc",
        .long_name = NULL_IF_CONFIG_SMALL("H.265 / HEVC (High Efficiency Video Coding)"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_REORDER,
    },
    {
        .id        = AV_CODEC_ID_FIC,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "fic",
        .long_name = NULL_IF_CONFIG_SMALL("Mirillis FIC"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PAF_VIDEO,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "paf_video",
        .long_name = NULL_IF_CONFIG_SMALL("Amazing Studio Packed Animation File Video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP7,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp7",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP7"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SANM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sanm",
        .long_name = NULL_IF_CONFIG_SMALL("LucasArts SANM/SMUSH video"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SGIRLE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sgirle",
        .long_name = NULL_IF_CONFIG_SMALL("SGI RLE 8-bit"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },

    /* image codecs */
    {
        .id        = AV_CODEC_ID_ALIAS_PIX,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "alias_pix",
        .long_name = NULL_IF_CONFIG_SMALL("Alias/Wavefront PIX image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ANSI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ansi",
        .long_name = NULL_IF_CONFIG_SMALL("ASCII/ANSI art"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BRENDER_PIX,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "brender_pix",
        .long_name = NULL_IF_CONFIG_SMALL("BRender PIX image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_DPX,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "dpx",
        .long_name = NULL_IF_CONFIG_SMALL("DPX (Digital Picture Exchange) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_EXR,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "exr",
        .long_name = NULL_IF_CONFIG_SMALL("OpenEXR image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_GIF,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "gif",
        .long_name = NULL_IF_CONFIG_SMALL("GIF (Graphics Interchange Format)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/gif"),
    },
    {
        .id        = AV_CODEC_ID_JPEGLS,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "jpegls",
        .long_name = NULL_IF_CONFIG_SMALL("JPEG-LS"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_LJPEG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ljpeg",
        .long_name = NULL_IF_CONFIG_SMALL("Lossless JPEG"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PAM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pam",
        .long_name = NULL_IF_CONFIG_SMALL("PAM (Portable AnyMap) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/x-portable-pixmap"),
    },
    {
        .id        = AV_CODEC_ID_PBM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pbm",
        .long_name = NULL_IF_CONFIG_SMALL("PBM (Portable BitMap) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCX,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pcx",
        .long_name = NULL_IF_CONFIG_SMALL("PC Paintbrush PCX image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/x-pcx"),
    },
    {
        .id        = AV_CODEC_ID_PGM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pgm",
        .long_name = NULL_IF_CONFIG_SMALL("PGM (Portable GrayMap) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PGMYUV,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "pgmyuv",
        .long_name = NULL_IF_CONFIG_SMALL("PGMYUV (Portable GrayMap YUV) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PNG,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "png",
        .long_name = NULL_IF_CONFIG_SMALL("PNG (Portable Network Graphics) image"),
        .props     = AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/png"),
    },
    {
        .id        = AV_CODEC_ID_PPM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ppm",
        .long_name = NULL_IF_CONFIG_SMALL("PPM (Portable PixelMap) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PTX,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "ptx",
        .long_name = NULL_IF_CONFIG_SMALL("V.Flash PTX image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SGI,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sgi",
        .long_name = NULL_IF_CONFIG_SMALL("SGI image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_SP5X,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sp5x",
        .long_name = NULL_IF_CONFIG_SMALL("Sunplus JPEG (SP5X)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SUNRAST,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sunrast",
        .long_name = NULL_IF_CONFIG_SMALL("Sun Rasterfile image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TARGA,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "targa",
        .long_name = NULL_IF_CONFIG_SMALL("Truevision Targa image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/x-targa", "image/x-tga"),
    },
    {
        .id        = AV_CODEC_ID_TIFF,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "tiff",
        .long_name = NULL_IF_CONFIG_SMALL("TIFF image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/tiff"),
    },
    {
        .id        = AV_CODEC_ID_TXD,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "txd",
        .long_name = NULL_IF_CONFIG_SMALL("Renderware TXD (TeXture Dictionary) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VC1IMAGE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vc1image",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Video 9 Image v2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WEBP,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "webp",
        .long_name = NULL_IF_CONFIG_SMALL("WebP"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/webp"),
    },
    {
        .id        = AV_CODEC_ID_WMV3IMAGE,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "wmv3image",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Video 9 Image"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_XBM,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xbm",
        .long_name = NULL_IF_CONFIG_SMALL("XBM (X BitMap) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_XWD,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xwd",
        .long_name = NULL_IF_CONFIG_SMALL("XWD (X Window Dump) image"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
        .mime_types= MT("image/x-xwindowdump"),
    },

    /* various PCM "codecs" */
    {
        .id        = AV_CODEC_ID_PCM_S16LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s16le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 16-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S16BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s16be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 16-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U16LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u16le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 16-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U16BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u16be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 16-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S8,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s8",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 8-bit"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U8,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u8",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 8-bit"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_MULAW,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_mulaw",
        .long_name = NULL_IF_CONFIG_SMALL("PCM mu-law / G.711 mu-law"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PCM_ALAW,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_alaw",
        .long_name = NULL_IF_CONFIG_SMALL("PCM A-law / G.711 A-law"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PCM_S32LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s32le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 32-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S32BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s32be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 32-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U32LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u32le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 32-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U32BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u32be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 32-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S24LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s24le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 24-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S24BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s24be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 24-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U24LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u24le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 24-bit little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_U24BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_u24be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM unsigned 24-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S24DAUD,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s24daud",
        .long_name = NULL_IF_CONFIG_SMALL("PCM D-Cinema audio signed 24-bit"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_ZORK,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_zork",
        .long_name = NULL_IF_CONFIG_SMALL("PCM Zork"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PCM_S16BE_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s16be_planar",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 16-bit big-endian planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S16LE_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s16le_planar",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 16-bit little-endian planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S24LE_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s24le_planar",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 24-bit little-endian planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S32LE_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s32le_planar",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 32-bit little-endian planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_DVD,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_dvd",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 20|24-bit big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_F32BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_f32be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM 32-bit floating point big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_F32LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_f32le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM 32-bit floating point little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_F64BE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_f64be",
        .long_name = NULL_IF_CONFIG_SMALL("PCM 64-bit floating point big-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_F64LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_f64le",
        .long_name = NULL_IF_CONFIG_SMALL("PCM 64-bit floating point little-endian"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_BLURAY,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_bluray",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 16|20|24-bit big-endian for Blu-ray media"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_LXF,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_lxf",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 20-bit little-endian planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_S302M,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "s302m",
        .long_name = NULL_IF_CONFIG_SMALL("SMPTE 302M"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S8_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s8_planar",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 8-bit planar"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },

    /* various ADPCM codecs */
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_QT,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_qt",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA QuickTime"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_WAV,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_wav",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA WAV"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_DK3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_dk3",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Duck DK3"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_DK4,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_dk4",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Duck DK4"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_WS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_ws",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Westwood"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_SMJPEG,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_smjpeg",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Loki SDL MJPEG"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_MS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ms",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Microsoft"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_4XM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_4xm",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM 4X Movie"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_XA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_xa",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM CDROM XA"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_ADX,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_adx",
        .long_name = NULL_IF_CONFIG_SMALL("SEGA CRI ADX ADPCM"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_G726,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_g726",
        .long_name = NULL_IF_CONFIG_SMALL("G.726 ADPCM"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_CT,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ct",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Creative Technology"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_SWF,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_swf",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Shockwave Flash"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_YAMAHA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_yamaha",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Yamaha"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_SBPRO_4,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_sbpro_4",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Sound Blaster Pro 4-bit"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_SBPRO_3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_sbpro_3",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Sound Blaster Pro 2.6-bit"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_SBPRO_2,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_sbpro_2",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Sound Blaster Pro 2-bit"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_THP,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_thp",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Nintendo Gamecube THP"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_AMV,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_amv",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA AMV"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA_R1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea_r1",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts R1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA_R3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea_r3",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts R3"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA_R2,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea_r2",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts R2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_EA_SEAD,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_ea_sead",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Electronic Arts SEAD"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_EA_EACS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_ea_eacs",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Electronic Arts EACS"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA_XAS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea_xas",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts XAS"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_EA_MAXIS_XA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ea_maxis_xa",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Electronic Arts Maxis CDROM XA"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_ISS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_iss",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Funcom ISS"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_G722,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_g722",
        .long_name = NULL_IF_CONFIG_SMALL("G.722 ADPCM"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_APC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_apc",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA CRYO APC"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_AFC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_afc",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Nintendo Gamecube AFC"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_OKI,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_oki",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Dialogic OKI"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_DTK,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_dtk",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM Nintendo Gamecube DTK"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_IMA_RAD,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_ima_rad",
        .long_name = NULL_IF_CONFIG_SMALL("ADPCM IMA Radical"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_G726LE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_g726le",
        .long_name = NULL_IF_CONFIG_SMALL("G.726 ADPCM little-endian"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_VIMA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_vima",
        .long_name = NULL_IF_CONFIG_SMALL("LucasArts VIMA audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },

    /* AMR */
    {
        .id        = AV_CODEC_ID_AMR_NB,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "amr_nb",
        .long_name = NULL_IF_CONFIG_SMALL("AMR-NB (Adaptive Multi-Rate NarrowBand)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AMR_WB,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "amr_wb",
        .long_name = NULL_IF_CONFIG_SMALL("AMR-WB (Adaptive Multi-Rate WideBand)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },

    /* RealAudio codecs*/
    {
        .id        = AV_CODEC_ID_RA_144,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ra_144",
        .long_name = NULL_IF_CONFIG_SMALL("RealAudio 1.0 (14.4K)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_RA_288,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ra_288",
        .long_name = NULL_IF_CONFIG_SMALL("RealAudio 2.0 (28.8K)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },

    /* various DPCM codecs */
    {
        .id        = AV_CODEC_ID_ROQ_DPCM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "roq_dpcm",
        .long_name = NULL_IF_CONFIG_SMALL("DPCM id RoQ"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_INTERPLAY_DPCM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "interplay_dpcm",
        .long_name = NULL_IF_CONFIG_SMALL("DPCM Interplay"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_XAN_DPCM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "xan_dpcm",
        .long_name = NULL_IF_CONFIG_SMALL("DPCM Xan"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SOL_DPCM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "sol_dpcm",
        .long_name = NULL_IF_CONFIG_SMALL("DPCM Sol"),
        .props     = AV_CODEC_PROP_LOSSY,
    },

    /* audio codecs */
    {
        .id        = AV_CODEC_ID_MP2,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp2",
        .long_name = NULL_IF_CONFIG_SMALL("MP2 (MPEG audio layer 2)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MP3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp3",
        .long_name = NULL_IF_CONFIG_SMALL("MP3 (MPEG audio layer 3)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AAC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "aac",
        .long_name = NULL_IF_CONFIG_SMALL("AAC (Advanced Audio Coding)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AC3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ac3",
        .long_name = NULL_IF_CONFIG_SMALL("ATSC A/52A (AC-3)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DTS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dts",
        .long_name = NULL_IF_CONFIG_SMALL("DCA (DTS Coherent Acoustics)"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_VORBIS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "vorbis",
        .long_name = NULL_IF_CONFIG_SMALL("Vorbis"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DVAUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dvaudio",
        .long_name = NULL_IF_CONFIG_SMALL("DV audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMAV1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wmav1",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Audio 1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMAV2,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wmav2",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Audio 2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MACE3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mace3",
        .long_name = NULL_IF_CONFIG_SMALL("MACE (Macintosh Audio Compression/Expansion) 3:1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MACE6,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mace6",
        .long_name = NULL_IF_CONFIG_SMALL("MACE (Macintosh Audio Compression/Expansion) 6:1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VMDAUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "vmdaudio",
        .long_name = NULL_IF_CONFIG_SMALL("Sierra VMD audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FLAC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "flac",
        .long_name = NULL_IF_CONFIG_SMALL("FLAC (Free Lossless Audio Codec)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MP3ADU,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp3adu",
        .long_name = NULL_IF_CONFIG_SMALL("ADU (Application Data Unit) MP3 (MPEG audio layer 3)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MP3ON4,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp3on4",
        .long_name = NULL_IF_CONFIG_SMALL("MP3onMP4"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SHORTEN,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "shorten",
        .long_name = NULL_IF_CONFIG_SMALL("Shorten"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ALAC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "alac",
        .long_name = NULL_IF_CONFIG_SMALL("ALAC (Apple Lossless Audio Codec)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_WESTWOOD_SND1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "westwood_snd1",
        .long_name = NULL_IF_CONFIG_SMALL("Westwood Audio (SND1)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_GSM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "gsm",
        .long_name = NULL_IF_CONFIG_SMALL("GSM"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_QDM2,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "qdm2",
        .long_name = NULL_IF_CONFIG_SMALL("QDesign Music Codec 2"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_COOK,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "cook",
        .long_name = NULL_IF_CONFIG_SMALL("Cook / Cooker / Gecko (RealAudio G2)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TRUESPEECH,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "truespeech",
        .long_name = NULL_IF_CONFIG_SMALL("DSP Group TrueSpeech"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TTA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "tta",
        .long_name = NULL_IF_CONFIG_SMALL("TTA (True Audio)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_SMACKAUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "smackaudio",
        .long_name = NULL_IF_CONFIG_SMALL("Smacker audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_QCELP,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "qcelp",
        .long_name = NULL_IF_CONFIG_SMALL("QCELP / PureVoice"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WAVPACK,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wavpack",
        .long_name = NULL_IF_CONFIG_SMALL("WavPack"),
        .props     = AV_CODEC_PROP_LOSSY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_DSICINAUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dsicinaudio",
        .long_name = NULL_IF_CONFIG_SMALL("Delphine Software International CIN audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_IMC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "imc",
        .long_name = NULL_IF_CONFIG_SMALL("IMC (Intel Music Coder)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MUSEPACK7,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "musepack7",
        .long_name = NULL_IF_CONFIG_SMALL("Musepack SV7"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MLP,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mlp",
        .long_name = NULL_IF_CONFIG_SMALL("MLP (Meridian Lossless Packing)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_GSM_MS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "gsm_ms",
        .long_name = NULL_IF_CONFIG_SMALL("GSM Microsoft variant"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ATRAC3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "atrac3",
        .long_name = NULL_IF_CONFIG_SMALL("ATRAC3 (Adaptive TRansform Acoustic Coding 3)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
#if FF_API_VOXWARE
    {
        .id        = AV_CODEC_ID_VOXWARE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "voxware",
        .long_name = NULL_IF_CONFIG_SMALL("Voxware RT29 Metasound"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
#endif
    {
        .id        = AV_CODEC_ID_APE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ape",
        .long_name = NULL_IF_CONFIG_SMALL("Monkey's Audio"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_NELLYMOSER,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "nellymoser",
        .long_name = NULL_IF_CONFIG_SMALL("Nellymoser Asao"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MUSEPACK8,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "musepack8",
        .long_name = NULL_IF_CONFIG_SMALL("Musepack SV8"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SPEEX,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "speex",
        .long_name = NULL_IF_CONFIG_SMALL("Speex"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMAVOICE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wmavoice",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Audio Voice"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMAPRO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wmapro",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Audio 9 Professional"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WMALOSSLESS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wmalossless",
        .long_name = NULL_IF_CONFIG_SMALL("Windows Media Audio Lossless"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ATRAC3P,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "atrac3p",
        .long_name = NULL_IF_CONFIG_SMALL("ATRAC3+ (Adaptive TRansform Acoustic Coding 3+)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_EAC3,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "eac3",
        .long_name = NULL_IF_CONFIG_SMALL("ATSC A/52B (AC-3, E-AC-3)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SIPR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "sipr",
        .long_name = NULL_IF_CONFIG_SMALL("RealAudio SIPR / ACELP.NET"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_MP1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp1",
        .long_name = NULL_IF_CONFIG_SMALL("MP1 (MPEG audio layer 1)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TWINVQ,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "twinvq",
        .long_name = NULL_IF_CONFIG_SMALL("VQF TwinVQ"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TRUEHD,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "truehd",
        .long_name = NULL_IF_CONFIG_SMALL("TrueHD"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_MP4ALS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "mp4als",
        .long_name = NULL_IF_CONFIG_SMALL("MPEG-4 Audio Lossless Coding (ALS)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ATRAC1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "atrac1",
        .long_name = NULL_IF_CONFIG_SMALL("ATRAC1 (Adaptive TRansform Acoustic Coding)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BINKAUDIO_RDFT,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "binkaudio_rdft",
        .long_name = NULL_IF_CONFIG_SMALL("Bink Audio (RDFT)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BINKAUDIO_DCT,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "binkaudio_dct",
        .long_name = NULL_IF_CONFIG_SMALL("Bink Audio (DCT)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_AAC_LATM,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "aac_latm",
        .long_name = NULL_IF_CONFIG_SMALL("AAC LATM (Advanced Audio Coding LATM syntax)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_QDMC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "qdmc",
        .long_name = NULL_IF_CONFIG_SMALL("QDesign Music"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_CELT,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "celt",
        .long_name = NULL_IF_CONFIG_SMALL("Constrained Energy Lapped Transform (CELT)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_G723_1,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "g723_1",
        .long_name = NULL_IF_CONFIG_SMALL("G.723.1"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_G729,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "g729",
        .long_name = NULL_IF_CONFIG_SMALL("G.729"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_8SVX_EXP,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "8svx_exp",
        .long_name = NULL_IF_CONFIG_SMALL("8SVX exponential"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_8SVX_FIB,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "8svx_fib",
        .long_name = NULL_IF_CONFIG_SMALL("8SVX fibonacci"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_BMV_AUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "bmv_audio",
        .long_name = NULL_IF_CONFIG_SMALL("Discworld II BMV audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_RALF,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ralf",
        .long_name = NULL_IF_CONFIG_SMALL("RealAudio Lossless"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_IAC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "iac",
        .long_name = NULL_IF_CONFIG_SMALL("IAC (Indeo Audio Coder)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ILBC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "ilbc",
        .long_name = NULL_IF_CONFIG_SMALL("iLBC (Internet Low Bitrate Codec)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_FFWAVESYNTH,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "wavesynth",
        .long_name = NULL_IF_CONFIG_SMALL("Wave synthesis pseudo-codec"),
    },
    {
        .id        = AV_CODEC_ID_SONIC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "sonic",
        .long_name = NULL_IF_CONFIG_SMALL("Sonic"),
    },
    {
        .id        = AV_CODEC_ID_SONIC_LS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "sonicls",
        .long_name = NULL_IF_CONFIG_SMALL("Sonic lossless"),
    },
    {
        .id        = AV_CODEC_ID_OPUS,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "opus",
        .long_name = NULL_IF_CONFIG_SMALL("Opus (Opus Interactive Audio Codec)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_COMFORT_NOISE,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "comfortnoise",
        .long_name = NULL_IF_CONFIG_SMALL("RFC 3389 Comfort Noise"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_TAK,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "tak",
        .long_name = NULL_IF_CONFIG_SMALL("TAK (Tom's lossless Audio Kompressor)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_METASOUND,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "metasound",
        .long_name = NULL_IF_CONFIG_SMALL("Voxware MetaSound"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PAF_AUDIO,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "paf_audio",
        .long_name = NULL_IF_CONFIG_SMALL("Amazing Studio Packed Animation File Audio"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ON2AVC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "avc",
        .long_name = NULL_IF_CONFIG_SMALL("On2 Audio for Video Codec"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_EVRC,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "evrc",
        .long_name = NULL_IF_CONFIG_SMALL("EVRC (Enhanced Variable Rate Codec)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SMV,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "smv",
        .long_name = NULL_IF_CONFIG_SMALL("SMV (Selectable Mode Vocoder)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DSD_LSBF,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dsd_lsbf",
        .long_name = NULL_IF_CONFIG_SMALL("DSD (Direct Stream Digital), least significant bit first"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DSD_MSBF,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dsd_msbf",
        .long_name = NULL_IF_CONFIG_SMALL("DSD (Direct Stream Digital), most significant bit first"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DSD_LSBF_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dsd_lsbf_planar",
        .long_name = NULL_IF_CONFIG_SMALL("DSD (Direct Stream Digital), least significant bit first, planar"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_DSD_MSBF_PLANAR,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "dsd_msbf_planar",
        .long_name = NULL_IF_CONFIG_SMALL("DSD (Direct Stream Digital), most significant bit first, planar"),
        .props     = AV_CODEC_PROP_LOSSY,
    },

    /* subtitle codecs */
    {
        .id        = AV_CODEC_ID_DVD_SUBTITLE,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "dvd_subtitle",
        .long_name = NULL_IF_CONFIG_SMALL("DVD subtitles"),
        .props     = AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        .id        = AV_CODEC_ID_DVB_SUBTITLE,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "dvb_subtitle",
        .long_name = NULL_IF_CONFIG_SMALL("DVB subtitles"),
        .props     = AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        .id        = AV_CODEC_ID_TEXT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "text",
        .long_name = NULL_IF_CONFIG_SMALL("raw UTF-8 text"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_XSUB,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "xsub",
        .long_name = NULL_IF_CONFIG_SMALL("XSUB"),
        .props     = AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        .id        = AV_CODEC_ID_ASS,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "ass",
        .long_name = NULL_IF_CONFIG_SMALL("ASS (Advanced SSA) subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_SSA,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "ssa",
        .long_name = NULL_IF_CONFIG_SMALL("SSA (SubStation Alpha) subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_MOV_TEXT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "mov_text",
        .long_name = NULL_IF_CONFIG_SMALL("MOV text"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_HDMV_PGS_SUBTITLE,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "hdmv_pgs_subtitle",
        .long_name = NULL_IF_CONFIG_SMALL("HDMV Presentation Graphic Stream subtitles"),
        .props     = AV_CODEC_PROP_BITMAP_SUB,
    },
    {
        .id        = AV_CODEC_ID_DVB_TELETEXT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "dvb_teletext",
        .long_name = NULL_IF_CONFIG_SMALL("DVB teletext"),
    },
    {
        .id        = AV_CODEC_ID_SRT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "srt",
        .long_name = NULL_IF_CONFIG_SMALL("SubRip subtitle with embedded timing"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_SUBRIP,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "subrip",
        .long_name = NULL_IF_CONFIG_SMALL("SubRip subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_MICRODVD,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "microdvd",
        .long_name = NULL_IF_CONFIG_SMALL("MicroDVD subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_MPL2,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "mpl2",
        .long_name = NULL_IF_CONFIG_SMALL("MPL2 subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_EIA_608,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "eia_608",
        .long_name = NULL_IF_CONFIG_SMALL("EIA-608 closed captions"),
    },
    {
        .id        = AV_CODEC_ID_JACOSUB,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "jacosub",
        .long_name = NULL_IF_CONFIG_SMALL("JACOsub subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_PJS,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "pjs",
        .long_name = NULL_IF_CONFIG_SMALL("PJS (Phoenix Japanimation Society) subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_SAMI,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "sami",
        .long_name = NULL_IF_CONFIG_SMALL("SAMI subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_REALTEXT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "realtext",
        .long_name = NULL_IF_CONFIG_SMALL("RealText subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_SUBVIEWER1,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "subviewer1",
        .long_name = NULL_IF_CONFIG_SMALL("SubViewer v1 subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_SUBVIEWER,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "subviewer",
        .long_name = NULL_IF_CONFIG_SMALL("SubViewer subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_VPLAYER,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "vplayer",
        .long_name = NULL_IF_CONFIG_SMALL("VPlayer subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },
    {
        .id        = AV_CODEC_ID_WEBVTT,
        .type      = AVMEDIA_TYPE_SUBTITLE,
        .name      = "webvtt",
        .long_name = NULL_IF_CONFIG_SMALL("WebVTT subtitle"),
        .props     = AV_CODEC_PROP_TEXT_SUB,
    },

    /* other kind of codecs and pseudo-codecs */
    {
        .id        = AV_CODEC_ID_TTF,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "ttf",
        .long_name = NULL_IF_CONFIG_SMALL("TrueType font"),
        .mime_types= MT("application/x-truetype-font", "application/x-font"),
    },
    {
        .id        = AV_CODEC_ID_BINTEXT,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "bintext",
        .long_name = NULL_IF_CONFIG_SMALL("Binary text"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_XBIN,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "xbin",
        .long_name = NULL_IF_CONFIG_SMALL("eXtended BINary text"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_IDF,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "idf",
        .long_name = NULL_IF_CONFIG_SMALL("iCEDraw text"),
        .props     = AV_CODEC_PROP_INTRA_ONLY,
    },
    {
        .id        = AV_CODEC_ID_OTF,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "otf",
        .long_name = NULL_IF_CONFIG_SMALL("OpenType font"),
        .mime_types= MT("application/vnd.ms-opentype"),
    },
    {
        .id        = AV_CODEC_ID_SMPTE_KLV,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "klv",
        .long_name = NULL_IF_CONFIG_SMALL("SMPTE 336M Key-Length-Value (KLV) metadata"),
    },
    {
        .id        = AV_CODEC_ID_DVD_NAV,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "dvd_nav_packet",
        .long_name = NULL_IF_CONFIG_SMALL("DVD Nav packet"),
    },
    {
        .id        = AV_CODEC_ID_TIMED_ID3,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "timed_id3",
        .long_name = NULL_IF_CONFIG_SMALL("timed ID3 metadata"),
    },
    {
        .id        = AV_CODEC_ID_BIN_DATA,
        .type      = AVMEDIA_TYPE_DATA,
        .name      = "bin_data",
        .long_name = NULL_IF_CONFIG_SMALL("binary data"),
        .mime_types= MT("application/octet-stream"),
    },

    /* deprecated codec ids */
    {
        .id        = AV_CODEC_ID_BRENDER_PIX_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "brender_pix_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("BRender PIX image (deprecated id)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_ESCAPE130_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "escape130_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("Escape 130 (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_EXR_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "exr_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("OpenEXR image (deprecated id)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_G2M_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "g2m_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("Go2Meeting (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_HEVC_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "hevc_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("H.265 / HEVC (High Efficiency Video Coding) (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PAF_VIDEO_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "paf_video_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("Amazing Studio Packed Animation File Video (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_SANM_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "sanm_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("LucasArts SANM/SMUSH video (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_VP7_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "vp7_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("On2 VP7 (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_WEBP_DEPRECATED,
        .type      = AVMEDIA_TYPE_VIDEO,
        .name      = "webp_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("WebP (deprecated id)"),
        .props     = AV_CODEC_PROP_INTRA_ONLY | AV_CODEC_PROP_LOSSY |
                     AV_CODEC_PROP_LOSSLESS,
    },

    {
        .id        = AV_CODEC_ID_VIMA,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "vima",
        .long_name = NULL_IF_CONFIG_SMALL("LucasArts VIMA audio (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_ADPCM_VIMA_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "adpcm_vima_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("LucasArts VIMA audio (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_OPUS_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "opus_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("Opus (Opus Interactive Audio Codec) (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PAF_AUDIO_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "paf_audio_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("Amazing Studio Packed Animation File Audio (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSY,
    },
    {
        .id        = AV_CODEC_ID_PCM_S24LE_PLANAR_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s24le_planar_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 24-bit little-endian planar (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_PCM_S32LE_PLANAR_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "pcm_s32le_planar_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("PCM signed 32-bit little-endian planar (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
    {
        .id        = AV_CODEC_ID_TAK_DEPRECATED,
        .type      = AVMEDIA_TYPE_AUDIO,
        .name      = "tak_deprecated",
        .long_name = NULL_IF_CONFIG_SMALL("TAK (Tom's lossless Audio Kompressor) (deprecated id)"),
        .props     = AV_CODEC_PROP_LOSSLESS,
    },
#endif
};

const AVCodecDescriptor *avcodec_descriptor_get(enum AVCodecID id)
{
    int i;

    for (i = 0; i < FF_ARRAY_ELEMS(codec_descriptors); i++)
        if (codec_descriptors[i].id == id)
            return &codec_descriptors[i];
    return NULL;
}

const AVCodecDescriptor *avcodec_descriptor_next(const AVCodecDescriptor *prev)
{
    if (!prev)
        return &codec_descriptors[0];
    if (prev - codec_descriptors < FF_ARRAY_ELEMS(codec_descriptors) - 1)
        return prev + 1;
    return NULL;
}

const AVCodecDescriptor *avcodec_descriptor_get_by_name(const char *name)
{
    const AVCodecDescriptor *desc = NULL;

    while ((desc = avcodec_descriptor_next(desc)))
        if (!strcmp(desc->name, name))
            return desc;
    return NULL;
}
