// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Definitions of system bug check codes
use shared::ntdef::ULONG;
pub const HARDWARE_PROFILE_UNDOCKED_STRING: ULONG = 0x40010001;
pub const HARDWARE_PROFILE_DOCKED_STRING: ULONG = 0x40010002;
pub const HARDWARE_PROFILE_UNKNOWN_STRING: ULONG = 0x40010003;
pub const WINDOWS_NT_BANNER: ULONG = 0x4000007E;
pub const WINDOWS_NT_CSD_STRING: ULONG = 0x40000087;
pub const WINDOWS_NT_INFO_STRING: ULONG = 0x40000088;
pub const WINDOWS_NT_MP_STRING: ULONG = 0x40000089;
pub const THREAD_TERMINATE_HELD_MUTEX: ULONG = 0x4000008A;
pub const WINDOWS_NT_INFO_STRING_PLURAL: ULONG = 0x4000009D;
pub const WINDOWS_NT_RC_STRING: ULONG = 0x4000009E;
pub const APC_INDEX_MISMATCH: ULONG = 0x00000001;
pub const DEVICE_QUEUE_NOT_BUSY: ULONG = 0x00000002;
pub const INVALID_AFFINITY_SET: ULONG = 0x00000003;
pub const INVALID_DATA_ACCESS_TRAP: ULONG = 0x00000004;
pub const INVALID_PROCESS_ATTACH_ATTEMPT: ULONG = 0x00000005;
pub const INVALID_PROCESS_DETACH_ATTEMPT: ULONG = 0x00000006;
pub const INVALID_SOFTWARE_INTERRUPT: ULONG = 0x00000007;
pub const IRQL_NOT_DISPATCH_LEVEL: ULONG = 0x00000008;
pub const IRQL_NOT_GREATER_OR_EQUAL: ULONG = 0x00000009;
pub const IRQL_NOT_LESS_OR_EQUAL: ULONG = 0x0000000A;
pub const NO_EXCEPTION_HANDLING_SUPPORT: ULONG = 0x0000000B;
pub const MAXIMUM_WAIT_OBJECTS_EXCEEDED: ULONG = 0x0000000C;
pub const MUTEX_LEVEL_NUMBER_VIOLATION: ULONG = 0x0000000D;
pub const NO_USER_MODE_CONTEXT: ULONG = 0x0000000E;
pub const SPIN_LOCK_ALREADY_OWNED: ULONG = 0x0000000F;
pub const SPIN_LOCK_NOT_OWNED: ULONG = 0x00000010;
pub const THREAD_NOT_MUTEX_OWNER: ULONG = 0x00000011;
pub const TRAP_CAUSE_UNKNOWN: ULONG = 0x00000012;
pub const EMPTY_THREAD_REAPER_LIST: ULONG = 0x00000013;
pub const CREATE_DELETE_LOCK_NOT_LOCKED: ULONG = 0x00000014;
pub const LAST_CHANCE_CALLED_FROM_KMODE: ULONG = 0x00000015;
pub const CID_HANDLE_CREATION: ULONG = 0x00000016;
pub const CID_HANDLE_DELETION: ULONG = 0x00000017;
pub const REFERENCE_BY_POINTER: ULONG = 0x00000018;
pub const BAD_POOL_HEADER: ULONG = 0x00000019;
pub const MEMORY_MANAGEMENT: ULONG = 0x0000001A;
pub const PFN_SHARE_COUNT: ULONG = 0x0000001B;
pub const PFN_REFERENCE_COUNT: ULONG = 0x0000001C;
pub const NO_SPIN_LOCK_AVAILABLE: ULONG = 0x0000001D;
pub const KMODE_EXCEPTION_NOT_HANDLED: ULONG = 0x0000001E;
pub const SHARED_RESOURCE_CONV_ERROR: ULONG = 0x0000001F;
pub const KERNEL_APC_PENDING_DURING_EXIT: ULONG = 0x00000020;
pub const QUOTA_UNDERFLOW: ULONG = 0x00000021;
pub const FILE_SYSTEM: ULONG = 0x00000022;
pub const FAT_FILE_SYSTEM: ULONG = 0x00000023;
pub const NTFS_FILE_SYSTEM: ULONG = 0x00000024;
pub const NPFS_FILE_SYSTEM: ULONG = 0x00000025;
pub const CDFS_FILE_SYSTEM: ULONG = 0x00000026;
pub const RDR_FILE_SYSTEM: ULONG = 0x00000027;
pub const CORRUPT_ACCESS_TOKEN: ULONG = 0x00000028;
pub const SECURITY_SYSTEM: ULONG = 0x00000029;
pub const INCONSISTENT_IRP: ULONG = 0x0000002A;
pub const PANIC_STACK_SWITCH: ULONG = 0x0000002B;
pub const PORT_DRIVER_INTERNAL: ULONG = 0x0000002C;
pub const SCSI_DISK_DRIVER_INTERNAL: ULONG = 0x0000002D;
pub const DATA_BUS_ERROR: ULONG = 0x0000002E;
pub const INSTRUCTION_BUS_ERROR: ULONG = 0x0000002F;
pub const SET_OF_INVALID_CONTEXT: ULONG = 0x00000030;
pub const PHASE0_INITIALIZATION_FAILED: ULONG = 0x00000031;
pub const PHASE1_INITIALIZATION_FAILED: ULONG = 0x00000032;
pub const UNEXPECTED_INITIALIZATION_CALL: ULONG = 0x00000033;
pub const CACHE_MANAGER: ULONG = 0x00000034;
pub const NO_MORE_IRP_STACK_LOCATIONS: ULONG = 0x00000035;
pub const DEVICE_REFERENCE_COUNT_NOT_ZERO: ULONG = 0x00000036;
pub const FLOPPY_INTERNAL_ERROR: ULONG = 0x00000037;
pub const SERIAL_DRIVER_INTERNAL: ULONG = 0x00000038;
pub const SYSTEM_EXIT_OWNED_MUTEX: ULONG = 0x00000039;
pub const SYSTEM_UNWIND_PREVIOUS_USER: ULONG = 0x0000003A;
pub const SYSTEM_SERVICE_EXCEPTION: ULONG = 0x0000003B;
pub const INTERRUPT_UNWIND_ATTEMPTED: ULONG = 0x0000003C;
pub const INTERRUPT_EXCEPTION_NOT_HANDLED: ULONG = 0x0000003D;
pub const MULTIPROCESSOR_CONFIGURATION_NOT_SUPPORTED: ULONG = 0x0000003E;
pub const NO_MORE_SYSTEM_PTES: ULONG = 0x0000003F;
pub const TARGET_MDL_TOO_SMALL: ULONG = 0x00000040;
pub const MUST_SUCCEED_POOL_EMPTY: ULONG = 0x00000041;
pub const ATDISK_DRIVER_INTERNAL: ULONG = 0x00000042;
pub const NO_SUCH_PARTITION: ULONG = 0x00000043;
pub const MULTIPLE_IRP_COMPLETE_REQUESTS: ULONG = 0x00000044;
pub const INSUFFICIENT_SYSTEM_MAP_REGS: ULONG = 0x00000045;
pub const DEREF_UNKNOWN_LOGON_SESSION: ULONG = 0x00000046;
pub const REF_UNKNOWN_LOGON_SESSION: ULONG = 0x00000047;
pub const CANCEL_STATE_IN_COMPLETED_IRP: ULONG = 0x00000048;
pub const PAGE_FAULT_WITH_INTERRUPTS_OFF: ULONG = 0x00000049;
pub const IRQL_GT_ZERO_AT_SYSTEM_SERVICE: ULONG = 0x0000004A;
pub const STREAMS_INTERNAL_ERROR: ULONG = 0x0000004B;
pub const FATAL_UNHANDLED_HARD_ERROR: ULONG = 0x0000004C;
pub const NO_PAGES_AVAILABLE: ULONG = 0x0000004D;
pub const PFN_LIST_CORRUPT: ULONG = 0x0000004E;
pub const NDIS_INTERNAL_ERROR: ULONG = 0x0000004F;
pub const PAGE_FAULT_IN_NONPAGED_AREA: ULONG = 0x00000050;
pub const PAGE_FAULT_IN_NONPAGED_AREA_M: ULONG = 0x10000050;
pub const REGISTRY_ERROR: ULONG = 0x00000051;
pub const MAILSLOT_FILE_SYSTEM: ULONG = 0x00000052;
pub const NO_BOOT_DEVICE: ULONG = 0x00000053;
pub const LM_SERVER_INTERNAL_ERROR: ULONG = 0x00000054;
pub const DATA_COHERENCY_EXCEPTION: ULONG = 0x00000055;
pub const INSTRUCTION_COHERENCY_EXCEPTION: ULONG = 0x00000056;
pub const XNS_INTERNAL_ERROR: ULONG = 0x00000057;
pub const VOLMGRX_INTERNAL_ERROR: ULONG = 0x00000058;
pub const PINBALL_FILE_SYSTEM: ULONG = 0x00000059;
pub const CRITICAL_SERVICE_FAILED: ULONG = 0x0000005A;
pub const SET_ENV_VAR_FAILED: ULONG = 0x0000005B;
pub const HAL_INITIALIZATION_FAILED: ULONG = 0x0000005C;
pub const UNSUPPORTED_PROCESSOR: ULONG = 0x0000005D;
pub const OBJECT_INITIALIZATION_FAILED: ULONG = 0x0000005E;
pub const SECURITY_INITIALIZATION_FAILED: ULONG = 0x0000005F;
pub const PROCESS_INITIALIZATION_FAILED: ULONG = 0x00000060;
pub const HAL1_INITIALIZATION_FAILED: ULONG = 0x00000061;
pub const OBJECT1_INITIALIZATION_FAILED: ULONG = 0x00000062;
pub const SECURITY1_INITIALIZATION_FAILED: ULONG = 0x00000063;
pub const SYMBOLIC_INITIALIZATION_FAILED: ULONG = 0x00000064;
pub const MEMORY1_INITIALIZATION_FAILED: ULONG = 0x00000065;
pub const CACHE_INITIALIZATION_FAILED: ULONG = 0x00000066;
pub const CONFIG_INITIALIZATION_FAILED: ULONG = 0x00000067;
pub const FILE_INITIALIZATION_FAILED: ULONG = 0x00000068;
pub const IO1_INITIALIZATION_FAILED: ULONG = 0x00000069;
pub const LPC_INITIALIZATION_FAILED: ULONG = 0x0000006A;
pub const PROCESS1_INITIALIZATION_FAILED: ULONG = 0x0000006B;
pub const REFMON_INITIALIZATION_FAILED: ULONG = 0x0000006C;
pub const SESSION1_INITIALIZATION_FAILED: ULONG = 0x0000006D;
pub const BOOTPROC_INITIALIZATION_FAILED: ULONG = 0x0000006E;
pub const VSL_INITIALIZATION_FAILED: ULONG = 0x0000006F;
pub const SOFT_RESTART_FATAL_ERROR: ULONG = 0x00000070;
pub const ASSIGN_DRIVE_LETTERS_FAILED: ULONG = 0x00000072;
pub const CONFIG_LIST_FAILED: ULONG = 0x00000073;
pub const BAD_SYSTEM_CONFIG_INFO: ULONG = 0x00000074;
pub const CANNOT_WRITE_CONFIGURATION: ULONG = 0x00000075;
pub const PROCESS_HAS_LOCKED_PAGES: ULONG = 0x00000076;
pub const KERNEL_STACK_INPAGE_ERROR: ULONG = 0x00000077;
pub const PHASE0_EXCEPTION: ULONG = 0x00000078;
pub const MISMATCHED_HAL: ULONG = 0x00000079;
pub const KERNEL_DATA_INPAGE_ERROR: ULONG = 0x0000007A;
pub const INACCESSIBLE_BOOT_DEVICE: ULONG = 0x0000007B;
pub const BUGCODE_NDIS_DRIVER: ULONG = 0x0000007C;
pub const INSTALL_MORE_MEMORY: ULONG = 0x0000007D;
pub const SYSTEM_THREAD_EXCEPTION_NOT_HANDLED: ULONG = 0x0000007E;
pub const SYSTEM_THREAD_EXCEPTION_NOT_HANDLED_M: ULONG = 0x1000007E;
pub const UNEXPECTED_KERNEL_MODE_TRAP: ULONG = 0x0000007F;
pub const UNEXPECTED_KERNEL_MODE_TRAP_M: ULONG = 0x1000007F;
pub const NMI_HARDWARE_FAILURE: ULONG = 0x00000080;
pub const SPIN_LOCK_INIT_FAILURE: ULONG = 0x00000081;
pub const DFS_FILE_SYSTEM: ULONG = 0x00000082;
pub const OFS_FILE_SYSTEM: ULONG = 0x00000083;
pub const RECOM_DRIVER: ULONG = 0x00000084;
pub const SETUP_FAILURE: ULONG = 0x00000085;
pub const AUDIT_FAILURE: ULONG = 0x00000086;
pub const MBR_CHECKSUM_MISMATCH: ULONG = 0x0000008B;
pub const KERNEL_MODE_EXCEPTION_NOT_HANDLED: ULONG = 0x0000008E;
pub const KERNEL_MODE_EXCEPTION_NOT_HANDLED_M: ULONG = 0x1000008E;
pub const PP0_INITIALIZATION_FAILED: ULONG = 0x0000008F;
pub const PP1_INITIALIZATION_FAILED: ULONG = 0x00000090;
pub const WIN32K_INIT_OR_RIT_FAILURE: ULONG = 0x00000091;
pub const UP_DRIVER_ON_MP_SYSTEM: ULONG = 0x00000092;
pub const INVALID_KERNEL_HANDLE: ULONG = 0x00000093;
pub const KERNEL_STACK_LOCKED_AT_EXIT: ULONG = 0x00000094;
pub const PNP_INTERNAL_ERROR: ULONG = 0x00000095;
pub const INVALID_WORK_QUEUE_ITEM: ULONG = 0x00000096;
pub const BOUND_IMAGE_UNSUPPORTED: ULONG = 0x00000097;
pub const END_OF_NT_EVALUATION_PERIOD: ULONG = 0x00000098;
pub const INVALID_REGION_OR_SEGMENT: ULONG = 0x00000099;
pub const SYSTEM_LICENSE_VIOLATION: ULONG = 0x0000009A;
pub const UDFS_FILE_SYSTEM: ULONG = 0x0000009B;
pub const MACHINE_CHECK_EXCEPTION: ULONG = 0x0000009C;
pub const USER_MODE_HEALTH_MONITOR: ULONG = 0x0000009E;
pub const DRIVER_POWER_STATE_FAILURE: ULONG = 0x0000009F;
pub const INTERNAL_POWER_ERROR: ULONG = 0x000000A0;
pub const PCI_BUS_DRIVER_INTERNAL: ULONG = 0x000000A1;
pub const MEMORY_IMAGE_CORRUPT: ULONG = 0x000000A2;
pub const ACPI_DRIVER_INTERNAL: ULONG = 0x000000A3;
pub const CNSS_FILE_SYSTEM_FILTER: ULONG = 0x000000A4;
pub const ACPI_BIOS_ERROR: ULONG = 0x000000A5;
pub const FP_EMULATION_ERROR: ULONG = 0x000000A6;
pub const BAD_EXHANDLE: ULONG = 0x000000A7;
pub const BOOTING_IN_SAFEMODE_MINIMAL: ULONG = 0x000000A8;
pub const BOOTING_IN_SAFEMODE_NETWORK: ULONG = 0x000000A9;
pub const BOOTING_IN_SAFEMODE_DSREPAIR: ULONG = 0x000000AA;
pub const SESSION_HAS_VALID_POOL_ON_EXIT: ULONG = 0x000000AB;
pub const HAL_MEMORY_ALLOCATION: ULONG = 0x000000AC;
pub const VIDEO_DRIVER_DEBUG_REPORT_REQUEST: ULONG = 0x400000AD;
pub const BGI_DETECTED_VIOLATION: ULONG = 0x000000B1;
pub const VIDEO_DRIVER_INIT_FAILURE: ULONG = 0x000000B4;
pub const BOOTLOG_LOADED: ULONG = 0x000000B5;
pub const BOOTLOG_NOT_LOADED: ULONG = 0x000000B6;
pub const BOOTLOG_ENABLED: ULONG = 0x000000B7;
pub const ATTEMPTED_SWITCH_FROM_DPC: ULONG = 0x000000B8;
pub const CHIPSET_DETECTED_ERROR: ULONG = 0x000000B9;
pub const SESSION_HAS_VALID_VIEWS_ON_EXIT: ULONG = 0x000000BA;
pub const NETWORK_BOOT_INITIALIZATION_FAILED: ULONG = 0x000000BB;
pub const NETWORK_BOOT_DUPLICATE_ADDRESS: ULONG = 0x000000BC;
pub const INVALID_HIBERNATED_STATE: ULONG = 0x000000BD;
pub const ATTEMPTED_WRITE_TO_READONLY_MEMORY: ULONG = 0x000000BE;
pub const MUTEX_ALREADY_OWNED: ULONG = 0x000000BF;
pub const PCI_CONFIG_SPACE_ACCESS_FAILURE: ULONG = 0x000000C0;
pub const SPECIAL_POOL_DETECTED_MEMORY_CORRUPTION: ULONG = 0x000000C1;
pub const BAD_POOL_CALLER: ULONG = 0x000000C2;
pub const SYSTEM_IMAGE_BAD_SIGNATURE: ULONG = 0x000000C3;
pub const DRIVER_VERIFIER_DETECTED_VIOLATION: ULONG = 0x000000C4;
pub const DRIVER_CORRUPTED_EXPOOL: ULONG = 0x000000C5;
pub const DRIVER_CAUGHT_MODIFYING_FREED_POOL: ULONG = 0x000000C6;
pub const TIMER_OR_DPC_INVALID: ULONG = 0x000000C7;
pub const IRQL_UNEXPECTED_VALUE: ULONG = 0x000000C8;
pub const DRIVER_VERIFIER_IOMANAGER_VIOLATION: ULONG = 0x000000C9;
pub const PNP_DETECTED_FATAL_ERROR: ULONG = 0x000000CA;
pub const DRIVER_LEFT_LOCKED_PAGES_IN_PROCESS: ULONG = 0x000000CB;
pub const PAGE_FAULT_IN_FREED_SPECIAL_POOL: ULONG = 0x000000CC;
pub const PAGE_FAULT_BEYOND_END_OF_ALLOCATION: ULONG = 0x000000CD;
pub const DRIVER_UNLOADED_WITHOUT_CANCELLING_PENDING_OPERATIONS: ULONG = 0x000000CE;
pub const TERMINAL_SERVER_DRIVER_MADE_INCORRECT_MEMORY_REFERENCE: ULONG = 0x000000CF;
pub const DRIVER_CORRUPTED_MMPOOL: ULONG = 0x000000D0;
pub const DRIVER_IRQL_NOT_LESS_OR_EQUAL: ULONG = 0x000000D1;
pub const BUGCODE_ID_DRIVER: ULONG = 0x000000D2;
pub const DRIVER_PORTION_MUST_BE_NONPAGED: ULONG = 0x000000D3;
pub const SYSTEM_SCAN_AT_RAISED_IRQL_CAUGHT_IMPROPER_DRIVER_UNLOAD: ULONG = 0x000000D4;
pub const DRIVER_PAGE_FAULT_IN_FREED_SPECIAL_POOL: ULONG = 0x000000D5;
pub const DRIVER_PAGE_FAULT_BEYOND_END_OF_ALLOCATION: ULONG = 0x000000D6;
pub const DRIVER_PAGE_FAULT_BEYOND_END_OF_ALLOCATION_M: ULONG = 0x100000D6;
pub const DRIVER_UNMAPPING_INVALID_VIEW: ULONG = 0x000000D7;
pub const DRIVER_USED_EXCESSIVE_PTES: ULONG = 0x000000D8;
pub const LOCKED_PAGES_TRACKER_CORRUPTION: ULONG = 0x000000D9;
pub const SYSTEM_PTE_MISUSE: ULONG = 0x000000DA;
pub const DRIVER_CORRUPTED_SYSPTES: ULONG = 0x000000DB;
pub const DRIVER_INVALID_STACK_ACCESS: ULONG = 0x000000DC;
pub const POOL_CORRUPTION_IN_FILE_AREA: ULONG = 0x000000DE;
pub const IMPERSONATING_WORKER_THREAD: ULONG = 0x000000DF;
pub const ACPI_BIOS_FATAL_ERROR: ULONG = 0x000000E0;
pub const WORKER_THREAD_RETURNED_AT_BAD_IRQL: ULONG = 0x000000E1;
pub const MANUALLY_INITIATED_CRASH: ULONG = 0x000000E2;
pub const RESOURCE_NOT_OWNED: ULONG = 0x000000E3;
pub const WORKER_INVALID: ULONG = 0x000000E4;
pub const POWER_FAILURE_SIMULATE: ULONG = 0x000000E5;
pub const DRIVER_VERIFIER_DMA_VIOLATION: ULONG = 0x000000E6;
pub const INVALID_FLOATING_POINT_STATE: ULONG = 0x000000E7;
pub const INVALID_CANCEL_OF_FILE_OPEN: ULONG = 0x000000E8;
pub const ACTIVE_EX_WORKER_THREAD_TERMINATION: ULONG = 0x000000E9;
pub const SAVER_UNSPECIFIED: ULONG = 0x0000F000;
pub const SAVER_BLANKSCREEN: ULONG = 0x0000F002;
pub const SAVER_INPUT: ULONG = 0x0000F003;
pub const SAVER_WATCHDOG: ULONG = 0x0000F004;
pub const SAVER_STARTNOTVISIBLE: ULONG = 0x0000F005;
pub const SAVER_NAVIGATIONMODEL: ULONG = 0x0000F006;
pub const SAVER_OUTOFMEMORY: ULONG = 0x0000F007;
pub const SAVER_GRAPHICS: ULONG = 0x0000F008;
pub const SAVER_NAVSERVERTIMEOUT: ULONG = 0x0000F009;
pub const SAVER_CHROMEPROCESSCRASH: ULONG = 0x0000F00A;
pub const SAVER_NOTIFICATIONDISMISSAL: ULONG = 0x0000F00B;
pub const SAVER_SPEECHDISMISSAL: ULONG = 0x0000F00C;
pub const SAVER_CALLDISMISSAL: ULONG = 0x0000F00D;
pub const SAVER_APPBARDISMISSAL: ULONG = 0x0000F00E;
pub const SAVER_RILADAPTATIONCRASH: ULONG = 0x0000F00F;
pub const SAVER_APPLISTUNREACHABLE: ULONG = 0x0000F010;
pub const SAVER_REPORTNOTIFICATIONFAILURE: ULONG = 0x0000F011;
pub const SAVER_UNEXPECTEDSHUTDOWN: ULONG = 0x0000F012;
pub const SAVER_RPCFAILURE: ULONG = 0x0000F013;
pub const SAVER_AUXILIARYFULLDUMP: ULONG = 0x0000F014;
pub const SAVER_ACCOUNTPROVSVCINITFAILURE: ULONG = 0x0000F015;
pub const SAVER_MTBFCOMMANDTIMEOUT: ULONG = 0x00000315;
pub const SAVER_MTBFCOMMANDHANG: ULONG = 0x0000F101;
pub const SAVER_MTBFPASSBUGCHECK: ULONG = 0x0000F102;
pub const SAVER_MTBFIOERROR: ULONG = 0x0000F103;
pub const SAVER_RENDERTHREADHANG: ULONG = 0x0000F200;
pub const SAVER_RENDERMOBILEUIOOM: ULONG = 0x0000F201;
pub const SAVER_DEVICEUPDATEUNSPECIFIED: ULONG = 0x0000F300;
pub const SAVER_AUDIODRIVERHANG: ULONG = 0x0000F400;
pub const SAVER_BATTERYPULLOUT: ULONG = 0x0000F500;
pub const SAVER_MEDIACORETESTHANG: ULONG = 0x0000F600;
pub const SAVER_RESOURCEMANAGEMENT: ULONG = 0x0000F700;
pub const SAVER_CAPTURESERVICE: ULONG = 0x0000F800;
pub const SAVER_WAITFORSHELLREADY: ULONG = 0x0000F900;
pub const SAVER_NONRESPONSIVEPROCESS: ULONG = 0x00000194;
pub const SAVER_SICKAPPLICATION: ULONG = 0x00008866;
pub const THREAD_STUCK_IN_DEVICE_DRIVER: ULONG = 0x000000EA;
pub const THREAD_STUCK_IN_DEVICE_DRIVER_M: ULONG = 0x100000EA;
pub const DIRTY_MAPPED_PAGES_CONGESTION: ULONG = 0x000000EB;
pub const SESSION_HAS_VALID_SPECIAL_POOL_ON_EXIT: ULONG = 0x000000EC;
pub const UNMOUNTABLE_BOOT_VOLUME: ULONG = 0x000000ED;
pub const CRITICAL_PROCESS_DIED: ULONG = 0x000000EF;
pub const STORAGE_MINIPORT_ERROR: ULONG = 0x000000F0;
pub const SCSI_VERIFIER_DETECTED_VIOLATION: ULONG = 0x000000F1;
pub const HARDWARE_INTERRUPT_STORM: ULONG = 0x000000F2;
pub const DISORDERLY_SHUTDOWN: ULONG = 0x000000F3;
pub const CRITICAL_OBJECT_TERMINATION: ULONG = 0x000000F4;
pub const FLTMGR_FILE_SYSTEM: ULONG = 0x000000F5;
pub const PCI_VERIFIER_DETECTED_VIOLATION: ULONG = 0x000000F6;
pub const DRIVER_OVERRAN_STACK_BUFFER: ULONG = 0x000000F7;
pub const RAMDISK_BOOT_INITIALIZATION_FAILED: ULONG = 0x000000F8;
pub const DRIVER_RETURNED_STATUS_REPARSE_FOR_VOLUME_OPEN: ULONG = 0x000000F9;
pub const HTTP_DRIVER_CORRUPTED: ULONG = 0x000000FA;
pub const RECURSIVE_MACHINE_CHECK: ULONG = 0x000000FB;
pub const ATTEMPTED_EXECUTE_OF_NOEXECUTE_MEMORY: ULONG = 0x000000FC;
pub const DIRTY_NOWRITE_PAGES_CONGESTION: ULONG = 0x000000FD;
pub const BUGCODE_USB_DRIVER: ULONG = 0x000000FE;
pub const BC_BLUETOOTH_VERIFIER_FAULT: ULONG = 0x00000BFE;
pub const BC_BTHMINI_VERIFIER_FAULT: ULONG = 0x00000BFF;
pub const RESERVE_QUEUE_OVERFLOW: ULONG = 0x000000FF;
pub const LOADER_BLOCK_MISMATCH: ULONG = 0x00000100;
pub const CLOCK_WATCHDOG_TIMEOUT: ULONG = 0x00000101;
pub const DPC_WATCHDOG_TIMEOUT: ULONG = 0x00000102;
pub const MUP_FILE_SYSTEM: ULONG = 0x00000103;
pub const AGP_INVALID_ACCESS: ULONG = 0x00000104;
pub const AGP_GART_CORRUPTION: ULONG = 0x00000105;
pub const AGP_ILLEGALLY_REPROGRAMMED: ULONG = 0x00000106;
pub const KERNEL_EXPAND_STACK_ACTIVE: ULONG = 0x00000107;
pub const THIRD_PARTY_FILE_SYSTEM_FAILURE: ULONG = 0x00000108;
pub const CRITICAL_STRUCTURE_CORRUPTION: ULONG = 0x00000109;
pub const APP_TAGGING_INITIALIZATION_FAILED: ULONG = 0x0000010A;
pub const DFSC_FILE_SYSTEM: ULONG = 0x0000010B;
pub const FSRTL_EXTRA_CREATE_PARAMETER_VIOLATION: ULONG = 0x0000010C;
pub const WDF_VIOLATION: ULONG = 0x0000010D;
pub const VIDEO_MEMORY_MANAGEMENT_INTERNAL: ULONG = 0x0000010E;
pub const DRIVER_INVALID_CRUNTIME_PARAMETER: ULONG = 0x00000110;
pub const RECURSIVE_NMI: ULONG = 0x00000111;
pub const MSRPC_STATE_VIOLATION: ULONG = 0x00000112;
pub const VIDEO_DXGKRNL_FATAL_ERROR: ULONG = 0x00000113;
pub const VIDEO_SHADOW_DRIVER_FATAL_ERROR: ULONG = 0x00000114;
pub const AGP_INTERNAL: ULONG = 0x00000115;
pub const VIDEO_TDR_FAILURE: ULONG = 0x00000116;
pub const VIDEO_TDR_TIMEOUT_DETECTED: ULONG = 0x00000117;
pub const NTHV_GUEST_ERROR: ULONG = 0x00000118;
pub const VIDEO_SCHEDULER_INTERNAL_ERROR: ULONG = 0x00000119;
pub const EM_INITIALIZATION_ERROR: ULONG = 0x0000011A;
pub const DRIVER_RETURNED_HOLDING_CANCEL_LOCK: ULONG = 0x0000011B;
pub const ATTEMPTED_WRITE_TO_CM_PROTECTED_STORAGE: ULONG = 0x0000011C;
pub const EVENT_TRACING_FATAL_ERROR: ULONG = 0x0000011D;
pub const TOO_MANY_RECURSIVE_FAULTS: ULONG = 0x0000011E;
pub const INVALID_DRIVER_HANDLE: ULONG = 0x0000011F;
pub const BITLOCKER_FATAL_ERROR: ULONG = 0x00000120;
pub const DRIVER_VIOLATION: ULONG = 0x00000121;
pub const WHEA_INTERNAL_ERROR: ULONG = 0x00000122;
pub const CRYPTO_SELF_TEST_FAILURE: ULONG = 0x00000123;
pub const WHEA_UNCORRECTABLE_ERROR: ULONG = 0x00000124;
pub const NMR_INVALID_STATE: ULONG = 0x00000125;
pub const NETIO_INVALID_POOL_CALLER: ULONG = 0x00000126;
pub const PAGE_NOT_ZERO: ULONG = 0x00000127;
pub const WORKER_THREAD_RETURNED_WITH_BAD_IO_PRIORITY: ULONG = 0x00000128;
pub const WORKER_THREAD_RETURNED_WITH_BAD_PAGING_IO_PRIORITY: ULONG = 0x00000129;
pub const MUI_NO_VALID_SYSTEM_LANGUAGE: ULONG = 0x0000012A;
pub const FAULTY_HARDWARE_CORRUPTED_PAGE: ULONG = 0x0000012B;
pub const EXFAT_FILE_SYSTEM: ULONG = 0x0000012C;
pub const VOLSNAP_OVERLAPPED_TABLE_ACCESS: ULONG = 0x0000012D;
pub const INVALID_MDL_RANGE: ULONG = 0x0000012E;
pub const VHD_BOOT_INITIALIZATION_FAILED: ULONG = 0x0000012F;
pub const DYNAMIC_ADD_PROCESSOR_MISMATCH: ULONG = 0x00000130;
pub const INVALID_EXTENDED_PROCESSOR_STATE: ULONG = 0x00000131;
pub const RESOURCE_OWNER_POINTER_INVALID: ULONG = 0x00000132;
pub const DPC_WATCHDOG_VIOLATION: ULONG = 0x00000133;
pub const DRIVE_EXTENDER: ULONG = 0x00000134;
pub const REGISTRY_FILTER_DRIVER_EXCEPTION: ULONG = 0x00000135;
pub const VHD_BOOT_HOST_VOLUME_NOT_ENOUGH_SPACE: ULONG = 0x00000136;
pub const WIN32K_HANDLE_MANAGER: ULONG = 0x00000137;
pub const GPIO_CONTROLLER_DRIVER_ERROR: ULONG = 0x00000138;
pub const KERNEL_SECURITY_CHECK_FAILURE: ULONG = 0x00000139;
pub const KERNEL_MODE_HEAP_CORRUPTION: ULONG = 0x0000013A;
pub const PASSIVE_INTERRUPT_ERROR: ULONG = 0x0000013B;
pub const INVALID_IO_BOOST_STATE: ULONG = 0x0000013C;
pub const CRITICAL_INITIALIZATION_FAILURE: ULONG = 0x0000013D;
pub const ERRATA_WORKAROUND_UNSUCCESSFUL: ULONG = 0x0000013E;
pub const STORAGE_DEVICE_ABNORMALITY_DETECTED: ULONG = 0x00000140;
pub const VIDEO_ENGINE_TIMEOUT_DETECTED: ULONG = 0x00000141;
pub const VIDEO_TDR_APPLICATION_BLOCKED: ULONG = 0x00000142;
pub const PROCESSOR_DRIVER_INTERNAL: ULONG = 0x00000143;
pub const BUGCODE_USB3_DRIVER: ULONG = 0x00000144;
pub const SECURE_BOOT_VIOLATION: ULONG = 0x00000145;
pub const NDIS_NET_BUFFER_LIST_INFO_ILLEGALLY_TRANSFERRED: ULONG = 0x00000146;
pub const ABNORMAL_RESET_DETECTED: ULONG = 0x00000147;
pub const IO_OBJECT_INVALID: ULONG = 0x00000148;
pub const REFS_FILE_SYSTEM: ULONG = 0x00000149;
pub const KERNEL_WMI_INTERNAL: ULONG = 0x0000014A;
pub const SOC_SUBSYSTEM_FAILURE: ULONG = 0x0000014B;
pub const FATAL_ABNORMAL_RESET_ERROR: ULONG = 0x0000014C;
pub const EXCEPTION_SCOPE_INVALID: ULONG = 0x0000014D;
pub const SOC_CRITICAL_DEVICE_REMOVED: ULONG = 0x0000014E;
pub const PDC_WATCHDOG_TIMEOUT: ULONG = 0x0000014F;
pub const TCPIP_AOAC_NIC_ACTIVE_REFERENCE_LEAK: ULONG = 0x00000150;
pub const UNSUPPORTED_INSTRUCTION_MODE: ULONG = 0x00000151;
pub const INVALID_PUSH_LOCK_FLAGS: ULONG = 0x00000152;
pub const KERNEL_LOCK_ENTRY_LEAKED_ON_THREAD_TERMINATION: ULONG = 0x00000153;
pub const UNEXPECTED_STORE_EXCEPTION: ULONG = 0x00000154;
pub const OS_DATA_TAMPERING: ULONG = 0x00000155;
pub const WINSOCK_DETECTED_HUNG_CLOSESOCKET_LIVEDUMP: ULONG = 0x00000156;
pub const KERNEL_THREAD_PRIORITY_FLOOR_VIOLATION: ULONG = 0x00000157;
pub const ILLEGAL_IOMMU_PAGE_FAULT: ULONG = 0x00000158;
pub const HAL_ILLEGAL_IOMMU_PAGE_FAULT: ULONG = 0x00000159;
pub const SDBUS_INTERNAL_ERROR: ULONG = 0x0000015A;
pub const WORKER_THREAD_RETURNED_WITH_SYSTEM_PAGE_PRIORITY_ACTIVE: ULONG = 0x0000015B;
pub const PDC_WATCHDOG_TIMEOUT_LIVEDUMP: ULONG = 0x0000015C;
pub const SOC_SUBSYSTEM_FAILURE_LIVEDUMP: ULONG = 0x0000015D;
pub const BUGCODE_NDIS_DRIVER_LIVE_DUMP: ULONG = 0x0000015E;
pub const CONNECTED_STANDBY_WATCHDOG_TIMEOUT_LIVEDUMP: ULONG = 0x0000015F;
pub const WIN32K_ATOMIC_CHECK_FAILURE: ULONG = 0x00000160;
pub const LIVE_SYSTEM_DUMP: ULONG = 0x00000161;
pub const KERNEL_AUTO_BOOST_INVALID_LOCK_RELEASE: ULONG = 0x00000162;
pub const WORKER_THREAD_TEST_CONDITION: ULONG = 0x00000163;
pub const WIN32K_CRITICAL_FAILURE: ULONG = 0x00000164;
pub const CLUSTER_CSV_STATUS_IO_TIMEOUT_LIVEDUMP: ULONG = 0x00000165;
pub const CLUSTER_RESOURCE_CALL_TIMEOUT_LIVEDUMP: ULONG = 0x00000166;
pub const CLUSTER_CSV_SNAPSHOT_DEVICE_INFO_TIMEOUT_LIVEDUMP: ULONG = 0x00000167;
pub const CLUSTER_CSV_STATE_TRANSITION_TIMEOUT_LIVEDUMP: ULONG = 0x00000168;
pub const CLUSTER_CSV_VOLUME_ARRIVAL_LIVEDUMP: ULONG = 0x00000169;
pub const CLUSTER_CSV_VOLUME_REMOVAL_LIVEDUMP: ULONG = 0x0000016A;
pub const CLUSTER_CSV_CLUSTER_WATCHDOG_LIVEDUMP: ULONG = 0x0000016B;
pub const INVALID_RUNDOWN_PROTECTION_FLAGS: ULONG = 0x0000016C;
pub const INVALID_SLOT_ALLOCATOR_FLAGS: ULONG = 0x0000016D;
pub const ERESOURCE_INVALID_RELEASE: ULONG = 0x0000016E;
pub const CLUSTER_CSV_STATE_TRANSITION_INTERVAL_TIMEOUT_LIVEDUMP: ULONG = 0x0000016F;
pub const CLUSTER_CSV_CLUSSVC_DISCONNECT_WATCHDOG: ULONG = 0x00000170;
pub const CRYPTO_LIBRARY_INTERNAL_ERROR: ULONG = 0x00000171;
pub const COREMSGCALL_INTERNAL_ERROR: ULONG = 0x00000173;
pub const COREMSG_INTERNAL_ERROR: ULONG = 0x00000174;
pub const PREVIOUS_FATAL_ABNORMAL_RESET_ERROR: ULONG = 0x00000175;
pub const ELAM_DRIVER_DETECTED_FATAL_ERROR: ULONG = 0x00000178;
pub const PDC_LOCK_WATCHDOG_LIVEDUMP: ULONG = 0x0000017C;
pub const PDC_UNEXPECTED_REVOCATION_LIVEDUMP: ULONG = 0x0000017D;
pub const WVR_LIVEDUMP_REPLICATION_IOCONTEXT_TIMEOUT: ULONG = 0x00000180;
pub const WVR_LIVEDUMP_STATE_TRANSITION_TIMEOUT: ULONG = 0x00000181;
pub const WVR_LIVEDUMP_RECOVERY_IOCONTEXT_TIMEOUT: ULONG = 0x00000182;
pub const WVR_LIVEDUMP_APP_IO_TIMEOUT: ULONG = 0x00000183;
pub const WVR_LIVEDUMP_MANUALLY_INITIATED: ULONG = 0x00000184;
pub const WVR_LIVEDUMP_STATE_FAILURE: ULONG = 0x00000185;
pub const WVR_LIVEDUMP_CRITICAL_ERROR: ULONG = 0x00000186;
pub const VIDEO_DWMINIT_TIMEOUT_FALLBACK_BDD: ULONG = 0x00000187;
pub const CLUSTER_CSVFS_LIVEDUMP: ULONG = 0x00000188;
pub const BAD_OBJECT_HEADER: ULONG = 0x00000189;
pub const SILO_CORRUPT: ULONG = 0x0000018A;
pub const SECURE_KERNEL_ERROR: ULONG = 0x0000018B;
pub const HYPERGUARD_VIOLATION: ULONG = 0x0000018C;
pub const WIN32K_CRITICAL_FAILURE_LIVEDUMP: ULONG = 0x00000190;
pub const PF_DETECTED_CORRUPTION: ULONG = 0x00000191;
pub const KERNEL_AUTO_BOOST_LOCK_ACQUISITION_WITH_RAISED_IRQL: ULONG = 0x00000192;
pub const VIDEO_DXGKRNL_LIVEDUMP: ULONG = 0x00000193;
pub const KERNEL_STORAGE_SLOT_IN_USE: ULONG = 0x00000199;
pub const SMB_SERVER_LIVEDUMP: ULONG = 0x00000195;
pub const LOADER_ROLLBACK_DETECTED: ULONG = 0x00000196;
pub const WIN32K_SECURITY_FAILURE: ULONG = 0x00000197;
pub const UFX_LIVEDUMP: ULONG = 0x00000198;
pub const WORKER_THREAD_RETURNED_WHILE_ATTACHED_TO_SILO: ULONG = 0x0000019A;
pub const TTM_FATAL_ERROR: ULONG = 0x0000019B;
pub const WIN32K_POWER_WATCHDOG_TIMEOUT: ULONG = 0x0000019C;
pub const CLUSTER_SVHDX_LIVEDUMP: ULONG = 0x0000019D;
pub const DRIVER_VERIFIER_DETECTED_VIOLATION_LIVEDUMP: ULONG = 0x000001C4;
pub const IO_THREADPOOL_DEADLOCK_LIVEDUMP: ULONG = 0x000001C5;
pub const XBOX_CORRUPTED_IMAGE: ULONG = 0x00000357;
pub const XBOX_INVERTED_FUNCTION_TABLE_OVERFLOW: ULONG = 0x00000358;
pub const XBOX_CORRUPTED_IMAGE_BASE: ULONG = 0x00000359;
pub const XBOX_360_SYSTEM_CRASH: ULONG = 0x00000360;
pub const XBOX_360_SYSTEM_CRASH_RESERVED: ULONG = 0x00000420;
pub const HYPERVISOR_ERROR: ULONG = 0x00020001;
pub const WINLOGON_FATAL_ERROR: ULONG = 0xC000021A;
pub const MANUALLY_INITIATED_CRASH1: ULONG = 0xDEADDEAD;
pub const BUGCHECK_CONTEXT_MODIFIER: ULONG = 0x80000000;
