!{\src2tex{textfont=tt}}
!!****f* ABINIT/initpawps2
!! NAME
!! initpawps2
!! 
!! FUNCTION
!! Initialize several quantities concerning the radial mesh and
!! pseudopotential type
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS
!!  pawdata
!!    %big_meshsz= Max. dimension of radial mesh
!!  pawopt
!!   %ishapenum=Option governing the writing of shape functions
!!   %rcompfact=Radius for compensation charge (-1 if rcomp=rcut)
!!  pshead
!!    %log_step= Logarithmic step corresponding to radial mesh
!!    %pspxc_vdb= Vdb s code number for the exchange-correlation
!!    %rad_step= Radial step corresponding to radial mesh
!!    %rc_sph= Default PAW sphere radius
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!  usdata
!!    %exfact= USpp s code number for the exchange-correlation
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawdata
!!    %factzero= Factor to compute value of functions at r=0
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %core_meshsz= Dimension of radial mesh for core and tcore densities
!!    %creatorid= ID of psp generator (here pspfmt=1 !)
!!    %lambda= Lambda in gaussian type g(r) (not used here)
!!    %mesh_type=  Flag defining ther radial grid type
!!    %pspcod= Psp code number for Abinit (here PAW->pspcod=7 !)
!!    %pspxc_abinit= Abinit s code number for the exchange-correlation
!!    %rcomp=Radius for compensation charge
!!    %shape_type= Shape function type (necessarily 2 here)
!!    %sigma= Sigma for gaussian type g(r) (not used here)
!!    %vloc_meshsz= Dimension of radial mesh for vloc=vhtnzc
!!
!! PARENTS
!!      uspp2abinit
!!
!! SOURCE

 subroutine initpawps2(pawdata,pawopt,pshead,usdata,un_log)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 integer :: un_log
!These types are defined in defs_pawps
 type(pawdata_type) :: pawdata
 type(pawopt_type) :: pawopt
 type(pshead_type) :: pshead
 type(usdata_type) :: usdata

!Local variables ---------------------------------------
 integer :: ir
 real(dp) :: rctest,rmax_vloc

!--------------------------------------------------------

!Format codes for Abinit pseudopotential
 pshead%creatorid=2
 pshead%pspcod=7
 if (usdata%exfact==0.) then
  pshead%pspxc_abinit=2   ! LDA with CA functional
 elseif (usdata%exfact==-1.) then
  pshead%pspxc_abinit=4   ! LDA with Wigner functional
 elseif (usdata%exfact==-2.) then
  pshead%pspxc_abinit=5   ! LDA with Hedin-Lundquist functional
 elseif (usdata%exfact==5.) then
  pshead%pspxc_abinit=11  ! GGA with PBE functional
 else
  write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (initpawps2):'
  write(un_log,'(a)')   '    Incorrect value of ex-correlation code'
  write(un_log,'(a)')   '    (not supported by Abinit) !'
  stop 'Program stopped before end'
 endif

!Grid type (here, regular grid)
 pshead%mesh_type=2

!Mesh radii
 rctest=pshead%rad_step*(exp(pshead%log_step*dble(pshead%sph_meshsz-1))-1.d0)
 if (abs(rctest-pshead%rc_sph)>tol6) then
  write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (initpawps2):'
  write(un_log,'(a)')   '    Inconsistency between sphere radius'
  write(un_log,'(a)')   '    and mesh size !'
  write(un_log,'(2(a,f10.6))')'  r(meshsz)=',rctest,', rc=',pshead%rc_sph
  stop 'Program stopped before end'
 endif
 pshead%rc_sph=rctest

!Size of mesh for Vloc:
!We decide to cut at r=10u.a because of numeric noise...
 rmax_vloc=10.d0
 pshead%vloc_meshsz=max(pshead%sph_meshsz,min(pshead%rho_meshsz, &
&                       int(log(1.d0+rmax_vloc/pshead%rad_step)/pshead%log_step)+1))

!Size of mesh for core and tcore densities:
 pshead%core_meshsz=pshead%rho_meshsz

!Initialization of the radial mesh (rad)
 do ir=1,pawdata%big_meshsz
  pawdata%rad(ir)=pshead%rad_step*(exp(pshead%log_step*dble(ir-1))-1.d0)
  pawdata%rad_(ir)=pawdata%rad(ir)+pshead%rad_step
 enddo
 pawdata%factzero=exp(-pshead%log_step)

!Shape function type
 pshead%shape_type=2;if (pawopt%ishapenum==1) pshead%shape_type=-1
 pshead%rcomp=pshead%rc_sph
 pshead%lambda=0
 pshead%sigma=0.d0
 if (pawopt%rcompfact>=0.d0.and.pawopt%rcompfact<=1.d0) pshead%rcomp=pawopt%rcompfact*pshead%rc_sph

 end subroutine
!!***
