!{\src2tex{textfont=tt}}
!!****f* ABINIT/cmevxclda
!! NAME
!! cmevxclda
!!
!! FUNCTION
!! Calculate matrix elements < nks | Vxc | n'ks > for the input wavefunctions.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!  ixc = choice for the exchange-correlation potential.
!!  mpi_enreg = informations about MPI parallelization.
!!  nbnds = number of bands.
!!  ngfft1,ngfft2,ngfft3 = size of the FFT grid.
!!  nkibz = number of k-points in the irreducible Brillouin zone.
!!  nr = total number of points on the FFT grid.
!!  nrb = effective number of points on the FFT grid.
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  rho(nr,nsppol) = the charge density on the FFT grid.
!!   (total in first half and spin-up in second half if nsppol=2)
!!  rprimd(3,3) = dimensional real space primitive translations (bohr).
!!  wfr(nr,nbnds,nkibz,nsppol) = wavefunctions on the FFT grid for nbnds bands at nkibz irreducible k-points and spin
!!
!! OUTPUT
!!  vxcme(nbnds,nbnds,nkibz,nsppol) = < nks | Vxc | n'ks > at nkibz irreducible k-points, for each spin
!!
!! TODO
!!  The < nks | Vxc | n'ks > could be computed during the KSS run and stored in the KSS file.
!!  They would then be calculated on the full FFT grid rather than on the usually coarse GW FFT grid.
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      cvxclda
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cmevxclda(dtset,ixc,mpi_enreg,nbnds,ngfft1,ngfft2,ngfft3,nkibz,nr,nrb,nsppol,&
& rho,rprimd,wfr,vxcme,min_band_proc,max_band_proc,parallelism_is_on_bands)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => cmevxclda
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ixc,max_band_proc,min_band_proc,nbnds,ngfft1,ngfft2
 integer,intent(in) :: ngfft3,nkibz,nr,nrb,nsppol
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
!arrays
 real(dp),intent(in) :: rho(nr,nsppol),rprimd(3,3)
 complex,intent(in) :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
 complex,intent(out) :: vxcme(nbnds,nbnds,nkibz,nsppol)

!Local variables ------------------------------
!scalars
 integer :: ib,ik,ir,is,jb
 real(dp) :: wr
 complex :: ct
 logical,parameter :: verbose=.false.
 character(len=500) :: message
!arrays
 real(dp),allocatable :: vxclda(:,:)
 integer::me,spaceComm,master,ierr
!*************************************************************************
 call xcomm_init(mpi_enreg,spaceComm) !Init mpi_comm
 call xme_init(mpi_enreg,me)          !Init me
 call xmaster_init(mpi_enreg,master)  !Init master

 write(message,'(a)') ' cmevxclda : enter '
 call wrtout(06,message,'COLL')

 vxcme(:,:,:,:)=zero

!calculate Vxc in real space
!MG Now cvxclda works in case of nsppol==2
!   FIXME anyway I have to introduce the non linear core correction
!   in the calculation of v_xc
 allocate(vxclda(nr,nsppol))
 call cvxclda(dtset,ixc,mpi_enreg,ngfft1,ngfft2,ngfft3,nr,nsppol,rho,rprimd,vxclda)

!calculate < nks | Vxc | n'ks >
!MG060923 added external loop on spin 
 wr=1.0/nrb

 do ik=1,nkibz
  do ib=1,nbnds
    if(parallelism_is_on_bands)then
    if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
    end if
   do jb=1,nbnds
    if(parallelism_is_on_bands)then
    if(minval(abs(mpi_enreg%proc_distrb(jb,:,:)-mpi_enreg%me))/=0) cycle
    end if
    do is=1,nsppol
     ct=0.0
     do ir=1,nr
      ct=ct+conjg(wfr(ir,ib,ik,is))*vxclda(ir,is)*wfr(ir,jb,ik,is)
     end do
     vxcme(ib,jb,ik,is)=ct*wr
    end do
   end do
  end do
 end do

 if(parallelism_is_on_bands)then
   call xsum_mpi(vxcme,spaceComm,ierr)
  end if

 
 if (verbose) then
 write(*,*)' DEBUG from cmevxclda'
  do ik=1,nkibz
   do is=1,nsppol
    write(std_out,'(a,i3,/,a)') ' < nks | Vxc | nks > for k-point ',ik,'  s  n         <Vxc> (eV)'
    do ib=1,nbnds
     write(std_out,'(2i3,2(e14.6,2x))') is,ib,vxcme(ib,ib,ik,is)*Ha_eV
    end do
   end do
  end do 
 end if

 write(std_out,*)

 deallocate(vxclda)

 write(message,'(a)') ' cmevxclda : exit '
 call wrtout(06,message,'COLL')

 end subroutine cmevxclda
!!***
