!{\src2tex{textfont=tt}}
!!****f* ABINIT/cvc
!! NAME
!! cvc
!!
!! FUNCTION
!! Set up table of length of |q+G| for coulombian potential
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  gvec(3,npwvec)=coordinates of G vectors
!!  iq=specific q point in BZ
!!  npwvec=number of planewaves
!!  nq=number of q points in BZ
!!  q=coordinates of q points in BZ
!!
!! OUTPUT
!!  qplusg(npwvec)=norm of q+G vector
!!
!! PARENTS
!!      cppm4par,screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => cvc
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iq,npwvec,nq
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),q(3,nq)
 real(dp),intent(out) :: qplusg(npwvec)

!Local variables ------------------------------
!scalars
 integer :: ig
!arrays
 real(dp) :: gpq(3)

! *************************************************************************

! write(*,*) 'calculating coulombian potential'
! write(*,*)
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vlngth
#endif
!End of the abilint section

 if(all(abs(q(:,iq))<1.e-3)) then
   qplusg(1)=vlngth(q(1,iq),b1,b2,b3)
   do ig=2,npwvec
     gpq(1)=gvec(1,ig)
     gpq(2)=gvec(2,ig)
     gpq(3)=gvec(3,ig)
     qplusg(ig)=vlngth(gpq,b1,b2,b3)
   end do
 else
   do ig=1,npwvec
     gpq(1)=gvec(1,ig)+q(1,iq)
     gpq(2)=gvec(2,ig)+q(2,iq)
     gpq(3)=gvec(3,ig)+q(3,iq)
     qplusg(ig)=vlngth(gpq,b1,b2,b3)
   end do
 end if

!write (6,'(a,i5,a,/,5(i5,':',f10.6))')&
!& ' |G+q| for q-point ',iq,' (au):',(ig,qplusg(ig),ig=1,npwvec)
end subroutine cvc
!!***
