!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdscr
!! NAME
!! rdscr
!!
!! FUNCTION
!! Read screening (epsilon-twiddle**-1) file in the scr format
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, XG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtfil=filenames (only dtfil%filsrc is used)
!!  npwvec=number of planewaves
!!  nomega=number of frequencies
!!  nq=number of q points
!!
!! OUTPUT
!!  q(3,nq)=coordinates of q points
!!  epsm1(npwvec,npwvec,nomega,nq)=epsilon tilde minus 1 matrix, for each frequency and q point
!!  omega(nomega)=frequencies
!!
!! NOTES
!!  If the epsilon matrix read is bigger than NPWVEC x NPWVEC,
!!  it will be truncated; if it is smaller, an error will occur
!!
!! PARENTS
!!      mrgscr,sigma
!!
!! CHILDREN
!!      hdr_clean,hdr_io,hdr_io_netcdf,leave_new,memerr,pclock,wrtout,xcast_mpi
!!      xcomm_init,xmaster_init,xme_init
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdscr(dtfil,npwvec,nq,nomega,q,omega,epsm1,mpi_enreg,nonlocal)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_15gw, except_this_one => rdscr
 use interfaces_lib01hidempi
#else
 use defs_interfaces
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none
#if defined MPI || defined MPI_FFT
    include 'mpif.h'
#endif
    
!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwvec,nq
 type(datafiles_type),intent(in) :: dtfil
 type(MPI_type),intent(in) :: mpi_enreg
  
!arrays
 real(dp),intent(out) :: q(3,nq)
 complex,intent(out) :: epsm1(npwvec,npwvec,nomega,nq),omega(nomega)
 logical,intent(in)::nonlocal
  
!Local variables-------------------------------
!scalars
 integer,parameter :: unitem1=24
 integer :: fform,headform,ii,io,ios,iq,istat,nbndse,nomegae,npwvece,npwwfne,nqe,rdwr
 integer :: readnetcdf
 real(dp) :: dielconst
 type(hdr_type) :: hdr
!arrays
 real(dp) :: qd(3,nq)
 character(len=80) :: titem1(2)
 character(len=500) :: message
 complex(dpc),allocatable :: epsm1d(:,:),omegad(:)
 integer::spaceComm,me,master,ierr
 logical::i_can_read,master_must_cast_data
! *************************************************************************
!start clock
 call pclock(0)
!Init mpi_comm
  call xcomm_init(mpi_enreg,spaceComm)
!Init me
  call xme_init(mpi_enreg,me)
!Init master
  call xmaster_init(mpi_enreg,master)
    
 allocate(omegad(nomega))
 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then
  i_can_read=.true.
 else
  i_can_read=.false.
 end if
 if(mpi_enreg%nproc>1.and.nonlocal)then 
  master_must_cast_data=.true.
  else
  master_must_cast_data=.false.
 end if                              ! only master ==> seq job
   
 if(i_can_read)then

  write(message,'(2a)')&
&  ' rdscr: reading screening (epsilon-twiddle^-1) file in the SCR format from:',trim(dtfil%filscr)
  call wrtout(6,message,'COLL')

  open(unit=unitem1,file=dtfil%filscr,status='unknown',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(message,'(4a)')&
&   ' rdscr : ERROR -',ch10,&
&   ' opening file ',trim(dtfil%filscr)
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if  

! Read the header of the file
  rdwr=1
  readnetcdf = 0 ! should become input parameter and make EM1 a netcdf file as well
  if (readnetcdf == 0) then
   call hdr_io(fform,hdr,rdwr,unitem1)
  else if (readnetcdf == 1) then
   call hdr_io_netcdf(fform,hdr,rdwr,unitem1)
  end if

  read(unitem1) titem1
  read(unitem1) npwvece,npwwfne,nbndse,nqe,nomegae

  if(npwvece>npwvec) then

   write(message,'(3a,i8,2a,i8)')               &
&   ' rdscr : WARNING - ',ch10,                 &
&   ' dimension of epsm1 matrix ',npwvece,ch10, &
&   ' reading a smaller matrix  ',npwvec
   call wrtout(6,message,'COLL')

  else if(npwvece<npwvec) then

   write(message,'(3a,i8,2a,i8)')&
&   ' rdscr : ERROR - ',ch10,&
&   ' dimension of epsm1 matrix  ',npwvece,ch10,&
&   ' requiring a too big matrix ',npwvec
   call wrtout(6,message,'COLL')
   call leave_new('COLL')

  end if

  if(nqe<nq) stop 'requiring too much q-points'
  if(nomegae<nomega) stop 'requiring too much omega-points'

  read(unitem1) ! skip gvec
  read(unitem1) qd(1:3,1:nq)
  read(unitem1) omegad(1:nomega)
  q(:,:) = qd(:,:)
  omega(:) = omegad(:)

  write(6,'(a,/,(i3,3f14.6))')&
&  ' q-points [reciprocal lattice units]:',(iq,(q(ii,iq),ii=1,3),iq=1,nq)
  write(6,'(a,/,(i3,2f7.2))')&
&  ' frequencies omega [eV]:',(io,omega(io)*Ha_eV,io=1,nomega)
   end if ! i_can_read

 if(master_must_cast_data)then
   call xcast_mpi(q,master,spaceComm,ierr)
   call xcast_mpi(npwvece,master,spaceComm,ierr)
   call xcast_mpi(omega,master,spaceComm,ierr)
 end if

! Read epsilon^-1
  allocate(epsm1d(npwvece,npwvece),stat=istat)
  if(istat/=0) then
   call memerr('rdscr','epsm1d',npwvece**2,'dpc')
  end if

 do iq=1,nq
  do io=1,nomega
   if(i_can_read)then
    read(unitem1) epsm1d(1:npwvece,1:npwvece)
   end if
   if(master_must_cast_data)then
    call xcast_mpi(epsm1d,master,spaceComm,ierr)
   end if
   epsm1(1:npwvec,1:npwvec,io,iq) = epsm1d(1:npwvec,1:npwvec)
  end do
  do io=nomega+1,nomegae
   if(i_can_read)then
    read(unitem1) ! skip other omegas
   end if
  end do
 end do ! iq

!MG FIXME why unitem1 is not closed here?
!close(unitem1)
 if(allocated(epsm1d))deallocate(epsm1d)
 if(allocated(omegad))deallocate(omegad)

 if(i_can_read)then
   call hdr_clean(hdr)
 end if

 if(abs(real(omega(1)))<0.01 .and. abs(aimag(omega(1)))<0.01) then
  do iq=1,nq
   if(all(abs(q(:,iq))<0.001)) then
    dielconst = 1.0/real(epsm1(1,1,1,iq))
    write(message,'(a,f6.2)')' dielectric constant with LF = ', dielconst
    call wrtout(6,message,'COLL')
   end if
  end do
 end if

 write(message,'(2a)')' epsilon-twiddle^-1 read',ch10
 call wrtout(6,message,'COLL')

 end subroutine rdscr
!!***
