!{\src2tex{textfont=tt}}
!!****f* ABINIT/rho_tw_g
!! NAME
!! rho_tw_g
!!
!! FUNCTION
!! Calculate rhotwg(G)=<wfn1|exp(-i*(q+G)*r)|wfn2>
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  igfftg0(npwvec)= (to be described)
!!  i1= (to be described)
!!  i2= (to be described)
!!  ktabr1(nr),ktabr2(nr) tables r^-1 r for that k points
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  npwvec=number of plane waves
!!  nr=number of FFT grid points
!!  nrb=(not used presently)
!!  tim_fourdp=1 if called from inside screening ; 2 if called from inside sigma
!!  wfn1(nr),wfn2(nr)=the two wavefunctions
!!
!! OUTPUT
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!
!! PARENTS
!!      cchi0,cchi0q0,csigme
!!
!! CHILDREN
!!      fourdp
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rho_tw_g(npwvec,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,igfftg0,wfn1,&
& i1,ktabr1,wfn2,i2,ktabr2,rhotwg,tim_fourdp)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_12ffts
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: i1,i2,ngfft1,ngfft1a,ngfft2,ngfft3,npwvec,nr,nrb
 integer,intent(in) :: tim_fourdp
!arrays
 integer,intent(in) :: igfftg0(npwvec),ktabr1(nr),ktabr2(nr)
 complex,intent(in) :: wfn1(nr),wfn2(nr)
 complex,intent(out) :: rhotwg(npwvec)

!Local variables-------------------------------
!scalars
 integer :: ig,ir,ir1,ir2
 real(dp) :: wfi1,wfi2,wfr1,wfr2
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: ngfft(18)
 real(dp),allocatable :: rhotw_dp(:,:),rhotwg_dp(:,:)

! *************************************************************************

 allocate(rhotwg_dp(2,nr),rhotw_dp(2,nr))

!to account for symmetries
!phi_Rk(r)=phi_k(R^-1 r)
!phi_Ik(r)=phi_k*(r)
!form rho-twiddle(r)
 if(i1==1) then
   if(i2==1) then
     do ir=1,nr
!      rhotw(ir)=conjg(wfn1(ktabr1(ir)))*wfn2(ktabr2(ir))
       ir1=ktabr1(ir) ; ir2=ktabr2(ir)
       wfr1=real(wfn1(ir1)) ; wfi1=aimag(wfn1(ir1))
       wfr2=real(wfn2(ir2)) ; wfi2=aimag(wfn2(ir2))
       rhotw_dp(1,ir)=wfr1*wfr2+wfi1*wfi2
       rhotw_dp(2,ir)=wfr1*wfi2-wfi1*wfr2

!       rhotw_dp(1,ir)=real(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))+&
!&       aimag(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))
!       rhotw_dp(2,ir)=real(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))-&
!&       aimag(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))
     end do
   else
     do ir=1,nr
!      rhotw(ir)=conjg(wfn1(ktabr1(ir))*wfn2(ktabr2(ir)))
       ir1=ktabr1(ir) ; ir2=ktabr2(ir)
       wfr1=real(wfn1(ir1)) ; wfi1=aimag(wfn1(ir1))
       wfr2=real(wfn2(ir2)) ; wfi2=aimag(wfn2(ir2))
       rhotw_dp(1,ir)= wfr1*wfr2-wfi1*wfi2
       rhotw_dp(2,ir)=-wfr1*wfi2-wfi1*wfr2

!       rhotw_dp(1,ir)=real(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))-&
!&       aimag(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))
!       rhotw_dp(2,ir)=-real(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))-&
!&       aimag(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))
     end do
   end if
 else
   if(i2==1) then
     do ir=1,nr
!      rhotw(ir)=wfn1(ktabr1(ir))*wfn2(ktabr2(ir))
       ir1=ktabr1(ir) ; ir2=ktabr2(ir)
       wfr1=real(wfn1(ir1)) ; wfi1=aimag(wfn1(ir1))
       wfr2=real(wfn2(ir2)) ; wfi2=aimag(wfn2(ir2))
       rhotw_dp(1,ir)= wfr1*wfr2-wfi1*wfi2
       rhotw_dp(2,ir)= wfr1*wfi2+wfi1*wfr2

!       rhotw_dp(1,ir)=real(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))-&
!&       aimag(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))
!       rhotw_dp(2,ir)=real(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))+&
!&       aimag(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))
     end do
   else
     do ir=1,nr
!      rhotw(ir)=wfn1(ktabr1(ir))*conjg(wfn2(ktabr2(ir)))
       ir1=ktabr1(ir) ; ir2=ktabr2(ir)
       wfr1=real(wfn1(ir1)) ; wfi1=aimag(wfn1(ir1))
       wfr2=real(wfn2(ir2)) ; wfi2=aimag(wfn2(ir2))
       rhotw_dp(1,ir)= wfr1*wfr2+wfi1*wfi2
       rhotw_dp(2,ir)=-wfr1*wfi2+wfi1*wfr2

!       rhotw_dp(1,ir)=real(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))+&
!&       aimag(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))
!       rhotw_dp(2,ir)=-real(wfn1(ktabr1(ir)))*aimag(wfn2(ktabr2(ir)))+&
!&       aimag(wfn1(ktabr1(ir)))*real(wfn2(ktabr2(ir)))
     end do
   end if
 end if

!write(6,*) 'Before FFT'
!do ir=1,nr,20
! write(6,'(i3,3x,2e20.6)') ir,real(rhotw(ir)),aimag(rhotw(ir))
! write(6,'(i3,3x,2e20.6)') ir,rhotw_dp(1,ir),rhotw_dp(2,ir)
!end do
!FFT to rho-twiddle (G)
!call c3dfft(rhotw,ngfft1a,ngfft2,ngfft3,ngfft1,ngfft2,ngfft3,-1)
 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3
 ngfft(4)=2*(ngfft(1)/2)+1
 ngfft(5)=2*(ngfft(2)/2)+1
 ngfft(6)=ngfft(3)
 ngfft(7)=200
 ngfft(8)=256
 ngfft(9)=0
 ngfft(10)=1
 ngfft(11)=0
 ngfft(12)=ngfft2
 ngfft(13)=ngfft3
 ngfft(14)=0
 mpi_enreg%me_fft=0
 mpi_enreg%nproc_fft=1
 call fourdp(2,rhotwg_dp,rhotw_dp,-1,mpi_enreg,nr,ngfft,tim_fourdp)

!Set up rho-twiddle(G-G0) for matrix in PW order, normalising for FFT

!rhotw(:)=rhotw(:)/nrb
!write(6,*) 'After FFT'
!do ir=1,nr,20
! write(6,'(i3,3x,2e20.6)') ir,real(rhotw(ir)),aimag(rhotw(ir))
! write(6,'(i3,3x,2e20.6)') ir,rhotwg_dp(1,ir),rhotwg_dp(2,ir)
!end do
!rhotwg(:)=rhotw(igfftg0(:))/nrb
 rhotwg(:)=cmplx(rhotwg_dp(1,igfftg0(:)),rhotwg_dp(2,igfftg0(:)))

 deallocate(rhotwg_dp,rhotw_dp)

end subroutine rho_tw_g
!!***
