!{\src2tex{textfont=tt}}
!!****f* ABINIT/ctocprj
!! NAME
!! ctocprj
!!
!! FUNCTION
!!  Compute all <Proj_i|Cnk> for every wave function |Cnk> expressed in reciprocal space.
!!  |Proj_i> are non-local projectors (for each atom and each l,m,n)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  atindx(natom)=index table for atoms
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  gmet(3,3)=reciprocal space metric tensor in bohr**-2
!!  gprimd(3,3)=dimensional reciprocal space primitive translations
!!  kg(3,mpw*mkmem)=reduced planewave coordinates
!!  mband=maximum number of bands
!!  mgfft=maximum size of 1D FFTs
!!  mkmem=number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpsang=1+maximum angular momentum for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw
!!  natom=number of atoms in cell
!!  nattyp(ntypat)= # atoms of each type
!!  nkpt=number of k points
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of types of atoms in unit cell
!!  ph1d(2,3*(2*mgfft+1)*natom)=1-dim structure factor phase information
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  rmet(3,3)=real space metric (bohr**2)
!!  tim_ctocprj=timing code of the calling routine
!!  uncp=unit number for <P_lmn|Cnk> data (if used)
!!  wffnow=struct infos for wf disk file
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!  ylm(mpw*mkmem,mpsang*mpsang)=real spherical harmonics for each G and k point
!!
!! OUTPUT
!!  cprj(natom,nspinor*mband*mkmem*nsppol) <type(cprj_type)>=
!!            projected input wave functions <Proj_i|Cnk> with all NL projectors
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      getcprj,leave_new,leave_test,mkffnl,ph1d3d,status,wrtout,xcomm_init
!!      xmaster_init,xme_init
!!
!! SOURCE

 subroutine ctocprj(atindx,cg,cprj,dtfil,dtset,gmet,gprimd,kg,mband,mgfft,mkmem,mpi_enreg,&
&                   mpsang,mpw,natom,nattyp,nkpt,npwarr,nspinor,nsppol,ntypat,ph1d,psps,&
&                   rmet,ucvol,uncp,wffnow,xred,ylm)

 use defs_basis
 use defs_datatypes
#if defined HAVE_NETCDF
 use netcdf
#endif

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13io_mpi
 use interfaces_13nonlocal
 use interfaces_14iowfdenpot
 use interfaces_lib01hidempi
#else
 use defs_interfaces
#endif
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 integer,intent(in) :: mband,mgfft,mkmem,mpsang,mpw,natom,nkpt,nsppol,ntypat
 integer,intent(in) :: uncp
 integer,intent(inout) :: nspinor
 real(dp),intent(in) :: ucvol
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(MPI_type),intent(inout) :: mpi_enreg
 type(pseudopotential_type),intent(in) :: psps
 type(wffile_type),intent(inout) :: wffnow
!arrays
 integer,intent(in) :: atindx(natom),nattyp(ntypat),npwarr(nkpt),kg(3,mpw*mkmem)
 real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 real(dp),intent(in) :: gmet(3,3),gprimd(3,3),ph1d(2,3*(2*mgfft+1)*natom),rmet(3,3)
 real(dp),intent(in) :: ylm(mpw*mkmem,mpsang*mpsang),xred(3,natom)
 type(cprj_type),intent(out) :: cprj(natom,nspinor*mband*mkmem*nsppol)

!Local variables-------------------------------
!scalars
 integer,parameter :: level=7
 integer :: choice,counter,cpopt,dimffnl,formeig,ia,ia1,iband,ibg,icg,icgb,ider,ierr
 integer :: iexit,ig,ikg,ikpt,ilm,isppol,istwf_k,itypat,master,matblk,mcg_disk
 integer :: me,muig,nband_k,nkpg,npw_k,SpaceComm,tim_rwwf
 real(dp) :: arg
 character(len=500) :: message
!arrays
 integer,allocatable :: dimlmn(:),kg_dum(:,:),kg_k(:,:)
 real(dp) :: kpoint(3),tsec(2),ylmgr_dum(1)
 real(dp),allocatable :: cg_disk(:,:),cwavef(:,:)
 real(dp),allocatable :: eig_dum(:), ffnl(:,:,:,:),kpg_dum(:,:)
 real(dp),allocatable :: occ_dum(:),ph3d(:,:,:),phkxred(:,:),ylm_k(:,:)
 type(cprj_type),allocatable :: cprj_nk(:)

! *********************************************************************

 if (psps%useylm==0) then
  write(message, '(4a)' ) ch10,&
&  ' ctocprj : ERROR -',ch10,&
&  '  Not available for useylm=0 !'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 call status(0,dtfil%filstat,iexit,level,'enter ctocprj ')

!Init parallelism
 call xcomm_init(mpi_enreg,spaceComm)
 call xme_init(mpi_enreg,me)
 call xmaster_init(mpi_enreg,master)

!Prepare temporary files if mkmem==0
 if (mkmem==0) then
  formeig=0;mcg_disk=mpw*nspinor*mband
  call hdr_skip(wffnow,ierr)
  call xdefineOff(formeig,wffnow,mpi_enreg,dtset%nband,npwarr,nspinor,nsppol,nkpt)
  allocate(cg_disk(2,mcg_disk))
 end if

!Initialize some variables
 ibg=0;icg=0;cpopt=0;nkpg=0;choice=1
 allocate(dimlmn(natom));ia1=0
 ia1=0
 do itypat=1,dtset%ntypat
  dimlmn(ia1+1:ia1+nattyp(itypat))=count(psps%indlmn(3,:,itypat)>0)
  ia1=ia1+nattyp(itypat)
 end do
 allocate(cprj_nk(natom))
 call cprj1_alloc(cprj_nk,0,dimlmn)
 if (mkmem==0) then
  rewind(uncp)
  write(uncp) natom,nspinor
  write(uncp) dimlmn(1:natom)
 end if

!LOOP OVER SPINS
 do isppol=1,nsppol
  ikg=0

! Rewind temporary files if needed
  if (mkmem==0) rewind(dtfil%unkg)
  if (mkmem==0) rewind(dtfil%unylm)

! BIG FAT k POINT LOOP
  do ikpt=1,nkpt

   counter=100*ikpt+isppol
   call status(counter,dtfil%filstat,iexit,level,'loop ikpt     ')

   nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)
   istwf_k=dtset%istwfk(ikpt)
   npw_k=npwarr(ikpt)

   if(mpi_enreg%paral_compil_kpt==1)then
    if(minval(abs(mpi_enreg%proc_distrb(ikpt,1:nband_k,isppol)-mpi_enreg%me))/=0) then
     cycle
    end if
   end if

   kpoint(:)=dtset%kptns(:,ikpt)
   allocate(ylm_k(npw_k,mpsang*mpsang),kg_k(3,npw_k))
   allocate(cwavef(2,npw_k*nspinor))

!  Retreive (k+G) points and spherical harmonics
   if (mkmem==0) then
    call rdnpw(ikpt,isppol,nband_k,npw_k,nspinor,0,dtfil%unkg)
    read (dtfil%unkg) kg_k(1:3,1:npw_k)
    read(dtfil%unylm)
    read(dtfil%unylm) ((ylm_k(muig,ilm),muig=1,npw_k),ilm=1,mpsang*mpsang)
    call status(counter,dtfil%filstat,iexit,level,'read wfs      ')
    tim_rwwf=1;allocate(eig_dum(mband),kg_dum(3,0),occ_dum(mband))
    call rwwf(cg_disk,eig_dum,0,0,0,ikpt,isppol,kg_dum,mband,mcg_disk,nband_k,&
&             nband_k,npw_k,nspinor,occ_dum,-2,0,tim_rwwf,wffnow)
    deallocate(eig_dum,kg_dum,occ_dum)
    write(uncp) nband_k
   else
    kg_k(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
    do ilm=1,mpsang*mpsang
     ylm_k(1:npw_k,ilm)=ylm(1+ikg:npw_k+ikg,ilm)
    end do
   end if

!  Allocate and compute the arrays phkxred and ph3d
   allocate(phkxred(2,natom))
   do ia=1,natom
    ia1=atindx(ia)
    arg=two_pi*(kpoint(1)*xred(1,ia)+kpoint(2)*xred(2,ia)+kpoint(3)*xred(3,ia))
    phkxred(1,ia1)=cos(arg);phkxred(2,ia1)=sin(arg)
   end do
   if(dtset%nloalg(1)<=0)then
!   Here, only the allocation of ph3d , not the precomputation
    matblk=dtset%nloalg(4);allocate(ph3d(2,npw_k,matblk))
   else
!   Here, allocation as well as precomputation
    matblk=natom;allocate(ph3d(2,npw_k,matblk))
    call ph1d3d(1,natom,kg_k,kpoint,matblk,natom,npw_k,dtset%ngfft(1),&
&               dtset%ngfft(2),dtset%ngfft(3),phkxred,ph1d,ph3d)
   end if

!  Compute nonlocal form factors ffnl at all (k+G)
   call status(0,dtfil%filstat,iexit,level,'call mkffnl   ')
   ider=0;dimffnl=1
   allocate(ffnl(npw_k,dimffnl,psps%lmnmax,ntypat))
   call mkffnl(psps%dimekb,dimffnl,psps%ekb,ffnl,psps%ffspl,&
&   gmet,gprimd,ider,ider,psps%indlmn,kg_k,kpg_dum,kpoint,psps%lmnmax,&
&   psps%lnmax,psps%mpsang,psps%mqgrid_ff,nkpg,npw_k,ntypat,&
&   psps%pspso,psps%qgrid_ff,rmet,psps%usepaw,psps%useylm,ylm_k,ylmgr_dum)

!  Loop over bands
   icgb=icg
   do iband=1,nband_k

    if(mpi_enreg%paral_compil_kpt==1)then
      if (mpi_enreg%proc_distrb(ikpt,iband,isppol)/= me) cycle
    end if

!   Extract wavefunction information
    if (mkmem==0) then
     do ig=1,npw_k*nspinor
      cwavef(1,ig)=cg_disk(1,ig+icgb)
      cwavef(2,ig)=cg_disk(2,ig+icgb)
     end do
    else
     do ig=1,npw_k*nspinor
      cwavef(1,ig)=cg(1,ig+icgb)
      cwavef(2,ig)=cg(2,ig+icgb)
     end do
    end if

!   Compute scalar product of wavefunction with all NL projectors
    call getcprj(choice,cpopt,cprj_nk,cwavef,psps%dimekb,ntypat,dimffnl,&
&                psps%ekb,ffnl,psps%indlmn,istwf_k,kg_k,kpg_dum,kpoint,psps%lmnmax,&
&                matblk,mgfft,mpi_enreg,natom,nattyp,dtset%ngfft,nkpg,dtset%nloalg,&
&                npw_k,nspinor,ntypat,phkxred,ph1d,ph3d,ucvol,psps%usepaw,psps%useylm)

    if (mkmem/=0) then
!    If mkmem/=0, store result
     do ia=1,natom
      cprj(ia,ibg+iband)%cp(:,1:dimlmn(ia))=cprj_nk(ia)%cp(:,1:dimlmn(ia))
     end do
    else
!    If mkmem=0, write to disk
     do ia=1,natom
      write(uncp) cprj_nk(ia)%cp(:,1:dimlmn(ia))
     end do
    end if

!   End loop over bands
    icgb=icgb+npw_k*nspinor
   enddo

!  Shift array memory (if mkmem/=0)
   if (mkmem/=0) then
    ibg=ibg+nspinor*nband_k
    icg=icg+nspinor*nband_k*npw_k
    ikg=ikg+npw_k
   end if

!  End big k point loop
   deallocate(ffnl,ph3d,phkxred,kg_k,ylm_k,cwavef)
  end do

!End loop over spins
 end do

!Deallocate temporary storage
 call cprj1_free(cprj_nk)
 deallocate(cprj_nk,dimlmn)
 if(mkmem==0) deallocate(cg_disk)

 end subroutine ctocprj
!!***
