C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.

c This function returns the atomic number of atom SYMB. It returns 0 if
c the atom is not recognized. SYMB can be one or two characters long,
c but every letter must be capitalized. Furthermore, the caller is
c responsible for making sure "I AM NOT AN ELEMENT" does not match "I ".
c (This routine ignores anything after the second character.)

c The hash tables were generated by the most excellent Minimum Perfect
c Hash program by Taj Khattra.
c       A Family of Perfect Hashing Methods
c       B. S. Majewski, N. C. Wormald, G. Havas and Z. J. Czech
c       Computer Journal (to appear).

      integer function AtomNumb(symb)
      implicit none

      character*(*) symb

      character*2 SymbTable(111), sz
      data SymbTable /
     & 'H ','HE',
     & 'LI','BE',
     & 'B ','C ','N ','O ','F ','NE',
     & 'NA','MG',
     & 'AL','SI','P ','S ','CL','AR',
     & 'K ','CA',
     & 'SC','TI','V ','CR','MN','FE','CO','NI','CU','ZN',
     & 'GA','GE','AS','SE','BR','KR',
     & 'RB','SR',
     & 'Y ','ZR','NB','MO','TC','RU','RH','PD','AG','CD',
     & 'IN','SN','SB','TE','I ','XE',
     & 'CS','BA',
     & 'LA','CE','PR','ND','PM','SM','EU',
     &                               'GD','TB','DY','HO','ER','TM','YB',
     & 'LU','HF','TA','W ','RE','OS','IR','PT','AU','HG',
     & 'TL','PB','BI','PO','AT','RN',
     & 'FR','RA',
     & 'AC','TH','PA','U ','NP','PU','AM',
     &                               'CM','BK','CF','ES','FM','MD','NO',
     & 'LR','RF','DB','SG','BH','HS','MT','DS','RG'
     &               /

      integer g(232)
      data g /
     &          0,  67,  -1,   0, 100,  -1,  54,   0,  -1,  -1,
     &         -1,  86,  32,  86,  63,  -1,  83,  -1,  -1,  -1,
     &          0,  39,  61,  -1,  36,   0,  -1,  -1,  77,  65,
     &         98,   9,   0,   9,  83,  73,  -1,  99,  68,  -1,
     &         11,  22,  -1,  32,  -1, 105,  22,  -1, 102,  -1,
     &         -1,  -1,  57,  -1,  57,  -1,  81,  38,   0,   0,
     &         -1,   0,   0,  -1,  77,   0,   0,  85,  26,  45,
     &         -1,  27,   0,   6,  16,  30,   0,  60,  67,  78,
     &         -1,  53,  83,  47,  71,   0,  -1,  58,  -1,  40,
     &         78,  -1,  44,  54,  -1,  77,  -1,  -1,  93,  -1,
     &         -1,  -1,  25,  41,  -1,   0,  -1,  -1,   9,  -1,
     &         10,  68,  -1,   0,  66,  -1,  85,  -1,  42,   0,
     &         77,   0,  -1,  16,  59,  -1,   0,  -1,   0,  -1,
     &         -1,  -1,  -1,  -1,  55,   0,  24,  -1,  -1,   3,
     &         -1,  97,  -1,  -1,  28,  -1,  -1,  -1,  17,  84,
     &         48,   6,  -1,  -1,  -1,  26,  81,   0,  77,  -1,
     &         39,  87,  68,  78,   0,  -1,   7, 106,  36, 109,
     &         49,  -1,  31,  81,  44,  62,  60,  -1,   0,   0,
     &         98,  -1,  51,  -1,  -1,  96,  48, 106,   0,  -1,
     &         42, 110,  -1,  -1,  79,  -1,  97,  46,   0,   0,
     &         -1,  38, 103,  -1,  30,   0,  -1,   0,  -1,  -1,
     &         29,  92,  60,  50,  -1,  -1,  -1,  -1,  -1,   0,
     &         35,   0,  -1,  -1,  74,   0,  -1,   1,  37,  -1,
     &          0,  -1
     &       /

      integer T0(118)
      data T0 /
     &          17,  37,  51, 147, 223, 195,  81,  79, 151,  16,
     &         112,  28,  92, 196,  63, 111,   7,  78, 150, 119,
     &         202,  56, 187, 149,  74,  37,  37,   3,  67, 155,
     &          26,  76, 193,  78, 224, 184,  41,  73,  23, 192,
     &          81, 135, 220, 173,  91,  43,  52,  99, 122, 203,
     &         218,  84,  27, 173,   2, 102, 210,  31,  97, 126,
     &         201, 100,  41,  11, 155, 129, 157, 175,  85, 182,
     &         140, 181,  42,  29, 195,  89, 117, 125, 160, 185,
     &         141,  59, 167,  90, 144, 171, 148, 163,  97,  30,
     &          49,  66, 122,  83,  78,  46, 212, 227, 213,  66,
     &         169, 113,  15, 211, 135, 202,  68,  20,  96, 220,
     &         197, 229,  48, 133,  87, 184,  64,   4
     &        /

      integer T1(118)
      data T1 /
     &         223,  75, 206, 183,  62,  23, 165,  50, 226, 152,
     &         200,  47, 219, 156,   7,  58,  70, 185, 148, 184,
     &          86,  17, 195,  77, 187,  93, 168, 104, 187, 134,
     &         227, 178, 201, 202, 121,  24, 217,  55,  74, 204,
     &         199,  34,  19, 178, 190,  18,   5,  20, 204, 145,
     &         196,  50, 154, 159, 127, 110,  12,  55, 214, 146,
     &          40,  95, 190,  39, 175, 175, 160, 176,  46, 189,
     &          39,   6,  80, 178,  95, 217,   2,  16,  54, 175,
     &         194, 174, 109,  40, 219,  26,  47, 220, 125,  28,
     &         126, 165, 115,  84, 196,  59,  28, 117, 227,  66,
     &          66,  26,  64, 146, 204, 152, 131, 206, 168, 178,
     &         149, 123, 120,  26, 155,  99,  44, 202
     &        /

      integer l, i1, i2, f0, f1, r1, r2, r3, r4
      integer iachar

      sz = symb

c      l  = max(1,min(2,len(symb)))
c      i1 = iachar(sz(1:1))
c      i2 = iachar(sz(2:2))
c      r1 = i1-31
c      r2 = i2+28
c      r3 = l-1
c      r4 = 2-l
c      f0 = T0(r1) + T0(r2)*r3 + 126*r4
c      f1 = T1(r1) + T1(r2)*r3 + 146*r4
      i1 = iachar(sz(1:1))
      r1 = i1-31
*      if (len(symb).ne.1) then
         i2 = iachar(sz(2:2))
         r2 = i2+28
         f0 = T0(r1) + T0(r2)
         f1 = T1(r1) + T1(r2)
*      else
*         f0 = T0(r1) + 126
*         f1 = T1(r1) + 146
*      end if

      f0 = 1+mod(f0,232)
      f1 = 1+mod(f1,232)
      l  = 1+mod(g(f0)+g(f1),111)

c      i1 = i1-iachar(SymbTable(l)(1:1))
c      i2 = i2-iachar(SymbTable(l)(2:2))
c      AtomNumb = l*(1-min(1,ior(i1*i1,i2*i2)))
      AtomNumb = l
      if (sz.ne.SymbTable(l)) AtomNumb = 0

      return
c     end function AtomNumb
      end

