#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include "textedit.h"

TextEdit::TextEdit(QWidget *parent, Qt::WindowFlags f) : QWidget(parent, f) {

  QVBoxLayout *mainLayout = new QVBoxLayout;
  setLayout(mainLayout);
  QHBoxLayout *buttonLayout = new QHBoxLayout;
  QWidget *buttonFrame = new QWidget;
  buttonFrame->setLayout(buttonLayout);
  cancelButton = new QPushButton("Cancel");
  buttonLayout->addWidget(cancelButton);
  okButton = new QPushButton("OK");      
  buttonLayout->addWidget(okButton);
  QObject::connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancelClicked()));
  QObject::connect(okButton, SIGNAL(clicked()), this, SLOT(okClicked()));
  text = new QTextEdit;
  text->setAcceptRichText(false);
  mainLayout->addWidget(text);
  mainLayout->addWidget(buttonFrame);
}

TextEdit::~TextEdit() {

}

QString TextEdit::getText() {

  return(text->toPlainText());
}

void TextEdit::clear() {

  return(text->clear());
}

void TextEdit::cancelClicked() {

  emit cancelText();
}

void TextEdit::okClicked() {

  emit textOK();
}

void TextEdit::setText(QString qs) {

  text->setText(qs);
}

void TextEdit::setReadOnly(bool flag) {

  text->setReadOnly(flag);
}        

void TextEdit::setCancel(bool flag) {

  if (!flag) {
    cancelButton->hide();
  } else {
    cancelButton->show();
  }
}        
