/*************************************************************************************
 *  Copyright (C) 2011 by Aleix Pol <aleixpol@kde.org>                               *
 *                                                                                   *
 *  This program is free software; you can redistribute it and/or                    *
 *  modify it under the terms of the GNU General Public License                      *
 *  as published by the Free Software Foundation; either version 2                   *
 *  of the License, or (at your option) any later version.                           *
 *                                                                                   *
 *  This program is distributed in the hope that it will be useful,                  *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of                   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    *
 *  GNU General Public License for more details.                                     *
 *                                                                                   *
 *  You should have received a copy of the GNU General Public License                *
 *  along with this program; if not, write to the Free Software                      *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA   *
 *************************************************************************************/

#include "localize.h"

#ifdef NO_KDECORE

QString i18n(const char* a) { return QString::fromUtf8(a); }
QString i18nc(const char*, const char* a) { return QString::fromUtf8(a); }

QString i18np(const char* singular, const char* plural, int x1)
{
	return QString::fromUtf8(x1==1 ? singular : plural).arg(x1);
}
#else
#include <kdeversion.h>

#if KDE_IS_VERSION(4,5,90)
#include <kglobal.h>

static const KCatalogLoader loader("analitza");
#endif

#endif
