// Copyright (c) 1997 by Jim Lynch.
// Copyright (c) 2010-2012 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#include <string>
#include <gdbm.h>
#include <sstream>

typedef GDBM_FILE GDBMFile;

extern long lastKeyAssigned;

long CStringToLong(const char *string);
char *LongToNewCString(long theLong);
char *MakeCStringCopy(const string &orig);
char *MakeCStringCopy(const char *orig);
char *MakeCStringCopy(ostrstream &orig);
GDBM_FILE OpenFile(const char * dbfile);
void CloseFile(GDBMFile handle);
void SetLast(GDBMFile handle, const string &newKey);
string GetLast(GDBMFile handle);
int IsAnimal(GDBMFile handle, const string &theKey);

