# Contributing

First off, thanks for contributing to **antimeridian**!
We appreciate it.

## Reporting a bug

1. Go to <https://github.com/gadomski/antimeridian/issues/new>
2. Create a new issue.
   Please provide as much information as you can about the problem, including your system, the source file, and any error messages.

## Requesting a feature

1. Go to <https://github.com/gadomski/antimeridian/issues/new>
2. Create a new issue that describes the feature that you'd like to see, with as much detail as possible.

We will do our best to review and provide feedback on any feature requests, but know that it might take a while.

## Fixing or adding something

1. Hack away (see the [Developing](./README.md#developing) section of the README for how to get started).
2. Fork this repo to your own account.
3. Push your branch to your repo.
4. Open a pull request (PR) against <https://github.com/gadomski/antimeridian>.

We'll do our best to review your PR in a timely fashion.
Here's some things to include your PR to make our lives easier:

- A good description of what you're adding or fixing
- Tests to demonstrate the bug you're fixing, or to exercise the feature you're adding
- Documentation about the new feature, if applicable
- A [CHANGELOG](./CHANGELOG.md) entry
- Well-organized git history, where each commit is one self-contained set of work

Don't bother with bumping the version number, we'll do that ourselves.
