/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:10:04 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.FileNode;
import uk.ac.sanger.artemis.components.filetree.FileSystemModel;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FileSystemModel_ESTest extends FileSystemModel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      String[] stringArray0 = new String[3];
      FileSystemModel fileSystemModel0 = null;
      try {
        fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      File[] fileArray0 = new File[2];
      RegexFileFilter regexFileFilter0 = new RegexFileFilter("|CYEp,]@g4Z");
      FileSystemModel fileSystemModel0 = null;
      try {
        fileSystemModel0 = new FileSystemModel(fileArray0, regexFileFilter0, (JFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      RegexFileFilter regexFileFilter0 = new RegexFileFilter("Z", 1655);
      fileSystemModel0.setFilter(regexFileFilter0);
      FileFilter fileFilter0 = fileSystemModel0.getFilter();
      assertSame(fileFilter0, regexFileFilter0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      String string0 = fileSystemModel0.getColumnName(0);
      assertEquals("Name", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Class class0 = fileSystemModel0.getColumnClass(2);
      assertFalse(class0.isInterface());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.isLeaf((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      FileSystemModel.cNames = null;
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnClass(3);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 3
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildren((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildren("uk.ac.sanger.artemis.components.filetree.FileSystemModel");
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildCount((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      HiddenFileFilter hiddenFileFilter0 = (HiddenFileFilter)HiddenFileFilter.HIDDEN;
      // Undeclared exception!
      try { 
        fileSystemModel0.getChildCount(hiddenFileFilter0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.apache.commons.io.filefilter.HiddenFileFilter cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild((Object) null, (-2715));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      String[] stringArray0 = new String[3];
      stringArray0[0] = "UFJ6q(Ch'(cfD#C";
      stringArray0[1] = "user.dir";
      stringArray0[2] = "ABo@:X]a?69f m";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      SynthTreeUI synthTreeUI0 = new SynthTreeUI();
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild(synthTreeUI0, (-3684));
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // javax.swing.plaf.synth.SynthTreeUI cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt((Object) null, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      DefaultTableModel defaultTableModel0 = new DefaultTableModel();
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt(defaultTableModel0, 1);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // javax.swing.table.DefaultTableModel cannot be cast to uk.ac.sanger.artemis.components.filetree.RemoteFileNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getValueAt((Object) null, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "~9)09[";
      stringArray0[1] = "Size";
      stringArray0[2] = "Z.f~vMNAZ fY";
      stringArray0[3] = "_d^aW+";
      stringArray0[4] = "|G&dawe[<3N?w";
      stringArray0[5] = "";
      stringArray0[6] = "7#z?L8S";
      stringArray0[7] = "Name";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      File file0 = MockFile.createTempFile("Size", "k??)]_1D$aJJw@<s");
      FileNode fileNode0 = new FileNode(file0);
      Object object0 = fileSystemModel0.getValueAt(fileNode0, (-255));
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      Object object0 = fileSystemModel0.getValueAt("uk.ac.sanger.artemis.components.filetree.FileSystemModel", 433);
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      JTree jTree0 = new JTree(fileSystemModel0);
      assertFalse(jTree0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      File[] fileArray0 = new File[2];
      MockFile mockFile0 = new MockFile("65VM", "");
      fileArray0[0] = (File) mockFile0;
      fileArray0[1] = (File) mockFile0;
      RegexFileFilter regexFileFilter0 = new RegexFileFilter("|CYEp,]@g4Z");
      FileSystemModel fileSystemModel0 = new FileSystemModel(fileArray0, regexFileFilter0, (JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.isLeaf(regexFileFilter0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.apache.commons.io.filefilter.RegexFileFilter cannot be cast to javax.swing.tree.TreeNode
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      // Undeclared exception!
      try { 
        fileSystemModel0.getColumnName((-1008));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1008
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      Object object0 = fileSystemModel0.getRoot();
      // Undeclared exception!
      try { 
        fileSystemModel0.getChild(object0, 433);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 433
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileSystemModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      int int0 = fileSystemModel0.getColumnCount();
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FileSystemModel fileSystemModel0 = new FileSystemModel((JFrame) null);
      Class class0 = fileSystemModel0.getColumnClass(0);
      assertEquals("interface uk.ac.sanger.artemis.components.filetree.TreeTableModel", class0.toString());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      FileFilter fileFilter0 = fileSystemModel0.getFilter();
      assertNull(fileFilter0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[1] = "org.apache.commons.io.filefilter.NameFileFilter";
      stringArray0[2] = "";
      stringArray0[3] = "{,3";
      stringArray0[4] = "";
      stringArray0[5] = "user.home";
      stringArray0[6] = "uk.ac.sanger.artemis.components.filetree.FileSystemModel";
      stringArray0[7] = "user.home";
      FileSystemModel fileSystemModel0 = new FileSystemModel(stringArray0, (JFrame) null);
      DefaultMutableTreeNode defaultMutableTreeNode0 = new DefaultMutableTreeNode();
      boolean boolean0 = fileSystemModel0.isLeaf(defaultMutableTreeNode0);
      assertTrue(boolean0);
  }
}
