------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--              G N A T P P . S O U R C E _ T R A V E R S A L               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2001-2006, AdaCore                     --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write to the Free Software Foundation,  51 Franklin Street, Fifth Floor, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the main traversal engine for GNATPP.

with Asis;          use Asis;
with Asis.Iterator; use Asis.Iterator;

with GNATPP.Common; use GNATPP.Common;

package GNATPP.Source_Traversal is

   procedure Pre_Operation
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  Pre-operation for traversal. The general idea is to start
   --  pretty-printing of the Element being visited. See the body for more
   --  information

   procedure Post_Operation
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  Post-operation for traversal. The general idea is to complete
   --  pretty-printing of the Element being visited. See the body for more
   --  information

   procedure Traverse_Source is new Traverse_Element
     (State_Information => Source_Traversal_State);

   procedure Traverse_Source_Preserving_State
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State);
   --  This is a wrapper procedure for Traverse_Source. It saves
   --  GNATPP.State.Current_State, then calls Traverse_Source and then restores
   --  GNATPP.State.Current_State back. When some Pre- or Post-operation needs
   --  to traverse some Element as a part of its processing, it has to use this
   --  wrapper procedure, but not Traverse_Source!

end GNATPP.Source_Traversal;
