# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-25 17:57
from __future__ import unicode_literals

import autoradio.jingles.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Configure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sezione', models.CharField(default=b'jingle', editable=False, max_length=50, unique=True)),
                ('active', models.BooleanField(default=True, help_text='activate/deactivate the intere jingle class', verbose_name='Activate Jingle')),
                ('emission_freq', models.TimeField(verbose_name='Frequency')),
            ],
        ),
        migrations.CreateModel(
            name='Giorno',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('luned\xec', 'luned\xec'), ('marted\xec', 'marted\xec'), ('mercoled\xec', 'mercoled\xec'), ('gioved\xec', 'gioved\xec'), ('venerd\xec', 'venerd\xec'), ('sabato', 'sabato'), ('domenica', 'domenica')], help_text='weekday name', max_length=20, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Jingle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jingle', models.CharField(max_length=80, unique=True, verbose_name='Jingle name')),
                ('file', autoradio.jingles.models.DeletingFileField(help_text='The jingle file to upload', max_length=255, upload_to=b'jingles', verbose_name='File')),
                ('rec_date', models.DateTimeField(help_text='When the jingle was done (for reference only)', verbose_name='Recording date')),
                ('active', models.BooleanField(default=True, help_text='Activate the jingle for emission', verbose_name='Active')),
                ('start_date', models.DateField(blank=True, help_text='The jingle will be scheduled starting from this date', null=True, verbose_name='Emission starting date')),
                ('end_date', models.DateField(blank=True, help_text='The jingle will be scheduled ending this date', null=True, verbose_name='Emission end date')),
                ('start_time', models.TimeField(blank=True, help_text='The jingle will be scheduled starting from this date', null=True, verbose_name='Emission start time')),
                ('end_time', models.TimeField(blank=True, help_text='The jingle will be scheduled ending this date', null=True, verbose_name='Emission end time')),
                ('priorita', models.IntegerField(default=50, help_text='When there are more jingle that wait for emission from the same time, the emission will be ordered by this numer', verbose_name='Priority')),
                ('emission_done', models.DateTimeField(editable=False, null=True, verbose_name='emission done')),
                ('giorni', models.ManyToManyField(blank=True, help_text='The jingle will be scheduled those weekdays', to='jingles.Giorno', verbose_name='Scheduled days')),
            ],
        ),
    ]
