#ifndef AVM_LOCKER_H
#define AVM_LOCKER_H

#include "avm_default.h"

AVM_BEGIN_NAMESPACE;

// do not include pthread.h nor semaphore.h here
// hidden in the implementation

class PthreadMutex;

/**
 *
 */
class AVMEXPORT PthreadCond
{
    void* m_pCond;
    /// \internal disabled
    PthreadCond(const PthreadCond&) : m_pCond(0) {}
    /// \internal disabled
    PthreadCond& operator=(const PthreadCond&) { return *this; }
public:
    PthreadCond();
    ~PthreadCond();
    int Wait(PthreadMutex& m, float waitTime = -1.f);
    int Broadcast();
};

/**
 * class used to hide usage of thread
 *
 * it might be implemented diferently for various platforms
 */
class AVMEXPORT PthreadMutex
{
    void* m_pMutex;
    friend int PthreadCond::Wait(PthreadMutex&, float);
    /// \internal disabled
    PthreadMutex(const PthreadMutex&) : m_pMutex(0) {}
    /// \internal disabled
    PthreadMutex& operator=(const PthreadMutex&) { return *this; }
public:
    // most probably unportable
    // enum Attr { FAST, RECURSIVE };
    PthreadMutex( /* Attr = FAST */ );
    ~PthreadMutex();
    /// Lock mutex
    int Lock();
    /// TryLock mutex
    int TryLock();
    /// Unlock mutex
    int Unlock();
};


/**
 * Creates a new thread of control that executes concurrently with
 * the calling thread.
 */
class AVMEXPORT PthreadTask
{
    void* m_pTask;
    /// \internal disabled
    PthreadTask(const PthreadTask&) : m_pTask(0) {}
    /// \internal disabled
    PthreadTask& operator=(const PthreadTask&) { return *this; }
public:
    PthreadTask(void* attr, void* (*start_routine)(void *), void* arg);
    ~PthreadTask();
};

/**
 * Simple mutex locker for simplifying Lock/Unlock usage
 *
 * thus there is no need to worry about unlocking on the exit path
 * the beauty of C++ :)
 *
 * constructor locks passed mutex
 * destructor unlocks passd mutex
 */
class AVMEXPORT Locker
{
    PthreadMutex& m_Mutex;
    /// \internal disabled
    Locker(const Locker&) : m_Mutex(*(new PthreadMutex())) {}
    /// \internal disabled
    Locker& operator=(const Locker&) { return *this; }
public:
    Locker(PthreadMutex& mutex) : m_Mutex(mutex) { m_Mutex.Lock(); }
    ~Locker() { m_Mutex.Unlock(); }
};

AVM_END_NAMESPACE;

#ifdef AVM_COMPATIBLE
typedef avm::Locker Locker;
typedef avm::PthreadCond PthreadCond;
typedef avm::PthreadMutex PthreadMutex;
#endif

#endif // AVM_LOCKER_H
