\documentclass{article}
\usepackage{../..../../../src/scripts/tex/axiom}
\begin{document}
\title{\$SPAD/lsp/ccl/src/axbase/compiler/lib axlit.lsp}
\author{Arthur Norman}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{License}
<<license>>=
; Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are
; met:
;
;     - Redistributions of source code must retain the above copyright
;       notice, this list of conditions and the following disclaimer.
;
;     - Redistributions in binary form must reproduce the above copyright
;       notice, this list of conditions and the following disclaimer in
;       the documentation and/or other materials provided with the
;       distribution.
;
;     - Neither the name of The Numerical ALgorithms Group Ltd. nor the
;       names of its contributors may be used to endorse or promote products
;       derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
; IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
; TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
; PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
; OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
; EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
; PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
; LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

@
<<*>>=
<<license>>
 

;;;
;;; Lisp code generated by Aldor from file "axlit.as".
;;;

(in-package "FOAM-USER" :use '("FOAM" "LISP"))

(declare-prog (|C0-axlit-axlit|) ((|e1| |Env|)))

(declare-prog
  (|C1-axlit-error| |Word|)
  ((|P0-s| |Word|) (|e1| |Env|)))

(declare-prog
  (|C2-axlit-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C3-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C4-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C5-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C6-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog (|C7-axlit-new| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog (|C8-axlit-#| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C9-axlit-apply| |Word|)
  ((|P0-x| |Word|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C10-axlit-set!|)
  ((|P0-x| |Word|) (|P1-n| |Word|) (|P2-v| |Word|) (|e1| |Env|)))

(declare-prog
  (|C11-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C12-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C13-axlit-string| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C14-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C15-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C16-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C17-axlit-string| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C18-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C19-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C20-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C21-axlit-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C22-axlit-coerce| |Word|)
  ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog (|C23-axlit-zero| |Word|) ((|e1| |Env|)))

(declare-prog (|C24-axlit-one| |Word|) ((|e1| |Env|)))

(declare-prog (|C25-axlit-inc| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog (|C26-axlit-dec| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))

(declare-prog
  (|C27-axlit-leq| |Word|)
  ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))

(declare-prog (|C28-axlit-spit|) ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C29-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C30-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C31-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C32-axlit-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C33-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C34-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C35-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C36-axlit-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C37-axlit-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C38-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C39-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C40-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C41-axlit-integer| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C42-axlit-coerce| |Word|)
  ((|P0-i| |Word|) (|e1| |Env|)))

(declare-prog
  (|C43-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C44-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C45-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C46-axlit-float| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C47-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C48-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C49-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C50-axlit-float| |Word|)
  ((|P0-l| |Word|) (|e1| |Env|)))

(declare-prog
  (|C51-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog (|C52-axlit-Tuple| |Word|) ((p0-t |Word|) (|e1| |Env|)))

(declare-prog
  (|C53-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C54-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C55-axlit-length| |Word|)
  ((|P0-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C56-axlit-element| |Word|)
  ((|P0-t| |Word|) (|P1-n| |Word|) (|e1| |Env|)))

(declare-prog (|C57-axlit-axlit| |Word|) ((p0-t |Word|) (|e1| |Env|)))

(declare-prog
  (|C58-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog (|C59-axlit-List| |Word|) ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C60-axlit-addLevel0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C61-axlit-addLevel1| |Word|)
  ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))

(declare-prog
  (|C62-axlit-bracket| |Word|)
  ((|P0-t| |Word|) (|e1| |Env|)))

(declare-prog
  (|C63-axlit-first| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C64-axlit-rest| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C65-axlit-cons| |Word|)
  ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))

(declare-prog
  (|C66-axlit-setfirst!| |Word|)
  ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))

(declare-prog
  (|C67-axlit-setrest!| |Word|)
  ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))

(declare-prog (|C68-axlit-empty| |Word|) ((|e1| |Env|)))

(declare-prog
  (|C69-axlit-empty?| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog
  (|C70-axlit-test| |Word|)
  ((|P0-x| |Word|) (|e1| |Env|)))

(declare-prog (|C71-axlit-axlit| |Word|) ((p0-s |Word|) (|e1| |Env|)))

(declare-prog
  (|C72-axlit-extend0| |Clos|)
  ((|P0-domain| |Word|) (|e1| |Env|)))

(declare-prog
  (|C73-axlit-lang-init| |Word|)
  ((|P0-idx| |SInt|) (|e1| |Env|)))

(declare-prog
  (|C74-axlit-axiom-init| |Word|)
  ((|P0-idx| |SInt|) (|e1| |Env|)))

(declare-type |G-axlit| |Clos|)

(declare-type |G-axlit_error_011667951| |Clos|)

(declare-type |G-axlit_integer_666767360| |Clos|)

(declare-type |G-axlit_BuiltinValue_091505407| |Word|)

(declare-type |G-axlit_BuiltinArray_589498848| |Word|)

(declare-type |G-axlit_String_636926304| |Word|)

(declare-type |G-axlit_String_050790629| |Word|)

(declare-type |G-axlit_Symbol_636926304| |Word|)

(declare-type |G-axlit_Symbol_738567780| |Word|)

(declare-type |G-axlit_SingleInteger_603316683| |Word|)

(declare-type |G-axlit_SingleInteger_1058045725| |Word|)

(declare-type |G-axlit_Integer_971403808| |Word|)

(declare-type |G-axlit_Integer_273754537| |Word|)

(declare-type |G-axlit_NonNegativeInteger_263513050| |Word|)

(declare-type |G-axlit_NonNegativeInteger_858745464| |Word|)

(declare-type |G-axlit_PositiveInteger_263513050| |Word|)

(declare-type |G-axlit_PositiveInteger_1048974412| |Word|)

(declare-type |G-axlit_DoubleFloat_083362422| |Word|)

(declare-type |G-axlit_DoubleFloat_325216460| |Word|)

(declare-type |G-axlit_Float_083362422| |Word|)

(declare-type |G-axlit_Float_440826770| |Word|)

(declare-type |G-axlit_Tuple_896539526| |Clos|)

(declare-type |G-axlit_Tuple_310792372| |Clos|)

(declare-type |G-axlit_List_533942053| |Clos|)

(declare-type |G-axlit_List_927796144| |Clos|)

(defspecials
  |G-axlit_List_927796144|
  |G-axlit_List_533942053|
  |G-axlit_Tuple_310792372|
  |G-axlit_Tuple_896539526|
  |G-axlit_Float_440826770|
  |G-axlit_Float_083362422|
  |G-axlit_DoubleFloat_325216460|
  |G-axlit_DoubleFloat_083362422|
  |G-axlit_PositiveInteger_1048974412|
  |G-axlit_PositiveInteger_263513050|
  |G-axlit_NonNegativeInteger_858745464|
  |G-axlit_NonNegativeInteger_263513050|
  |G-axlit_Integer_273754537|
  |G-axlit_Integer_971403808|
  |G-axlit_SingleInteger_1058045725|
  |G-axlit_SingleInteger_603316683|
  |G-axlit_Symbol_738567780|
  |G-axlit_Symbol_636926304|
  |G-axlit_String_050790629|
  |G-axlit_String_636926304|
  |G-axlit_BuiltinArray_589498848|
  |G-axlit_BuiltinValue_091505407|
  |G-axlit_integer_666767360|
  |G-axlit_error_011667951|)

(|DDecl|
  |Struct-axlit-5|
  (|size-0| |SInt|)
  (|nsize-1| |SInt|)
  (|values-2| |Word|))

(|DDecl|
  |Struct-axlit-8|
  (|set!-0| |Clos|)
  (|apply-1| |Clos|)
  (|#-2| |Clos|)
  (|new-3| |Clos|)
  (\-4 |SInt|))

(|DDecl| |Struct-axlit-9| (|string-0| |Clos|) (\-1 |SInt|))

(|DDecl|
  |Struct-axlit-10|
  (|string-0| |Clos|)
  (|coerce-1| |Clos|)
  (\-2 |SInt|))

(|DDecl|
  |Struct-axlit-11|
  (|spit-0| |Clos|)
  (|leq-1| |Clos|)
  (|dec-2| |Clos|)
  (|inc-3| |Clos|)
  (|one-4| |Clos|)
  (|zero-5| |Clos|)
  (|coerce-6| |Clos|)
  (|integer-7| |Clos|)
  (\-8 |SInt|))

(|DDecl| |Struct-axlit-12| (|integer-0| |Clos|) (\-1 |SInt|))

(|DDecl|
  |Struct-axlit-13|
  (|coerce-0| |Clos|)
  (|integer-1| |Clos|)
  (\-2 |SInt|))

(|DDecl|
  |Struct-axlit-14|
  (|coerce-0| |Clos|)
  (|integer-1| |Clos|)
  (\-2 |SInt|))

(|DDecl| |Struct-axlit-15| (|float-0| |Clos|) (\-1 |SInt|))

(|DDecl| |Struct-axlit-16| (|float-0| |Clos|) (\-1 |SInt|))

(|DDecl| |Struct-axlit-17| (|size-0| |SInt|) (|values-1| |Arr|))

(|DDecl| |Struct-axlit-18| (|found-0| |Word|) (|value-1| |Word|))

(|DDecl| |Struct-axlit-19| (|sz-0| |Word|) (|values-1| |Word|))

(|DDecl|
  |Struct-axlit-20|
  (|element-0| |Clos|)
  (|length-1| |Clos|)
  (\-2 |SInt|))

(|DDecl| |Struct-axlit-21| (t-0 |Word|))

(|DDecl| |Struct-axlit-22| (t-0 |Word|))

(|DDecl|
  |Struct-axlit-23|
  (|test-0| |Clos|)
  (|empty?-1| |Clos|)
  (|empty-2| |Clos|)
  (|setrest!-3| |Clos|)
  (|setfirst!-4| |Clos|)
  (|cons-5| |Clos|)
  (|rest-6| |Clos|)
  (|first-7| |Clos|)
  (|nil-8| |Word|)
  (|bracket-9| |Clos|)
  (\-10 |SInt|))

(|DDecl| |Struct-axlit-24| (s-0 |Word|))

(|DDecl| |Struct-axlit-25| (s-0 |Word|))

(|DDecl|
  |Struct-axlit-26|
  (|PositiveInteger-0| |Word|)
  (|NonNegativeInteger-1| |Word|)
  (|List-2| |Clos|)
  (|Tuple-3| |Clos|)
  (|SingleInteger-4| |Word|)
  (|Integer-5| |Word|)
  (|Float-6| |Word|)
  (|Symbol-7| |Word|)
  (|String-8| |Word|)
  (|DoubleFloat-9| |Word|)
  (\-10 |Word|)
  (\-11 |Word|)
  (\-12 |Word|)
  (\-13 |Word|)
  (\-14 |Bool|)
  (\-15 |Bool|))

(defprog
  ((|C0-axlit-axlit|) ((|e1| |Env|)))
  ((t0 |Clos|)
    (t1 |Clos|)
    (t2 |Arr|)
    (t3 |Arr|)
    (t4 |Record|)
    (t5 |Record|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-26| |Struct-axlit-26|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall| |G-runtime|)
  (setq |G-axlit| |G-noOperation|)
  (setq |G-axlit_error_011667951| (|Clos| |e0| |C1-axlit-error|))
  (setq |G-axlit_integer_666767360| (|Clos| |e0| |C2-axlit-integer|))
  (setq
    |G-axlit_BuiltinValue_091505407|
    (|CCall| |G-domainMake| (|Clos| |e0| |C3-axlit-addLevel0|)))
  (setq
    |G-axlit_BuiltinArray_589498848|
    (|CCall| |G-domainMake| (|Clos| |e0| |C5-axlit-addLevel0|)))
  (setq
    |G-axlit_String_636926304|
    (|CCall| |G-domainMake| (|Clos| |e0| |C11-axlit-addLevel0|)))
  (setq t0 (|Clos| |e0| |C74-axlit-axiom-init|))
  (setq
    |G-axlit_String_050790629|
    (|CCall| |G-extendMake| (|Clos| |e0| |C14-axlit-extend0|)))
  (setq
    |G-axlit_Symbol_636926304|
    (|CCall| |G-domainMake| (|Clos| |e0| |C15-axlit-addLevel0|)))
  (setq
    |G-axlit_Symbol_738567780|
    (|CCall| |G-extendMake| (|Clos| |e0| |C18-axlit-extend0|)))
  (setq
    |G-axlit_SingleInteger_603316683|
    (|CCall| |G-domainMake| (|Clos| |e0| |C19-axlit-addLevel0|)))
  (setq
    |G-axlit_SingleInteger_1058045725|
    (|CCall| |G-extendMake| (|Clos| |e0| |C29-axlit-extend0|)))
  (setq
    |G-axlit_Integer_971403808|
    (|CCall| |G-domainMake| (|Clos| |e0| |C30-axlit-addLevel0|)))
  (setq
    |G-axlit_Integer_273754537|
    (|CCall| |G-extendMake| (|Clos| |e0| |C33-axlit-extend0|)))
  (setq
    |G-axlit_NonNegativeInteger_263513050|
    (|CCall| |G-domainMake| (|Clos| |e0| |C34-axlit-addLevel0|)))
  (setq
    |G-axlit_NonNegativeInteger_858745464|
    (|CCall| |G-extendMake| (|Clos| |e0| |C38-axlit-extend0|)))
  (setq
    |G-axlit_PositiveInteger_263513050|
    (|CCall| |G-domainMake| (|Clos| |e0| |C39-axlit-addLevel0|)))
  (setq
    |G-axlit_PositiveInteger_1048974412|
    (|CCall| |G-extendMake| (|Clos| |e0| |C43-axlit-extend0|)))
  (setq
    |G-axlit_DoubleFloat_083362422|
    (|CCall| |G-domainMake| (|Clos| |e0| |C44-axlit-addLevel0|)))
  (setq
    |G-axlit_DoubleFloat_325216460|
    (|CCall| |G-extendMake| (|Clos| |e0| |C47-axlit-extend0|)))
  (setq
    |G-axlit_Float_083362422|
    (|CCall| |G-domainMake| (|Clos| |e0| |C48-axlit-addLevel0|)))
  (setq
    |G-axlit_Float_440826770|
    (|CCall| |G-extendMake| (|Clos| |e0| |C51-axlit-extend0|)))
  (|SetLex| |Struct-axlit-26--10| 10 |l0| nil)
  (setq |G-axlit_Tuple_896539526| (|Clos| |e0| |C52-axlit-Tuple|))
  (setq t1 (|Clos| |e0| |C73-axlit-lang-init|))
  (|SetLex| |Struct-axlit-26--11| 11 |l0| nil)
  (setq |G-axlit_Tuple_310792372| (|Clos| |e0| |C57-axlit-axlit|))
  (|SetLex| |Struct-axlit-26--12| 12 |l0| nil)
  (setq |G-axlit_List_533942053| (|Clos| |e0| |C59-axlit-List|))
  (|SetLex| |Struct-axlit-26--13| 13 |l0| nil)
  (setq |G-axlit_List_927796144| (|Clos| |e0| |C71-axlit-axlit|))
  (|SetLex| |Struct-axlit-26--14| 14 |l0| (the |Bool| nil))
  (|SetLex| |Struct-axlit-26--15| 15 |l0| (the |Bool| nil))
  (setq t2 (|ANew| |Word| (the |SInt| 26)))
  (setq t3 (|ANew| |Word| (the |SInt| 26)))
  (|SetAElt| t2 (the |SInt| 0) (the |SInt| 770345191))
  (|SetAElt| t3 (the |SInt| 0) (|MakeLit| "coerce"))
  (|SetAElt| t2 (the |SInt| 1) (the |SInt| 318722677))
  (|SetAElt| t3 (the |SInt| 1) (|MakeLit| "inc"))
  (|SetAElt| t2 (the |SInt| 2) (the |SInt| 585283853))
  (|SetAElt| t3 (the |SInt| 2) (|MakeLit| "string"))
  (|SetAElt| t2 (the |SInt| 3) (the |SInt| 306472243))
  (|SetAElt| t3 (the |SInt| 3) (|MakeLit| "apply"))
  (|SetAElt| t2 (the |SInt| 4) (the |SInt| 357262396))
  (|SetAElt| t3 (the |SInt| 4) (|MakeLit| "empty"))
  (|SetAElt| t2 (the |SInt| 5) (the |SInt| 865800279))
  (|SetAElt| t3 (the |SInt| 5) (|MakeLit| "cons"))
  (|SetAElt| t2 (the |SInt| 6) (the |SInt| 44638651))
  (|SetAElt| t3 (the |SInt| 6) (|MakeLit| "bracket"))
  (|SetAElt| t2 (the |SInt| 7) (the |SInt| 474568739))
  (|SetAElt| t3 (the |SInt| 7) (|MakeLit| "float"))
  (|SetAElt| t2 (the |SInt| 8) (the |SInt| 715582562))
  (|SetAElt| t3 (the |SInt| 8) (|MakeLit| "rest"))
  (|SetAElt| t2 (the |SInt| 9) (the |SInt| 318395261))
  (|SetAElt| t3 (the |SInt| 9) (|MakeLit| "leq"))
  (|SetAElt| t2 (the |SInt| 10) (the |SInt| 200076))
  (|SetAElt| t3 (the |SInt| 10) (|MakeLit| "#"))
  (|SetAElt| t2 (the |SInt| 11) (the |SInt| 87474803))
  (|SetAElt| t3 (the |SInt| 11) (|MakeLit| "setrest!"))
  (|SetAElt| t2 (the |SInt| 12) (the |SInt| 4716358))
  (|SetAElt| t3 (the |SInt| 12) (|MakeLit| "setfirst!"))
  (|SetAElt| t2 (the |SInt| 13) (the |SInt| 379591369))
  (|SetAElt| t3 (the |SInt| 13) (|MakeLit| "element"))
  (|SetAElt| t2 (the |SInt| 14) (the |SInt| 477900237))
  (|SetAElt| t3 (the |SInt| 14) (|MakeLit| "integer"))
  (|SetAElt| t2 (the |SInt| 15) (the |SInt| 316826471))
  (|SetAElt| t3 (the |SInt| 15) (|MakeLit| "dec"))
  (|SetAElt| t2 (the |SInt| 16) (the |SInt| 55906833))
  (|SetAElt| t3 (the |SInt| 16) (|MakeLit| "set!"))
  (|SetAElt| t2 (the |SInt| 17) (the |SInt| 5509732))
  (|SetAElt| t3 (the |SInt| 17) (|MakeLit| "test"))
  (|SetAElt| t2 (the |SInt| 18) (the |SInt| 61672804))
  (|SetAElt| t3 (the |SInt| 18) (|MakeLit| "spit"))
  (|SetAElt| t2 (the |SInt| 19) (the |SInt| 318528389))
  (|SetAElt| t3 (the |SInt| 19) (|MakeLit| "new"))
  (|SetAElt| t2 (the |SInt| 20) (the |SInt| 318525310))
  (|SetAElt| t3 (the |SInt| 20) (|MakeLit| "nil"))
  (|SetAElt| t2 (the |SInt| 21) (the |SInt| 437828088))
  (|SetAElt| t3 (the |SInt| 21) (|MakeLit| "length"))
  (|SetAElt| t2 (the |SInt| 22) (the |SInt| 581887332))
  (|SetAElt| t3 (the |SInt| 22) (|MakeLit| "zero"))
  (|SetAElt| t2 (the |SInt| 23) (the |SInt| 506619364))
  (|SetAElt| t3 (the |SInt| 23) (|MakeLit| "empty?"))
  (|SetAElt| t2 (the |SInt| 24) (the |SInt| 682776373))
  (|SetAElt| t3 (the |SInt| 24) (|MakeLit| "first"))
  (|SetAElt| t2 (the |SInt| 25) (the |SInt| 318069373))
  (|SetAElt| t3 (the |SInt| 25) (|MakeLit| "one"))
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 26))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 26))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t2)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 26))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 26))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t3)
  (|CCall| |G-rtAddStrings| t4 t5)
  (|SetLex|
    |Struct-axlit-26-String-8|
    8
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 0)))
  (|SetLex|
    |Struct-axlit-26-Symbol-7|
    7
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 1)))
  (|SetLex|
    |Struct-axlit-26-SingleInteger-4|
    4
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 3)))
  (|SetLex|
    |Struct-axlit-26-Integer-5|
    5
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 4)))
  (|SetLex|
    |Struct-axlit-26-NonNegativeInteger-1|
    1
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 5)))
  (|SetLex|
    |Struct-axlit-26-PositiveInteger-0|
    0
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 6)))
  (|SetLex|
    |Struct-axlit-26-DoubleFloat-9|
    9
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 7)))
  (|SetLex|
    |Struct-axlit-26-Float-6|
    6
    |l0|
    (|CCall| |G-rtLazyDomFrInit| t0 (the |SInt| 8)))
  (|SetLex|
    |Struct-axlit-26-Tuple-3|
    3
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t1 (the |SInt| 0))))
  (|SetLex|
    |Struct-axlit-26-List-2|
    2
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedInit!| t0 (the |SInt| 9))))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C52-axlit-Tuple|))
    (the |SInt| 617884183))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C57-axlit-axlit|))
    (the |SInt| 617884183))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C59-axlit-List|))
    (the |SInt| 144194112))
  (|SetProgHashCode|
    (|ClosFun| (|Clos| |e0| |C71-axlit-axlit|))
    (the |SInt| 144194112))
  (block-return |C0-axlit-axlit| ()))

(defprog
  ((|C1-axlit-error| |Word|) ((|P0-s| |Word|) (|e1| |Env|)))
  ()
  (block-return |C1-axlit-error| (|AXL-error| |P0-s|)))

(defprog
  ((|C2-axlit-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C2-axlit-integer| |P0-l|))

(defprog
  ((|C3-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "BuiltinValue")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 236438208))
  (block-return |C3-axlit-addLevel0| (|Clos| |e0| |C4-axlit-addLevel1|)))

(defprog
  ((|C4-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|))
  (setq t0 (|ANew| |SInt| (the |SInt| 0)))
  (setq t1 (|ANew| |SInt| (the |SInt| 0)))
  (setq t2 (|ANew| |Word| (the |SInt| 0)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 0))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (block-return |C4-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C5-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "BuiltinArray")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 124184002))
  (block-return |C5-axlit-addLevel0| (|Clos| |e0| |C6-axlit-addLevel1|)))

(defprog
  ((|C6-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-8| |Struct-axlit-8|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 4)))
  (setq t1 (|ANew| |SInt| (the |SInt| 4)))
  (setq t2 (|ANew| |Word| (the |SInt| 4)))
  (|SetLex| |Struct-axlit-8--4| 4 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-8-new-3|
    3
    |l0|
    (|Clos| |e0| |C7-axlit-new|))
  (|SetLex| |Struct-axlit-8-#-2| 2 |l0| (|Clos| |e0| |C8-axlit-#|))
  (|SetLex|
    |Struct-axlit-8-apply-1|
    1
    |l0|
    (|Clos| |e0| |C9-axlit-apply|))
  (|SetLex|
    |Struct-axlit-8-set!-0|
    0
    |l0|
    (|Clos| |e0| |C10-axlit-set!|))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 4))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 318528389))
  (|SetAElt|
    t1
    (the |SInt| 0)
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-8--4| 4 |l0|)
      (the |SInt| 974156096)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-8-new-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 200076))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-8--4| 4 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t7 (|SIntAnd| t6 (the |SInt| 16777215)))
  (setq t8 (|SIntShiftUp| t7 (the |SInt| 6)))
  (setq
    t9
    (|SIntPlusMod| (the |SInt| 142471813) t8 (the |SInt| 1073741789)))
  (|SetAElt| t1 (the |SInt| 1) t9)
  (|SetAElt| t2 (the |SInt| 1) (|Lex| |Struct-axlit-8-#-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 306472243))
  (setq t10 (|SIntAnd| t9 (the |SInt| 16777215)))
  (setq t11 (|SIntShiftUp| t10 (the |SInt| 6)))
  (setq
    t12
    (|SIntPlusMod| (the |SInt| 236438208) t11 (the |SInt| 1073741789)))
  (|SetAElt| t1 (the |SInt| 2) t12)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axlit-8-apply-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 55906833))
  (|SetAElt| t1 (the |SInt| 3) t12)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axlit-8-set!-0| 0 |l0|))
  (block-return |C6-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C7-axlit-new| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C7-axlit-new| (|AXL-arrayNew| |P0-n|)))

(defprog
  ((|C8-axlit-#| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C8-axlit-#| (|AXL-arraySize| |P0-x|)))

(defprog
  ((|C9-axlit-apply| |Word|)
    ((|P0-x| |Word|) (|P1-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C9-axlit-apply| (|AXL-arrayRef| |P0-x| |P1-n|)))

(defprog
  ((|C10-axlit-set!|)
    ((|P0-x| |Word|) (|P1-n| |Word|) (|P2-v| |Word|) (|e1| |Env|)))
  ()
  (|AXL-arraySet| |P0-x| |P1-n| |P2-v|)
  (block-return |C10-axlit-set!| ()))

(defprog
  ((|C11-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "String")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 585242861))
  (block-return
    |C11-axlit-addLevel0|
    (|Clos| |e0| |C12-axlit-addLevel1|)))

(defprog
  ((|C12-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-9| |Struct-axlit-9|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (|SetLex| |Struct-axlit-9--1| 1 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-9-string-0|
    0
    |l0|
    (|Clos| |e0| |C13-axlit-string|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-9--1| 1 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 585283853))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-9-string-0| 0 |l0|))
  (block-return |C12-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C13-axlit-string| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C13-axlit-string| (|AXL-LiteralToString| |P0-l|)))

(defprog
  ((|C14-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-String-8| 8 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_String_636926304|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C14-axlit-extend0| |P0-domain|))

(defprog
  ((|C15-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "Symbol")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 162693356))
  (block-return
    |C15-axlit-addLevel0|
    (|Clos| |e0| |C16-axlit-addLevel1|)))

(defprog
  ((|C16-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |Word|)
    (t7 |SInt|)
    (t8 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-10| |Struct-axlit-10|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (setq t6 (|CCall| |G-domainMakeDispatch| |P0-domain|))
  (|SetLex| |Struct-axlit-10--2| 2 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-10-string-0|
    0
    |l0|
    (|Clos| |e0| |C17-axlit-string|))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-10--2| 2 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-10--2| 2 |l0|)
      (the |SInt| 320473920)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 585283853))
  (|SetAElt| t1 (the |SInt| 0) t7)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-10-string-0| 0 |l0|))
  (|SetLex|
    |Struct-axlit-10-coerce-1|
    1
    |l0|
    (|CCall|
      |G-stdGetWordRetWord0|
      (|CCall| |G-rtDelayedGetExport!| t6 (the |SInt| 770345191) t8)))
  (block-return |C16-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C17-axlit-string| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (block-return
    |C17-axlit-string|
    (|CCall|
      (|Lex| |Struct-axlit-10-coerce-1| 1 |l1|)
      (|AXL-LiteralToString| |P0-l|))))

(defprog
  ((|C18-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-Symbol-7| 7 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_Symbol_636926304|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C18-axlit-extend0| |P0-domain|))

(defprog
  ((|C19-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "SingleInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 142471813))
  (block-return
    |C19-axlit-addLevel0|
    (|Clos| |e0| |C20-axlit-addLevel1|)))

(defprog
  ((|C20-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-11| |Struct-axlit-11|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 8)))
  (setq t1 (|ANew| |SInt| (the |SInt| 8)))
  (setq t2 (|ANew| |Word| (the |SInt| 8)))
  (|SetLex| |Struct-axlit-11--8| 8 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-11-integer-7|
    7
    |l0|
    (|Clos| |e0| |C21-axlit-integer|))
  (|SetLex|
    |Struct-axlit-11-coerce-6|
    6
    |l0|
    (|Clos| |e0| |C22-axlit-coerce|))
  (|SetLex|
    |Struct-axlit-11-zero-5|
    5
    |l0|
    (|Clos| |e0| |C23-axlit-zero|))
  (|SetLex|
    |Struct-axlit-11-one-4|
    4
    |l0|
    (|Clos| |e0| |C24-axlit-one|))
  (|SetLex|
    |Struct-axlit-11-inc-3|
    3
    |l0|
    (|Clos| |e0| |C25-axlit-inc|))
  (|SetLex|
    |Struct-axlit-11-dec-2|
    2
    |l0|
    (|Clos| |e0| |C26-axlit-dec|))
  (|SetLex|
    |Struct-axlit-11-leq-1|
    1
    |l0|
    (|Clos| |e0| |C27-axlit-leq|))
  (|SetLex|
    |Struct-axlit-11-spit-0|
    0
    |l0|
    (|Clos| |e0| |C28-axlit-spit|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-11--8| 8 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-11--8| 8 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t9 (|SIntAnd| t8 (the |SInt| 16777215)))
  (setq t10 (|SIntShiftUp| t9 (the |SInt| 6)))
  (setq
    t11
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-11--8| 8 |l0|)
      t10
      (the |SInt| 1073741789)))
  (setq
    t7
    (|SIntPlusMod|
      (the |SInt| 740244383)
      (|SIntShiftUp| (|SIntAnd| t11 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 8))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-11-integer-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 1)
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-11--8| 8 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axlit-11-coerce-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 581887332))
  (|SetAElt| t1 (the |SInt| 2) t8)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axlit-11-zero-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 318069373))
  (|SetAElt| t1 (the |SInt| 3) t8)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axlit-11-one-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 318722677))
  (|SetAElt| t1 (the |SInt| 4) t11)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axlit-11-inc-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 316826471))
  (|SetAElt| t1 (the |SInt| 5) t11)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axlit-11-dec-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 318395261))
  (|SetAElt| t1 (the |SInt| 6) t7)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axlit-11-leq-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 61672804))
  (|SetAElt| t1 (the |SInt| 7) t8)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axlit-11-spit-0| 0 |l0|))
  (block-return |C20-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C21-axlit-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C21-axlit-integer|
    (|AXL-LiteralToSingleInteger| |P0-l|)))

(defprog
  ((|C22-axlit-coerce| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C22-axlit-coerce| |P0-n|))

(defprog
  ((|C23-axlit-zero| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C23-axlit-zero| (|AXL-zerofnSingleInteger|)))

(defprog
  ((|C24-axlit-one| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C24-axlit-one| (|AXL-onefnSingleInteger|)))

(defprog
  ((|C25-axlit-inc| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C25-axlit-inc| (|AXL-incSingleInteger| |P0-n|)))

(defprog
  ((|C26-axlit-dec| |Word|) ((|P0-n| |Word|) (|e1| |Env|)))
  ()
  (block-return |C26-axlit-dec| (|AXL-decSingleInteger| |P0-n|)))

(defprog
  ((|C27-axlit-leq| |Word|)
    ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))
  ()
  (block-return |C27-axlit-leq| (|AXL-leSingleInteger| |P0-x| |P1-y|)))

(defprog
  ((|C28-axlit-spit|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (|AXL-spitSInt| |P0-x|)
  (block-return |C28-axlit-spit| ()))

(defprog
  ((|C29-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-SingleInteger-4| 4 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_SingleInteger_603316683|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C29-axlit-extend0| |P0-domain|))

(defprog
  ((|C30-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "Integer")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 484208045))
  (block-return
    |C30-axlit-addLevel0|
    (|Clos| |e0| |C31-axlit-addLevel1|)))

(defprog
  ((|C31-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-12| |Struct-axlit-12|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (|SetLex| |Struct-axlit-12--1| 1 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-12-integer-0|
    0
    |l0|
    (|Clos| |e0| |C32-axlit-integer|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-12--1| 1 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-12-integer-0| 0 |l0|))
  (block-return |C31-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C32-axlit-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C32-axlit-integer| (|AXL-LiteralToInteger| |P0-l|)))

(defprog
  ((|C33-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-Integer-5| 5 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_Integer_971403808|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C33-axlit-extend0| |P0-domain|))

(defprog
  ((|C34-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "NonNegativeInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 172927374))
  (block-return
    |C34-axlit-addLevel0|
    (|Clos| |e0| |C35-axlit-addLevel1|)))

(defprog
  ((|C35-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-13| |Struct-axlit-13|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 2)))
  (setq t1 (|ANew| |SInt| (the |SInt| 2)))
  (setq t2 (|ANew| |Word| (the |SInt| 2)))
  (|SetLex| |Struct-axlit-13--2| 2 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-13-integer-1|
    1
    |l0|
    (|Clos| |e0| |C36-axlit-integer|))
  (|SetLex|
    |Struct-axlit-13-coerce-0|
    0
    |l0|
    (|Clos| |e0| |C37-axlit-coerce|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-13--2| 2 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-13-integer-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 1)
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-13--2| 2 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axlit-13-coerce-0| 0 |l0|))
  (block-return |C35-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C36-axlit-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|) (t2 |Word|))
  (tagbody
    (setq t2 (|AXL-LiteralToInteger| |P0-l|))
    (when (|AXL-IntegerIsNonNegative| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C36-axlit-integer| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C37-axlit-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsNonNegative| |P0-i|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a non-negative integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C37-axlit-coerce| t0)
    |Lab0|
    (setq t0 |P0-i|)
    (go |Lab1|)))

(defprog
  ((|C38-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-NonNegativeInteger-1| 1 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_NonNegativeInteger_263513050|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C38-axlit-extend0| |P0-domain|))

(defprog
  ((|C39-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "PositiveInteger")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 965468232))
  (block-return
    |C39-axlit-addLevel0|
    (|Clos| |e0| |C40-axlit-addLevel1|)))

(defprog
  ((|C40-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-14| |Struct-axlit-14|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 2)))
  (setq t1 (|ANew| |SInt| (the |SInt| 2)))
  (setq t2 (|ANew| |Word| (the |SInt| 2)))
  (|SetLex| |Struct-axlit-14--2| 2 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-14-integer-1|
    1
    |l0|
    (|Clos| |e0| |C41-axlit-integer|))
  (|SetLex|
    |Struct-axlit-14-coerce-0|
    0
    |l0|
    (|Clos| |e0| |C42-axlit-coerce|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-14--2| 2 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 477900237))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-14-integer-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 770345191))
  (|SetAElt|
    t1
    (the |SInt| 1)
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-14--2| 2 |l0|)
      (the |SInt| 296696640)
      (the |SInt| 1073741789)))
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axlit-14-coerce-0| 0 |l0|))
  (block-return |C40-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C41-axlit-integer| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|) (t2 |Word|))
  (tagbody
    (setq t2 (|AXL-LiteralToInteger| |P0-l|))
    (when (|AXL-IntegerIsPositive| t2) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C41-axlit-integer| t0)
    |Lab0|
    (setq t0 t2)
    (go |Lab1|)))

(defprog
  ((|C42-axlit-coerce| |Word|) ((|P0-i| |Word|) (|e1| |Env|)))
  ((t0 |Word|) (t1 |Word|))
  (tagbody
    (when (|AXL-IntegerIsPositive| |P0-i|) (go |Lab0|))
    (setq
      t1
      (|AXL-LiteralToString| (|MakeLit| "Need a positive integer")))
    (|AXL-error| t1)
    |Lab1|
    (block-return |C42-axlit-coerce| t0)
    |Lab0|
    (setq t0 |P0-i|)
    (go |Lab1|)))

(defprog
  ((|C43-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-PositiveInteger-0| 0 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_PositiveInteger_263513050|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C43-axlit-extend0| |P0-domain|))

(defprog
  ((|C44-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "DoubleFloat")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 813025748))
  (block-return
    |C44-axlit-addLevel0|
    (|Clos| |e0| |C45-axlit-addLevel1|)))

(defprog
  ((|C45-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-15| |Struct-axlit-15|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (|SetLex| |Struct-axlit-15--1| 1 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-15-float-0|
    0
    |l0|
    (|Clos| |e0| |C46-axlit-float|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-15--1| 1 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 474568739))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-15-float-0| 0 |l0|))
  (block-return |C45-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C46-axlit-float| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return |C46-axlit-float| (|AXL-LiteralToDoubleFloat| |P0-l|)))

(defprog
  ((|C47-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-DoubleFloat-9| 9 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_DoubleFloat_083362422|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C47-axlit-extend0| |P0-domain|))

(defprog
  ((|C48-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall| |G-rtConstNameFn| (|MakeLit| "Float")))
  (|CCall| |G-domainAddHash!| |P0-domain| (the |SInt| 533207043))
  (block-return
    |C48-axlit-addLevel0|
    (|Clos| |e0| |C49-axlit-addLevel1|)))

(defprog
  ((|C49-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-16| |Struct-axlit-16|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq t0 (|ANew| |SInt| (the |SInt| 1)))
  (setq t1 (|ANew| |SInt| (the |SInt| 1)))
  (setq t2 (|ANew| |Word| (the |SInt| 1)))
  (|SetLex| |Struct-axlit-16--1| 1 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-16-float-0|
    0
    |l0|
    (|Clos| |e0| |C50-axlit-float|))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-16--1| 1 |l0|)
      (the |SInt| 332724992)
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 1))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 474568739))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-16-float-0| 0 |l0|))
  (block-return |C49-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C50-axlit-float| |Word|) ((|P0-l| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C50-axlit-float|
    (|AXL-StringToFloat| (|AXL-LiteralToString| |P0-l|))))

(defprog
  ((|C51-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|Lex| |Struct-axlit-26-Float-6| 6 |l1|))
  (|SetAElt| t0 (the |SInt| 0) |G-axlit_Float_083362422|)
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C51-axlit-extend0| |P0-domain|))

(defprog
  ((|C52-axlit-Tuple| |Word|) ((p0-t |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-21| |Struct-axlit-21|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axlit-21-T-0| 0 |l0| p0-t)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axlit-17|))
    (|SetRElt| |Struct-axlit-17| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axlit-17| |values| 1 t1 t0)
    (when (|PtrIsNil| (|Lex| |Struct-axlit-26--10| 10 |l1|)) (go |Lab3|))
    |Lab1|
    (|SetAElt| t0 (the |SInt| 0) (|Lex| |Struct-axlit-21-T-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall| |G-rtCacheCheck| (|Lex| |Struct-axlit-26--10| 10 |l1|) t1))
    (when t3 (go |Lab0|))
    (setq t2 (|CCall| |G-domainMake| (|Clos| |e0| |C53-axlit-addLevel0|)))
    (setq
      t2
      (|CCall| |G-rtCacheAdd| (|Lex| |Struct-axlit-26--10| 10 |l1|) t1 t2))
    |Lab0|
    (block-return |C52-axlit-Tuple| t2)
    |Lab3|
    (|SetLex|
      |Struct-axlit-26--10|
      10
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C53-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "Tuple")
      (|Lex| |Struct-axlit-21-T-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axlit-21-T-0| 0 |l1|))
      (the |SInt| 889882048)
      (the |SInt| 1073741789)))
  (block-return
    |C53-axlit-addLevel0|
    (|Clos| |e0| |C54-axlit-addLevel1|)))

(defprog
  ((|C54-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-20| |Struct-axlit-20|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |SInt| (the |SInt| 2)))
  (setq t1 (|ANew| |SInt| (the |SInt| 2)))
  (setq t2 (|ANew| |Word| (the |SInt| 2)))
  (|SetLex| |Struct-axlit-20--2| 2 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-20-length-1|
    1
    |l0|
    (|Clos| |e0| |C55-axlit-length|))
  (|SetLex|
    |Struct-axlit-20-element-0|
    0
    |l0|
    (|Clos| |e0| |C56-axlit-element|))
  (setq
    t7
    (|CCall| |G-domainHash!| (|Lex| |Struct-axlit-21-T-0| 0 |l2|)))
  (setq
    t8
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-20--2| 2 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t9 (|SIntAnd| t8 (the |SInt| 16777215)))
  (setq t10 (|SIntShiftUp| t9 (the |SInt| 6)))
  (setq
    t11
    (|SIntPlusMod| (the |SInt| 142471813) t10 (the |SInt| 1073741789)))
  (setq
    t6
    (|SIntPlusMod|
      t7
      (|SIntShiftUp| (|SIntAnd| t11 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 437828088))
  (|SetAElt| t1 (the |SInt| 0) t11)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-20-length-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 379591369))
  (|SetAElt| t1 (the |SInt| 1) t6)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axlit-20-element-0| 0 |l0|))
  (block-return |C54-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C55-axlit-length| |Word|) ((|P0-t| |Word|) (|e1| |Env|)))
  ()
  (block-return
    |C55-axlit-length|
    (|RElt| |Struct-axlit-19| |sz| 0 |P0-t|)))

(defprog
  ((|C56-axlit-element| |Word|)
    ((|P0-t| |Word|) (|P1-n| |Word|) (|e1| |Env|)))
  ((t0 |Word|))
  (setq t0 (|AXL-decSingleInteger| |P1-n|))
  (block-return
    |C56-axlit-element|
    (|AXL-arrayRef| (|RElt| |Struct-axlit-19| |values| 1 |P0-t|) t0)))

(defprog
  ((|C57-axlit-axlit| |Word|) ((p0-t |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-22| |Struct-axlit-22|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axlit-22-T-0| 0 |l0| p0-t)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axlit-17|))
    (|SetRElt| |Struct-axlit-17| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axlit-17| |values| 1 t2 t1)
    (when (|PtrIsNil| (|Lex| |Struct-axlit-26--11| 11 |l1|)) (go |Lab3|))
    |Lab1|
    (|SetAElt| t1 (the |SInt| 0) (|Lex| |Struct-axlit-22-T-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall| |G-rtCacheCheck| (|Lex| |Struct-axlit-26--11| 11 |l1|) t2))
    (when t4 (go |Lab0|))
    (setq t0 (|CCall| |G-extendMake| (|Clos| |e0| |C58-axlit-extend0|)))
    (setq
      t3
      (|CCall| |G-rtCacheAdd| (|Lex| |Struct-axlit-26--11| 11 |l1|) t2 t0))
    |Lab0|
    (block-return |C57-axlit-axlit| t3)
    |Lab3|
    (|SetLex|
      |Struct-axlit-26--11|
      11
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C58-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axlit-26-Tuple-3| 3 |l2|)
      (|Lex| |Struct-axlit-22-T-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axlit_Tuple_896539526|
      (|Lex| |Struct-axlit-22-T-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C58-axlit-extend0| |P0-domain|))

(defprog
  ((|C59-axlit-List| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Record|)
    (t2 |Word|)
    (t3 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-24| |Struct-axlit-24|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axlit-24-S-0| 0 |l0| p0-s)
    (setq t0 (|ANew| |Word| (the |SInt| 1)))
    (setq t1 (|RNew| |Struct-axlit-17|))
    (|SetRElt| |Struct-axlit-17| |size| 0 t1 (the |SInt| 1))
    (|SetRElt| |Struct-axlit-17| |values| 1 t1 t0)
    (when (|PtrIsNil| (|Lex| |Struct-axlit-26--12| 12 |l1|)) (go |Lab3|))
    |Lab1|
    (|SetAElt| t0 (the |SInt| 0) (|Lex| |Struct-axlit-24-S-0| 0 |l0|))
    (multiple-value-setq
      (t2 t3)
      (|CCall| |G-rtCacheCheck| (|Lex| |Struct-axlit-26--12| 12 |l1|) t1))
    (when t3 (go |Lab0|))
    (setq t2 (|CCall| |G-domainMake| (|Clos| |e0| |C60-axlit-addLevel0|)))
    (setq
      t2
      (|CCall| |G-rtCacheAdd| (|Lex| |Struct-axlit-26--12| 12 |l1|) t1 t2))
    |Lab0|
    (block-return |C59-axlit-List| t2)
    |Lab3|
    (|SetLex|
      |Struct-axlit-26--12|
      12
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C60-axlit-addLevel0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((|l0| |Level|) (|e0| |Env|) (|l1| |Level|))
  (setq |l0| nil)
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (|CCall|
    |G-domainAddNameFn!|
    |P0-domain|
    (|CCall|
      |G-rtSingleParamNameFn|
      (|MakeLit| "List")
      (|Lex| |Struct-axlit-24-S-0| 0 |l1|)))
  (|CCall|
    |G-domainAddHash!|
    |P0-domain|
    (|SIntPlusMod|
      (|CCall| |G-domainHash!| (|Lex| |Struct-axlit-24-S-0| 0 |l1|))
      (the |SInt| 638488576)
      (the |SInt| 1073741789)))
  (block-return
    |C60-axlit-addLevel0|
    (|Clos| |e0| |C61-axlit-addLevel1|)))

(defprog
  ((|C61-axlit-addLevel1| |Word|)
    ((|P0-domain| |Word|) (|P1-hashcode| |Word|) (|e1| |Env|)))
  ((t0 |Arr|)
    (t1 |Arr|)
    (t2 |Arr|)
    (t3 |Record|)
    (t4 |Record|)
    (t5 |Record|)
    (t6 |SInt|)
    (t7 |SInt|)
    (t8 |SInt|)
    (t9 |SInt|)
    (t10 |SInt|)
    (t11 |SInt|)
    (t12 |SInt|)
    (t13 |SInt|)
    (t14 |SInt|)
    (t15 |SInt|)
    (t16 |SInt|)
    (t17 |SInt|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|e2| |Env|)
    (|l2| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-23| |Struct-axlit-23|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |SInt| (the |SInt| 10)))
  (setq t1 (|ANew| |SInt| (the |SInt| 10)))
  (setq t2 (|ANew| |Word| (the |SInt| 10)))
  (|SetLex| |Struct-axlit-23--10| 10 |l0| |P1-hashcode|)
  (|SetLex|
    |Struct-axlit-23-bracket-9|
    9
    |l0|
    (|Clos| |e0| |C62-axlit-bracket|))
  (|SetLex|
    |Struct-axlit-23-first-7|
    7
    |l0|
    (|Clos| |e0| |C63-axlit-first|))
  (|SetLex|
    |Struct-axlit-23-rest-6|
    6
    |l0|
    (|Clos| |e0| |C64-axlit-rest|))
  (|SetLex|
    |Struct-axlit-23-cons-5|
    5
    |l0|
    (|Clos| |e0| |C65-axlit-cons|))
  (|SetLex|
    |Struct-axlit-23-setfirst!-4|
    4
    |l0|
    (|Clos| |e0| |C66-axlit-setfirst!|))
  (|SetLex|
    |Struct-axlit-23-setrest!-3|
    3
    |l0|
    (|Clos| |e0| |C67-axlit-setrest!|))
  (|SetLex|
    |Struct-axlit-23-empty-2|
    2
    |l0|
    (|Clos| |e0| |C68-axlit-empty|))
  (|SetLex|
    |Struct-axlit-23-empty?-1|
    1
    |l0|
    (|Clos| |e0| |C69-axlit-empty?|))
  (|SetLex|
    |Struct-axlit-23-test-0|
    0
    |l0|
    (|Clos| |e0| |C70-axlit-test|))
  (setq
    t12
    (|CCall| |G-domainHash!| (|Lex| |Struct-axlit-24-S-0| 0 |l2|)))
  (setq
    t6
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-23--10| 10 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            (|SIntPlusMod| t12 (the |SInt| 889882048) (the |SInt| 1073741789))
            (the |SInt| 74075968)
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t13
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-23--10| 10 |l0|)
      (the |SInt| 74075968)
      (the |SInt| 1073741789)))
  (setq t14 (|SIntAnd| t13 (the |SInt| 16777215)))
  (setq t15 (|SIntShiftUp| t14 (the |SInt| 6)))
  (setq t16 (|SIntPlusMod| t12 t15 (the |SInt| 1073741789)))
  (setq
    t17
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-23--10| 10 |l0|)
      t15
      (the |SInt| 1073741789)))
  (setq
    t7
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-23--10| 10 |l0|)
      (|SIntShiftUp|
        (|SIntAnd|
          (|SIntPlusMod|
            (|Lex| |Struct-axlit-23--10| 10 |l0|)
            (|SIntShiftUp|
              (|SIntAnd|
                (|SIntPlusMod| t12 (the |SInt| 74075968) (the |SInt| 1073741789))
                (the |SInt| 16777215))
              (the |SInt| 6))
            (the |SInt| 1073741789))
          (the |SInt| 16777215))
        (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t8
    (|SIntPlusMod|
      t12
      (|SIntShiftUp| (|SIntAnd| t16 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t9
    (|SIntPlusMod|
      (|Lex| |Struct-axlit-23--10| 10 |l0|)
      (|SIntShiftUp| (|SIntAnd| t17 (the |SInt| 16777215)) (the |SInt| 6))
      (the |SInt| 1073741789)))
  (setq
    t10
    (|SIntPlusMod| (the |SInt| 740244383) t15 (the |SInt| 1073741789)))
  (setq t11 (|Lex| |Struct-axlit-23--10| 10 |l0|))
  (setq t3 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t3 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t3 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |values| 2 t3 t0)
  (setq t4 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t4 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t4 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |values| 2 t4 t1)
  (setq t5 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t5 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t5 (the |SInt| 10))
  (|SetRElt| |Struct-axlit-5| |values| 2 t5 t2)
  (|CCall| |G-domainAddExports!| |P0-domain| t3 t4 t5)
  (|SetAElt| t0 (the |SInt| 0) (the |SInt| 44638651))
  (|SetAElt| t1 (the |SInt| 0) t6)
  (|SetAElt|
    t2
    (the |SInt| 0)
    (|Lex| |Struct-axlit-23-bracket-9| 9 |l0|))
  (|SetAElt| t0 (the |SInt| 1) (the |SInt| 682776373))
  (|SetAElt| t1 (the |SInt| 1) t16)
  (|SetAElt|
    t2
    (the |SInt| 1)
    (|Lex| |Struct-axlit-23-first-7| 7 |l0|))
  (|SetAElt| t0 (the |SInt| 2) (the |SInt| 715582562))
  (|SetAElt| t1 (the |SInt| 2) t17)
  (|SetAElt|
    t2
    (the |SInt| 2)
    (|Lex| |Struct-axlit-23-rest-6| 6 |l0|))
  (|SetAElt| t0 (the |SInt| 3) (the |SInt| 865800279))
  (|SetAElt| t1 (the |SInt| 3) t7)
  (|SetAElt|
    t2
    (the |SInt| 3)
    (|Lex| |Struct-axlit-23-cons-5| 5 |l0|))
  (|SetAElt| t0 (the |SInt| 4) (the |SInt| 4716358))
  (|SetAElt| t1 (the |SInt| 4) t8)
  (|SetAElt|
    t2
    (the |SInt| 4)
    (|Lex| |Struct-axlit-23-setfirst!-4| 4 |l0|))
  (|SetAElt| t0 (the |SInt| 5) (the |SInt| 87474803))
  (|SetAElt| t1 (the |SInt| 5) t9)
  (|SetAElt|
    t2
    (the |SInt| 5)
    (|Lex| |Struct-axlit-23-setrest!-3| 3 |l0|))
  (|SetAElt| t0 (the |SInt| 6) (the |SInt| 357262396))
  (|SetAElt| t1 (the |SInt| 6) t13)
  (|SetAElt|
    t2
    (the |SInt| 6)
    (|Lex| |Struct-axlit-23-empty-2| 2 |l0|))
  (|SetAElt| t0 (the |SInt| 7) (the |SInt| 506619364))
  (|SetAElt| t1 (the |SInt| 7) t10)
  (|SetAElt|
    t2
    (the |SInt| 7)
    (|Lex| |Struct-axlit-23-empty?-1| 1 |l0|))
  (|SetAElt| t0 (the |SInt| 8) (the |SInt| 5509732))
  (|SetAElt| t1 (the |SInt| 8) t10)
  (|SetAElt|
    t2
    (the |SInt| 8)
    (|Lex| |Struct-axlit-23-test-0| 0 |l0|))
  (|SetLex| |Struct-axlit-23-nil-8| 8 |l0| (|AXL-nilfn|))
  (|SetAElt| t0 (the |SInt| 9) (the |SInt| 318525310))
  (|SetAElt| t1 (the |SInt| 9) t11)
  (|SetAElt|
    t2
    (the |SInt| 9)
    (|Lex| |Struct-axlit-23-nil-8| 8 |l0|))
  (block-return |C61-axlit-addLevel1| |P0-domain|))

(defprog
  ((|C62-axlit-bracket| |Word|) ((|P0-t| |Word|) (|e1| |Env|)))
  ((|T0-i| |Word|)
    (|T1-l| |Word|)
    (|T2-nil| |Word|)
    (t3 |Word|)
    (t4 |Word|)
    (t5 |Word|))
  (tagbody
    (setq |T2-nil| (|AXL-nilfn|))
    (setq |T1-l| |T2-nil|)
    (setq |T0-i| (|RElt| |Struct-axlit-19| |sz| 0 |P0-t|))
    |Lab0|
    (setq t4 (|AXL-onefnSingleInteger|))
    (when (|AXL-leSingleInteger| t4 |T0-i|) (go |Lab3|))
    (block-return |C62-axlit-bracket| |T1-l|)
    |Lab3|
    (setq t5 (|AXL-decSingleInteger| |T0-i|))
    (setq
      t3
      (|AXL-arrayRef| (|RElt| |Struct-axlit-19| |values| 1 |P0-t|) t5))
    (setq |T1-l| (|AXL-cons| t3 |T1-l|))
    (setq |T0-i| (|AXL-decSingleInteger| |T0-i|))
    (go |Lab0|)))

(defprog
  ((|C63-axlit-first| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C63-axlit-first| (|AXL-car| |P0-x|)))

(defprog
  ((|C64-axlit-rest| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C64-axlit-rest| (|AXL-cdr| |P0-x|)))

(defprog
  ((|C65-axlit-cons| |Word|)
    ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))
  ()
  (block-return |C65-axlit-cons| (|AXL-cons| |P0-x| |P1-y|)))

(defprog
  ((|C66-axlit-setfirst!| |Word|)
    ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))
  ()
  (block-return |C66-axlit-setfirst!| (|AXL-rplaca| |P0-x| |P1-y|)))

(defprog
  ((|C67-axlit-setrest!| |Word|)
    ((|P0-x| |Word|) (|P1-y| |Word|) (|e1| |Env|)))
  ()
  (block-return |C67-axlit-setrest!| (|AXL-rplacd| |P0-x| |P1-y|)))

(defprog
  ((|C68-axlit-empty| |Word|) ((|e1| |Env|)))
  ()
  (block-return |C68-axlit-empty| (|AXL-nilfn|)))

(defprog
  ((|C69-axlit-empty?| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C69-axlit-empty?| (|AXL-null?| |P0-x|)))

(defprog
  ((|C70-axlit-test| |Word|) ((|P0-x| |Word|) (|e1| |Env|)))
  ()
  (block-return |C70-axlit-test| (|BoolNot| (|AXL-null?| |P0-x|))))

(defprog
  ((|C71-axlit-axlit| |Word|) ((p0-s |Word|) (|e1| |Env|)))
  ((t0 |Word|)
    (t1 |Arr|)
    (t2 |Record|)
    (t3 |Word|)
    (t4 |Word|)
    (|l0| |Level|)
    (|e0| |Env|)
    (|l1| |Level|))
  (setq |l0| (|MakeLevel| |MAKE-Struct-axlit-25| |Struct-axlit-25|))
  (setq |e0| (|MakeEnv| |e1| |l0|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (|SetLex| |Struct-axlit-25-S-0| 0 |l0| p0-s)
    (setq t1 (|ANew| |Word| (the |SInt| 1)))
    (setq t2 (|RNew| |Struct-axlit-17|))
    (|SetRElt| |Struct-axlit-17| |size| 0 t2 (the |SInt| 1))
    (|SetRElt| |Struct-axlit-17| |values| 1 t2 t1)
    (when (|PtrIsNil| (|Lex| |Struct-axlit-26--13| 13 |l1|)) (go |Lab3|))
    |Lab1|
    (|SetAElt| t1 (the |SInt| 0) (|Lex| |Struct-axlit-25-S-0| 0 |l0|))
    (multiple-value-setq
      (t3 t4)
      (|CCall| |G-rtCacheCheck| (|Lex| |Struct-axlit-26--13| 13 |l1|) t2))
    (when t4 (go |Lab0|))
    (setq t0 (|CCall| |G-extendMake| (|Clos| |e0| |C72-axlit-extend0|)))
    (setq
      t3
      (|CCall| |G-rtCacheAdd| (|Lex| |Struct-axlit-26--13| 13 |l1|) t2 t0))
    |Lab0|
    (block-return |C71-axlit-axlit| t3)
    |Lab3|
    (|SetLex|
      |Struct-axlit-26--13|
      13
      |l1|
      (|CCall| |G-rtCacheExplicitMake| (the |SInt| 15)))
    (go |Lab1|)))

(defprog
  ((|C72-axlit-extend0| |Clos|) ((|P0-domain| |Word|) (|e1| |Env|)))
  ((t0 |Arr|) (t1 |Record|) (|l1| |Level|) (|e2| |Env|) (|l2| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (setq |e2| (|EnvNext| |e1|))
  (setq |l2| (|EnvLevel| |e2|))
  (setq t0 (|ANew| |Word| (the |SInt| 2)))
  (|SetAElt|
    t0
    (the |SInt| 1)
    (|CCall|
      (|Lex| |Struct-axlit-26-List-2| 2 |l2|)
      (|Lex| |Struct-axlit-25-S-0| 0 |l1|)))
  (|SetAElt|
    t0
    (the |SInt| 0)
    (|CCall|
      |G-axlit_List_533942053|
      (|Lex| |Struct-axlit-25-S-0| 0 |l1|)))
  (setq t1 (|RNew| |Struct-axlit-5|))
  (|SetRElt| |Struct-axlit-5| |size| 0 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |nsize| 1 t1 (the |SInt| 2))
  (|SetRElt| |Struct-axlit-5| |values| 2 t1 t0)
  (|CCall| |G-extendFill!| |P0-domain| t1)
  (block-return |C72-axlit-extend0| |P0-domain|))

(defprog
  ((|C73-axlit-lang-init| |Word|) ((|P0-idx| |SInt|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axlit-26--14| 14 |l1|) (go |Lab0|))
    (|SetLex| |Struct-axlit-26--14| 14 |l1| (the |Bool| t))
    (|CCall| |G-lang|)
    |Lab0|
    (block-return |C73-axlit-lang-init| |G-lang_Tuple_814586999|)))

(defprog
  ((|C74-axlit-axiom-init| |Word|) ((|P0-idx| |SInt|) (|e1| |Env|)))
  ((|l1| |Level|))
  (setq |l1| (|EnvLevel| |e1|))
  (tagbody
    (when (|Lex| |Struct-axlit-26--15| 15 |l1|) (go |Lab0|))
    (|SetLex| |Struct-axlit-26--15| 15 |l1| (the |Bool| t))
    (|CCall| |G-axiom|)
    |Lab0|
    (when (|SIntNE| |P0-idx| (the |SInt| 9)) (go |Lab1|))
    (block-return |C74-axlit-axiom-init| |G-axiom_List_871832300|)
    |Lab1|
    (when (|SIntNE| |P0-idx| (the |SInt| 8)) (go |Lab2|))
    (block-return |C74-axlit-axiom-init| |G-axiom_Float_764636083|)
    |Lab2|
    (when (|SIntNE| |P0-idx| (the |SInt| 7)) (go |Lab3|))
    (block-return |C74-axlit-axiom-init| |G-axiom_DoubleFloat_727593709|)
    |Lab3|
    (when (|SIntNE| |P0-idx| (the |SInt| 6)) (go |Lab4|))
    (block-return
      |C74-axlit-axiom-init|
      |G-axiom_PositiveInteger_980864265|)
    |Lab4|
    (when (|SIntNE| |P0-idx| (the |SInt| 5)) (go |Lab5|))
    (block-return
      |C74-axlit-axiom-init|
      |G-axiom_NonNegativeInteger_237435701|)
    |Lab5|
    (when (|SIntNE| |P0-idx| (the |SInt| 4)) (go |Lab6|))
    (block-return |C74-axlit-axiom-init| |G-axiom_Integer_386076448|)
    |Lab6|
    (when (|SIntNE| |P0-idx| (the |SInt| 3)) (go |Lab7|))
    (block-return
      |C74-axlit-axiom-init|
      |G-axiom_SingleInteger_549551593|)
    |Lab7|
    (when (|SIntNE| |P0-idx| (the |SInt| 2)) (go |Lab8|))
    (block-return |C74-axlit-axiom-init| |G-axiom_Boolean_767845329|)
    |Lab8|
    (when (|SIntNE| |P0-idx| (the |SInt| 1)) (go |Lab9|))
    (block-return |C74-axlit-axiom-init| |G-axiom_Symbol_046036891|)
    |Lab9|
    (block-return |C74-axlit-axiom-init| |G-axiom_String_971547420|)))

(setq |G-axlit| (|Clos| nil |C0-axlit-axlit|))

(setq |G-axlit_PositiveInteger_263513050| nil)

(setq |G-axlit_NonNegativeInteger_263513050| nil)

(setq |G-axlit_List_533942053| nil)

(setq |G-axlit_Tuple_896539526| nil)

(setq |G-axlit_SingleInteger_603316683| nil)

(setq |G-axlit_Integer_971403808| nil)

(setq |G-axlit_Float_083362422| nil)

(setq |G-axlit_Symbol_636926304| nil)

(setq |G-axlit_String_636926304| nil)

(setq |G-axlit_DoubleFloat_083362422| nil)

(setq |G-axlit_BuiltinArray_589498848| nil)

(setq |G-axlit_BuiltinValue_091505407| nil)

(setq |G-axlit_integer_666767360| nil)

(setq |G-axlit_error_011667951| nil)

(setq |G-axlit_DoubleFloat_325216460| nil)

(setq |G-axlit_String_050790629| nil)

(setq |G-axlit_Symbol_738567780| nil)

(setq |G-axlit_Float_440826770| nil)

(setq |G-axlit_Integer_273754537| nil)

(setq |G-axlit_SingleInteger_1058045725| nil)

(setq |G-axlit_Tuple_310792372| nil)

(setq |G-axlit_List_927796144| nil)

(setq |G-axlit_NonNegativeInteger_858745464| nil)

(setq |G-axlit_PositiveInteger_1048974412| nil)

(file-imports
  '((|G-axiom| "axiom" |initializer| "")
      (|G-lang| "lang" |initializer| "")
      (|G-rtAddStrings| "rtAddStrings" 0 "")
      (|G-axiom_List_871832300| "List" 871832300 "axiom")
      (|G-rtDelayedInit!| "rtDelayedInit!" 0 "")
      (|G-lang_Tuple_814586999| "Tuple" 814586999 "lang")
      (|G-rtCacheAdd| "rtCacheAdd" 0 "")
      (|G-rtSingleParamNameFn| "rtSingleParamNameFn" 0 "")
      (|G-rtCacheCheck| "rtCacheCheck" 0 "")
      (|G-rtCacheExplicitMake| "rtCacheExplicitMake" 0 "")
      (|G-axiom_Float_764636083| "Float" 764636083 "axiom")
      (|G-axiom_DoubleFloat_727593709| "DoubleFloat" 727593709 "axiom")
      (|G-axiom_PositiveInteger_980864265|
        "PositiveInteger"
        980864265
        "axiom")
      (|G-axiom_NonNegativeInteger_237435701|
        "NonNegativeInteger"
        237435701
        "axiom")
      (|G-axiom_Integer_386076448| "Integer" 386076448 "axiom")
      (|G-axiom_SingleInteger_549551593| "SingleInteger" 549551593 "axiom")
      (|G-axiom_Boolean_767845329| "Boolean" 767845329 "axiom")
      (|G-axiom_Symbol_046036891| "Symbol" 46036891 "axiom")
      (|G-stdGetWordRetWord0| "stdGetWordRetWord0" 0 "")
      (|G-rtDelayedGetExport!| "rtDelayedGetExport!" 0 "")
      (|G-extendMake| "extendMake" 0 "")
      (|G-extendFill!| "extendFill!" 0 "")
      (|G-rtLazyDomFrInit| "rtLazyDomFrInit" 0 "")
      (|G-axiom_String_971547420| "String" 971547420 "axiom")
      (|G-domainHash!| "domainHash!" 0 "")
      (|G-domainMake| "domainMake" 0 "")
      (|G-domainMakeDispatch| "domainMakeDispatch" 0 "")
      (|G-domainAddExports!| "domainAddExports!" 0 "")
      (|G-domainAddHash!| "domainAddHash!" 0 "")
      (|G-domainAddNameFn!| "domainAddNameFn!" 0 "")
      (|G-rtConstNameFn| "rtConstNameFn" 0 "")
      (|G-runtime| "runtime" |initializer| "")
      (|G-noOperation| "noOperation" 0 "")))

(file-exports
  '((|G-axlit_PositiveInteger_1048974412|
        "PositiveInteger"
        1048974412
        "axlit")
      (|G-axlit_NonNegativeInteger_858745464|
        "NonNegativeInteger"
        858745464
        "axlit")
      (|G-axlit_List_927796144| "List" 927796144 "axlit")
      (|G-axlit_Tuple_310792372| "Tuple" 310792372 "axlit")
      (|G-axlit_SingleInteger_1058045725|
        "SingleInteger"
        1058045725
        "axlit")
      (|G-axlit_Integer_273754537| "Integer" 273754537 "axlit")
      (|G-axlit_Float_440826770| "Float" 440826770 "axlit")
      (|G-axlit_Symbol_738567780| "Symbol" 738567780 "axlit")
      (|G-axlit_String_050790629| "String" 50790629 "axlit")
      (|G-axlit_DoubleFloat_325216460| "DoubleFloat" 325216460 "axlit")
      (|G-axlit_error_011667951| "error" 11667951 "axlit")
      (|G-axlit_integer_666767360| "integer" 666767360 "axlit")
      (|G-axlit_BuiltinValue_091505407| "BuiltinValue" 91505407 "axlit")
      (|G-axlit_BuiltinArray_589498848| "BuiltinArray" 589498848 "axlit")
      (|G-axlit_DoubleFloat_083362422| "DoubleFloat" 83362422 "axlit")
      (|G-axlit_String_636926304| "String" 636926304 "axlit")
      (|G-axlit_Symbol_636926304| "Symbol" 636926304 "axlit")
      (|G-axlit_Float_083362422| "Float" 83362422 "axlit")
      (|G-axlit_Integer_971403808| "Integer" 971403808 "axlit")
      (|G-axlit_SingleInteger_603316683| "SingleInteger" 603316683 "axlit")
      (|G-axlit_Tuple_896539526| "Tuple" 896539526 "axlit")
      (|G-axlit_List_533942053| "List" 533942053 "axlit")
      (|G-axlit_NonNegativeInteger_263513050|
        "NonNegativeInteger"
        263513050
        "axlit")
      (|G-axlit_PositiveInteger_263513050|
        "PositiveInteger"
        263513050
        "axlit")
      (|G-axlit| "axlit" |initializer| "")))
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
