# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Sat Sep 18 15:05:13 2004
# add fields to sizer_12 = self.scrollsizer

import wx, os, sys
from bibOOo.CONST import BIB_TYPE,BIB_FIELDS,SOURCEDIR,NAME_FIELD,FIELD_NAME
from StyleEditor.StyleDialog import StyleDialog
from StyleEditor.SeparatorsDialog import SeparatorsDialog
from StyleEditor.AnonymousDialog import AnonymousDialog

# begin wxGlade: dependencies
# end wxGlade

# styles = OR of following values
from bibOOo.CONST import bibOOo_base,bibOOo_regular,bibOOo_italic,bibOOo_bold,bibOOo_caps,bibOOo_smallcaps,bibOOo_underline
# position =
from bibOOo.CONST import bibOOo_normal,bibOOo_exposant,bibOOo_indice
# normal = 0
# exposant = 1
# indice = -1
AuthorEx = (u'Baker, Norma Jean',False)				# for author exemple


class page_Citation(wx.Panel):
	def __init__(self, *args, **kwds):
		self.conv = kwds['conv']					# current Format
		del kwds['conv']
		#
		self.scrollsizer = None						# scroller to which fields (Author-date template) must be added. Panel = self.panel_4
		self.template = []							# list of the fields. ex default_citation['ad_template']
		self.lastInsertField = None					# curently selected field in template
		self.modules = {}							# dictionary of modules for author formating
		self.__import_format()						# import author formating modules
		# begin wxGlade: page_Citation.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.panel_authordate = wx.Panel(self, -1)
		self.ad_duplicateFieldPanel = wx.Panel(self.panel_authordate, -1)
		self.ad_duplicateNamePanel = wx.Panel(self.panel_authordate, -1)
		self.ad_duplicateNewNameFormat = wx.Panel(self.ad_duplicateNamePanel, -1)
		self.panel_4 = wx.ScrolledWindow(self.panel_authordate, -1, style=wx.TAB_TRAVERSAL)
		self.panel_numbering = wx.Panel(self, -1)
		self.sizer_4_staticbox = wx.StaticBox(self, -1, _("Base Style"))
		self.sizer_2_staticbox = wx.StaticBox(self, -1, _("Numbering"))
		self.sizer_11_staticbox = wx.StaticBox(self.panel_authordate, -1, _("Template"))
		self.sizer_14_staticbox = wx.StaticBox(self.panel_authordate, -1, _("Author list format"))
		self.sizer_23_staticbox = wx.StaticBox(self.ad_duplicateNewNameFormat, -1, _("New Name format"))
		self.sizer_22_staticbox = wx.StaticBox(self.ad_duplicateNamePanel, -1, _("Author list"))
		self.sizer_17_staticbox = wx.StaticBox(self.ad_duplicateFieldPanel, -1, _("Field"))
		self.sizer_16_staticbox = wx.StaticBox(self.panel_authordate, -1, _("Duplicates"))
		self.sizer_3_staticbox = wx.StaticBox(self, -1, _("Author-Date"))
		self.panel_style = wx.Panel(self, -1)
		self.base_italic = wx.CheckBox(self.panel_style, -1, _("Italic"))
		self.base_bold = wx.CheckBox(self.panel_style, -1, _("Bold"))
		self.base_caps = wx.CheckBox(self.panel_style, -1, _("Caps"))
		self.base_smallcaps = wx.CheckBox(self.panel_style, -1, _("Small Caps"))
		self.base_underline = wx.CheckBox(self.panel_style, -1, _("Underline"))
		self.base_position = wx.RadioBox(self.panel_style, -1, _("Position"), choices=[_("Superscript"), _("Normal"), _("Subscript")], majorDimension=1, style=wx.RA_SPECIFY_COLS)
		self.numbering_sort = wx.CheckBox(self.panel_numbering, -1, _("Sort: [1] [3] [2] -> [1] [2] [3]"))
		self.numbering_fuse = wx.CheckBox(self.panel_numbering, -1, _("Fuse: [1] [3] [2] -> [1; 3; 2]"))
		self.label_5 = wx.StaticText(self.panel_numbering, -1, _("using separator"))
		self.numbering_sep = wx.ComboBox(self.panel_numbering, -1, choices=[_("; "), _(", "), _(": ")], style=wx.CB_DROPDOWN)
		self.numbering_range = wx.CheckBox(self.panel_numbering, -1, _("Use range: [1] [3] [2] -> [1-3]"))
		self.label_8 = wx.StaticText(self.panel_numbering, -1, _("using separator"))
		self.numbering_rangesep = wx.ComboBox(self.panel_numbering, -1, choices=[_("-"), _("--"), _("]-[")], style=wx.CB_DROPDOWN)
		self.ad_fuse = wx.CheckBox(self.panel_authordate, -1, _("Fuse: [Martin] [John] -> [Martin; John]"))
		self.label_6 = wx.StaticText(self.panel_authordate, -1, _("using separator"))
		self.ad_sep = wx.ComboBox(self.panel_authordate, -1, choices=[_("; "), _(", "), _(": ")], style=wx.CB_DROPDOWN)
		self.label_11 = wx.StaticText(self.panel_authordate, -1, _(" and order them by"))
		self.ad_order = wx.Choice(self.panel_authordate, -1, choices=[_("BibliographicType")])
		self.ad_asc = wx.Choice(self.panel_authordate, -1, choices=[_("Ascending"), _("Descending")])
		self.template_style = wx.Button(self.panel_authordate, -1, _("Style ..."))
		self.template_fields = wx.Choice(self.panel_authordate, -1, choices=[_("BibliographicType")])
		self.template_addField = wx.Button(self.panel_authordate, -1, _("Add"))
		self.template_addText = wx.Button(self.panel_authordate, -1, _("Add Text"))
		self.template_remove = wx.Button(self.panel_authordate, -1, _("Remove"))
		self.label_7 = wx.StaticText(self.panel_authordate, -1, _("Name format"))
		self.ad_name = wx.Choice(self.panel_authordate, -1, choices=[_("Norma Jean Baker")])
		self.ad_nameseparators = wx.Button(self.panel_authordate, -1, _("Separators ..."))
		self.label_13_copy = wx.StaticText(self.panel_authordate, -1, _("Separate authors with"))
		self.label_14_copy = wx.StaticText(self.panel_authordate, -1, _("Before last"))
		self.ad_authorsSep = wx.TextCtrl(self.panel_authordate, -1, "")
		self.ad_authorsLast = wx.TextCtrl(self.panel_authordate, -1, "")
		self.ad_abbreviate = wx.CheckBox(self.panel_authordate, -1, _("If at least"))
		self.ad_abbreviateFrom = wx.SpinCtrl(self.panel_authordate, -1, "", min=2, max=100)
		self.label_3 = wx.StaticText(self.panel_authordate, -1, _("authors, replace authors 2 to n with"))
		self.ad_abbreviateText = wx.TextCtrl(self.panel_authordate, -1, _(", et al."))
		self.ad_abbreviateStyle = wx.Button(self.panel_authordate, -1, _("Style ..."))
		self.ad_listAllAuthors = wx.CheckBox(self.panel_authordate, -1, _("List all authors on first occurence if authors number is not higher than"))
		self.ad_listUpTo = wx.SpinCtrl(self.panel_authordate, -1, "5", min=0, max=100)
		self.ad_anonymous = wx.Button(self.panel_authordate, -1, _("Anonymous ..."))
		self.ad_duplicate = wx.RadioBox(self.panel_authordate, -1, "", choices=[_("Put a letter after the year"), _("Change author list"), _("Add a field")], majorDimension=1, style=wx.RA_SPECIFY_COLS)
		self.ad_duplicatListMoreAut = wx.CheckBox(self.ad_duplicateNamePanel, -1, _("List more authors until it is unique"))
		self.ad_name_new = wx.Choice(self.ad_duplicateNewNameFormat, -1, choices=[_("Norma Jean Baker")])
		self.ad_nameseparators_new = wx.Button(self.ad_duplicateNewNameFormat, -1, _("Separators ..."))
		self.label_9 = wx.StaticText(self.ad_duplicateFieldPanel, -1, _("Add"))
		self.ad_duplicateFieldText = wx.TextCtrl(self.ad_duplicateFieldPanel, -1, "")
		self.ad_duplicateField = wx.Choice(self.ad_duplicateFieldPanel, -1, choices=[_("BibliographicType")])
		self.ad_duplicateStyle = wx.Button(self.ad_duplicateFieldPanel, -1, _("Style ..."))
		self.label_10 = wx.StaticText(self.ad_duplicateFieldPanel, -1, _("After"))
		self.ad_duplicateAfter = wx.Choice(self.ad_duplicateFieldPanel, -1, choices=[_("BibliographicType")])

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		# adding fields in scrollwindow to self.scrollsizer etc...
		self.__delayed_layout()
		self.__set_evt()

	def __delayed_layout(self):
		# adding fields in scrollwindow to self.scrollsizer
		self.__setScrollFields(self.conv['ad_template'])
		# set the possible choices in ad_duplicateAfter according to current self.scrollsizer content
		self.__setAdDuplicateFields()	# set the possible choices in duplicates_Add_Fields according to self.conv['ad_template']
		try:
			self.ad_duplicateAfter.SetStringSelection(NAME_FIELD[self.conv['ad_duplicates']['field']['after']])
		except:
			self.ad_duplicateAfter.SetSelection(0)

	def __set_properties(self):
		# begin wxGlade: page_Citation.__set_properties
		self.base_position.SetSelection(1)
		self.numbering_sep.SetMinSize((50, -1))
		self.numbering_sep.SetSelection(0)
		self.numbering_rangesep.SetMinSize((50, -1))
		self.numbering_rangesep.SetSelection(0)
		self.ad_sep.SetMinSize((50, -1))
		self.ad_sep.SetSelection(0)
		self.ad_order.SetSelection(0)
		self.ad_asc.SetSelection(0)
		self.panel_4.SetScrollRate(10, 10)
		self.template_fields.SetSelection(0)
		self.ad_name.SetSelection(0)
		self.ad_abbreviateFrom.SetMinSize((50, -1))
		self.ad_listUpTo.SetMinSize((50, -1))
		self.ad_duplicate.SetSelection(0)
		self.ad_name_new.SetSelection(0)
		self.ad_duplicateFieldText.SetMinSize((50, 26))
		self.ad_duplicateField.SetSelection(0)
		self.ad_duplicateAfter.SetSelection(0)
		# end wxGlade
		# we fill the choices
		self.ad_order.Clear()
		self.ad_order.AppendItems(["Bibliography order",_("Not sorted")] + [NAME_FIELD[field] for field in BIB_FIELDS])
		self.ad_order.SetSelection(0)
		self.template_fields.Clear()
		self.template_fields.AppendItems([NAME_FIELD[field] for field in BIB_FIELDS])
		self.template_fields.SetSelection(0)
		self.ad_duplicateField.Clear()
		self.ad_duplicateField.AppendItems([NAME_FIELD[field] for field in BIB_FIELDS])
		self.ad_duplicateField.SetStringSelection(NAME_FIELD["Title"])
		# self.ad_name.SetSelection(0)
		self.ad_duplicateAfter.Clear()
		# setting base style
		style = self.conv['base_style'][0]
		self.base_italic.SetValue(style & bibOOo_italic)
		self.base_bold.SetValue(style & bibOOo_bold)
		self.base_caps.SetValue(style & bibOOo_caps)
		self.base_smallcaps.SetValue(style & bibOOo_smallcaps)
		self.base_underline.SetValue(style & bibOOo_underline)
		self.base_position.SetSelection(1 - self.conv['base_style'][1])
		# setting numbering format
		self.numbering_sort.SetValue(self.conv['numbering'][0])
		self.numbering_fuse.SetValue(self.conv['numbering'][1])
		self.numbering_range.SetValue(self.conv['numbering'][2])
		self.numbering_sep.SetValue(self.conv['numbering'][3])
		self.numbering_rangesep.SetValue(self.conv['numbering'][4])
		# author-date
		self.ad_fuse.SetValue(self.conv['ad'][0])
		self.ad_sep.SetValue(self.conv['ad'][1])
		self.ad_asc.SetSelection( not self.conv['ad'][3] )
		if self.conv['ad'][2] == 'index':
			self.ad_order.SetSelection(0)
		elif self.conv['ad'][2] == None:
			self.ad_order.SetSelection(1)
		else:
			self.ad_order.SetStringSelection(NAME_FIELD[self.conv['ad'][2]])
		# author format
		self.ad_name.Clear()
		tmp = self.__AuthorFormat(self.conv['ad_author']['format'][0][1])
		for i in tmp:
			self.ad_name.Append(i[0],i[1])			# ClientData = module name
		# set the selection to the current style
		self.ad_name.SetStringSelection(apply(self.modules[self.conv['ad_author']['format'][0][0]].format,AuthorEx+self.conv['ad_author']['format'][0][1]))
		self.ad_authorsSep.SetValue(self.conv['ad_author']['format'][3][1][1])
		self.ad_authorsLast.SetValue(self.conv['ad_author']['format'][3][1][3])
		self.ad_abbreviate.SetValue(self.conv['ad_author']['format'][3][1][5] != 0)
		if self.conv['ad_author']['format'][3][1][5] < self.ad_abbreviateFrom.GetMin():
			self.ad_abbreviateFrom.SetValue(self.ad_abbreviateFrom.GetMin())
		else:
			self.ad_abbreviateFrom.SetValue(self.conv['ad_author']['format'][3][1][5])
		self.ad_abbreviateText.SetValue(self.conv['ad_author']['format'][3][1][6])
		self.ad_listAllAuthors.SetValue(self.conv['ad_author']['listall'][0])
		self.ad_listUpTo.SetValue(self.conv['ad_author']['listall'][1])
		self.ad_listUpTo.Enable(self.ad_listAllAuthors.GetValue())
		# duplicates
		self.ad_duplicate.SetSelection(self.conv['ad_duplicates']['type'])
		# change author list
		self.ad_duplicatListMoreAut.SetValue(not self.conv['ad_duplicates']['author']['type'])
		self.ad_name_new.Clear()
		tmp = self.__AuthorFormat(self.conv['ad_duplicates']['author']['format'][1])
		for i in tmp:
			self.ad_name_new.Append(i[0],i[1])			# ClientData = module name
		# set the selection to the current style
		self.ad_name_new.SetStringSelection(apply(self.modules[self.conv['ad_duplicates']['author']['format'][0]].format,AuthorEx+self.conv['ad_duplicates']['author']['format'][1]))
		# add a field
		self.ad_duplicateFieldText.SetValue(self.conv['ad_duplicates']['field']['add'][0][1])
		self.ad_duplicateField.SetStringSelection(NAME_FIELD[self.conv['ad_duplicates']['field']['add'][1][1]])
		self.ad_abbreviateStyleValue = self.conv['ad_author']['etall_style']		# style of 'et al.'
		self.ad_duplicateStyleValue = self.conv['ad_duplicates']['field']['add'][1][2]	# style of 'added field'
		# reading separators
		self.ad_nameseparatorsValue = self.conv['ad_author']['format'][0][1]
		self.ad_nameseparators_newValue = self.conv['ad_duplicates']['author']['format'][1]
		# enabling/desabling panels
		self.__on_numbering_fuse(None)
		self.__on_ad_duplicate(None)
		self.__on_ad_abbreviate(None)

	def __setScrollFields(self,fieldsList):
		#default_citation['ad_template'] = ('field','Author',0),('text',', ',0),('field','Year',0)
		self.template = []
		#while self.scrollsizer.Remove(0): pass	# clear the sizer
		for field in fieldsList:
			if field[0] == 'field':
				self.template.append(FieldToggle(self.panel_4,-1,field[1],FieldStyle=field[2])) # name,style
				self.scrollsizer.Add(self.template[-1])
				wx.EVT_TOGGLEBUTTON(self,self.template[-1].GetId(),self.onToggle)
			elif field[0] == 'text':
				self.template.append(FieldText(self.panel_4,-1,field[1],FieldStyle=field[2])) # name,style
				self.scrollsizer.Add(self.template[-1])
				wx.EVT_SET_FOCUS(self.template[-1],self.onToggle)
			else:
				print "What are we doing here? line 237 of page_Citation.py"
		self.scrollsizer.Layout()
		self.panel_4.FitInside()

	def __setAdDuplicateFields(self):
		"""Set Fields choices according to fields present in template"""
		oldchoice = self.ad_duplicateAfter.GetStringSelection()
		self.ad_duplicateAfter.Clear()
		for i in self.template:
			fieldtype,name,style = i.getTuple()
			if fieldtype=='field': self.ad_duplicateAfter.Append(NAME_FIELD[name])
		if oldchoice:
			try:
				self.ad_duplicateAfter.SetStringSelection(oldchoice)
			except:
				self.ad_duplicateAfter.SetSelection(0)
		else:
			self.ad_duplicateAfter.SetSelection(0)

	def onToggle(self,evt):
		if self.lastInsertField != evt.GetEventObject():
			if self.lastInsertField: self.lastInsertField.select(False) # we unselect the last one
			self.lastInsertField = evt.GetEventObject()					# remmember the new choice
		evt.GetEventObject().select(True)								# select it

# setting authors exemples
	def __AuthorFormat(self,sep):
		tmpAuthorEx = AuthorEx + sep
		k=self.modules.keys()
		k.sort()
		tmp=[]
		for i in k:
			tmp.append((apply(self.modules[i].format,tmpAuthorEx),i))
		return tmp

	def __do_layout(self):
		# begin wxGlade: page_Citation.__do_layout
		sizer_1 = wx.BoxSizer(wx.VERTICAL)
		sizer_3 = wx.StaticBoxSizer(self.sizer_3_staticbox, wx.HORIZONTAL)
		sizer_9 = wx.BoxSizer(wx.VERTICAL)
		sizer_16 = wx.StaticBoxSizer(self.sizer_16_staticbox, wx.HORIZONTAL)
		sizer_17 = wx.StaticBoxSizer(self.sizer_17_staticbox, wx.VERTICAL)
		grid_sizer_1 = wx.FlexGridSizer(3, 2, 0, 5)
		sizer_25 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_22 = wx.StaticBoxSizer(self.sizer_22_staticbox, wx.VERTICAL)
		sizer_23 = wx.StaticBoxSizer(self.sizer_23_staticbox, wx.HORIZONTAL)
		sizer_14 = wx.StaticBoxSizer(self.sizer_14_staticbox, wx.HORIZONTAL)
		sizer_15 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_18 = wx.BoxSizer(wx.VERTICAL)
		sizer_31 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_19 = wx.BoxSizer(wx.HORIZONTAL)
		grid_sizer_2_copy = wx.GridSizer(2, 2, 0, 20)
		sizer_21 = wx.BoxSizer(wx.VERTICAL)
		sizer_11 = wx.StaticBoxSizer(self.sizer_11_staticbox, wx.HORIZONTAL)
		sizer_13 = wx.BoxSizer(wx.VERTICAL)
		sizer_12 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_10 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_2 = wx.StaticBoxSizer(self.sizer_2_staticbox, wx.HORIZONTAL)
		sizer_7 = wx.BoxSizer(wx.VERTICAL)
		sizer_32 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_4 = wx.StaticBoxSizer(self.sizer_4_staticbox, wx.HORIZONTAL)
		sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_6 = wx.BoxSizer(wx.VERTICAL)
		sizer_6.Add(self.base_italic, 0, 0, 0)
		sizer_6.Add(self.base_bold, 0, 0, 0)
		sizer_6.Add(self.base_caps, 0, 0, 0)
		sizer_6.Add(self.base_smallcaps, 0, 0, 0)
		sizer_6.Add(self.base_underline, 0, 0, 0)
		sizer_5.Add(sizer_6, 0, wx.EXPAND, 0)
		sizer_5.Add((50, 20), 0, 0, 0)
		sizer_5.Add(self.base_position, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		self.panel_style.SetSizer(sizer_5)
		sizer_4.Add(self.panel_style, 1, wx.EXPAND, 0)
		sizer_1.Add(sizer_4, 0, wx.EXPAND, 0)
		sizer_7.Add(self.numbering_sort, 0, 0, 0)
		sizer_8.Add(self.numbering_fuse, 0, 0, 0)
		sizer_8.Add(self.label_5, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_8.Add(self.numbering_sep, 0, 0, 0)
		sizer_7.Add(sizer_8, 0, wx.EXPAND, 0)
		sizer_32.Add(self.numbering_range, 0, 0, 0)
		sizer_32.Add(self.label_8, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_32.Add(self.numbering_rangesep, 0, 0, 0)
		sizer_7.Add(sizer_32, 1, wx.EXPAND, 0)
		self.panel_numbering.SetSizer(sizer_7)
		sizer_2.Add(self.panel_numbering, 1, wx.EXPAND, 0)
		sizer_1.Add(sizer_2, 0, wx.EXPAND, 0)
		sizer_10.Add(self.ad_fuse, 0, 0, 0)
		sizer_10.Add(self.label_6, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_10.Add(self.ad_sep, 0, 0, 0)
		sizer_10.Add(self.label_11, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_10.Add(self.ad_order, 0, 0, 0)
		sizer_10.Add(self.ad_asc, 0, 0, 0)
		sizer_9.Add(sizer_10, 0, wx.EXPAND, 0)
		self.panel_4.SetSizer(sizer_12)
		sizer_11.Add(self.panel_4, 1, wx.EXPAND, 0)
		sizer_11.Add((50, 20), 0, 0, 0)
		sizer_11.Add(self.template_style, 0, 0, 0)
		sizer_11.Add((50, 20), 0, 0, 0)
		sizer_13.Add(self.template_fields, 0, wx.EXPAND, 0)
		sizer_13.Add(self.template_addField, 0, wx.EXPAND, 0)
		sizer_11.Add(sizer_13, 0, wx.EXPAND, 0)
		sizer_11.Add((20, 20), 0, 0, 0)
		sizer_11.Add(self.template_addText, 0, 0, 0)
		sizer_11.Add((50, 20), 0, 0, 0)
		sizer_11.Add(self.template_remove, 0, 0, 0)
		sizer_9.Add(sizer_11, 0, wx.EXPAND, 0)
		sizer_21.Add(self.label_7, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
		sizer_21.Add(self.ad_name, 0, wx.TOP|wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 5)
		sizer_21.Add(self.ad_nameseparators, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
		sizer_15.Add(sizer_21, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 50)
		grid_sizer_2_copy.Add(self.label_13_copy, 0, 0, 0)
		grid_sizer_2_copy.Add(self.label_14_copy, 0, 0, 0)
		grid_sizer_2_copy.Add(self.ad_authorsSep, 0, wx.EXPAND, 0)
		grid_sizer_2_copy.Add(self.ad_authorsLast, 0, wx.EXPAND, 0)
		sizer_18.Add(grid_sizer_2_copy, 1, 0, 0)
		sizer_19.Add(self.ad_abbreviate, 0, wx.RIGHT, 5)
		sizer_19.Add(self.ad_abbreviateFrom, 0, 0, 0)
		sizer_19.Add(self.label_3, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_19.Add(self.ad_abbreviateText, 0, 0, 0)
		sizer_19.Add(self.ad_abbreviateStyle, 0, wx.LEFT, 5)
		sizer_18.Add(sizer_19, 0, wx.TOP|wx.EXPAND, 20)
		sizer_31.Add(self.ad_listAllAuthors, 0, 0, 0)
		sizer_31.Add(self.ad_listUpTo, 0, 0, 0)
		sizer_18.Add(sizer_31, 0, wx.EXPAND, 0)
		sizer_15.Add(sizer_18, 1, wx.RIGHT|wx.EXPAND, 50)
		sizer_15.Add(self.ad_anonymous, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_14.Add(sizer_15, 0, wx.EXPAND, 0)
		sizer_9.Add(sizer_14, 0, wx.EXPAND, 0)
		sizer_16.Add(self.ad_duplicate, 0, 0, 0)
		sizer_22.Add(self.ad_duplicatListMoreAut, 0, 0, 0)
		sizer_23.Add(self.ad_name_new, 0, 0, 5)
		sizer_23.Add(self.ad_nameseparators_new, 0, wx.ALL, 5)
		self.ad_duplicateNewNameFormat.SetSizer(sizer_23)
		sizer_22.Add(self.ad_duplicateNewNameFormat, 1, wx.EXPAND, 0)
		self.ad_duplicateNamePanel.SetSizer(sizer_22)
		sizer_16.Add(self.ad_duplicateNamePanel, 0, wx.LEFT, 20)
		grid_sizer_1.Add(self.label_9, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_25.Add(self.ad_duplicateFieldText, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_25.Add(self.ad_duplicateField, 0, 0, 0)
		sizer_25.Add(self.ad_duplicateStyle, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(sizer_25, 1, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label_10, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.ad_duplicateAfter, 0, 0, 0)
		grid_sizer_1.Add((1, 1), 0, 0, 0)
		grid_sizer_1.AddGrowableCol(1)
		sizer_17.Add(grid_sizer_1, 0, wx.EXPAND, 0)
		self.ad_duplicateFieldPanel.SetSizer(sizer_17)
		sizer_16.Add(self.ad_duplicateFieldPanel, 0, wx.LEFT, 20)
		sizer_9.Add(sizer_16, 1, wx.EXPAND, 0)
		self.panel_authordate.SetSizer(sizer_9)
		sizer_3.Add(self.panel_authordate, 1, wx.EXPAND, 0)
		sizer_1.Add(sizer_3, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		# end wxGlade
		self.scrollsizer = sizer_12						# we keep a reference to add fields in it when needed

# we import all the formatting modules located in Format.Citation.Author.Author
	def __myImport(self,s):
		"""Import the modules"""
		m = __import__(s)
		for i in s.split(".")[1:]:
			m = getattr(m, i)
		return m

	def __getFiles(self,direct):
		"""Return list of python files in dir direct"""
		lfile=[]
		for i in os.listdir(direct):
			if i.endswith('.py'): lfile.append(i)
		return lfile

	def __getModules(self,mod):
		"""Store modules 'mod' in self.modules"""
		lfile = self.__getFiles(apply(os.path.join,(SOURCEDIR,)+tuple(mod.split('.'))))
		try: lfile.remove('__init__.py')
		except ValueError: pass
		tmp=[]
		for i in lfile:
			tmpmod = mod+'.'+ i[:-3]
			self.modules[tmpmod] = self.__myImport(tmpmod)

	def __import_format(self):
		"""Import all the formatting modules in Citation.Author
		Store them in self.modules[moduleName] etc...
		"""
		# Author in Format
		self.__getModules('Format.Citation.Author.Author')
		#print self.modules

# events
	def __set_evt(self):
		# showing/hiding
		wx.EVT_RADIOBOX(self,self.ad_duplicate.GetId(),self.__on_ad_duplicate)
		wx.EVT_CHECKBOX(self,self.numbering_sort.GetId(), self.__on_numbering_fuse)
		wx.EVT_CHECKBOX(self,self.numbering_fuse.GetId(), self.__on_numbering_fuse)
		wx.EVT_CHECKBOX(self,self.ad_fuse.GetId(),lambda evt:self.ad_sep.Enable(self.ad_fuse.GetValue()))
		wx.EVT_CHECKBOX(self,self.ad_abbreviate.GetId(),self.__on_ad_abbreviate)
		wx.EVT_CHECKBOX(self,self.ad_listAllAuthors.GetId(),lambda evt: self.ad_listUpTo.Enable(self.ad_listAllAuthors.GetValue()))
		wx.EVT_CHECKBOX(self,self.ad_duplicatListMoreAut.GetId(),lambda evt:self.ad_duplicateNewNameFormat.Enable(not self.ad_duplicatListMoreAut.GetValue()))
		# template editing
		wx.EVT_BUTTON(self,self.template_addField.GetId(),self.__onAddField)
		wx.EVT_BUTTON(self,self.template_addText.GetId(),self.__onAddText)
		wx.EVT_BUTTON(self,self.template_remove.GetId(),self.__onRemove)
		# name format
		wx.EVT_BUTTON(self,self.template_style.GetId(),self.__on_style_scroll)
		wx.EVT_BUTTON(self,self.ad_abbreviateStyle.GetId(),self.__on_style_abbrev)
		wx.EVT_BUTTON(self,self.ad_duplicateStyle.GetId(),self.__on_style_duplicate)
		wx.EVT_BUTTON(self,self.ad_nameseparators.GetId(),self.__on_separators_name)
		wx.EVT_BUTTON(self,self.ad_nameseparators_new.GetId(),self.__on_separators_name_new)
		wx.EVT_BUTTON(self,self.ad_anonymous.GetId(),self.__on_anonymous)
		# caps/smallcaps choices
		wx.EVT_CHECKBOX(self,self.base_caps.GetId(),self.__onCaps)
		wx.EVT_CHECKBOX(self,self.base_smallcaps.GetId(),self.__onSmallCaps)

	def __onCaps(self,evt):
		if self.base_caps.GetValue():
			self.base_smallcaps.SetValue(False)

	def __onSmallCaps(self,evt):
		if self.base_smallcaps.GetValue():
			self.base_caps.SetValue(False)

	def activate_numbering(self,numbering):
		"""Activate / desactivate numbering/ad panels
		if True => activate numbering
		if False => activate ad"""
		self.panel_numbering.Enable(numbering)
		self.panel_authordate.Enable(not numbering)

	def __on_numbering_fuse(self,evt):
		self.numbering_sep.Enable(self.numbering_fuse.GetValue())
		self.numbering_range.Enable(self.numbering_fuse.GetValue() and self.numbering_sort.GetValue())
		self.numbering_range.SetValue(self.numbering_fuse.GetValue() and self.numbering_sort.GetValue())

	def __on_ad_duplicate(self,evt):
		self.ad_duplicateNamePanel.Disable()
		self.ad_duplicateFieldPanel.Disable()
		if self.ad_duplicate.GetSelection() == 1:
			self.ad_duplicateNamePanel.Enable(True)
			self.ad_duplicateNewNameFormat.Enable(not self.ad_duplicatListMoreAut.GetValue())
		elif self.ad_duplicate.GetSelection() == 2:
			self.ad_duplicateFieldPanel.Enable(True)

	def __on_ad_abbreviate(self,evt):
		self.ad_abbreviateFrom.Enable(self.ad_abbreviate.GetValue())
		self.ad_abbreviateText.Enable(self.ad_abbreviate.GetValue())
		self.ad_abbreviateStyle.Enable(self.ad_abbreviate.GetValue())
		self.ad_listAllAuthors.Enable(self.ad_abbreviate.GetValue())

	def __onAddField(self,evt):
		tmp = FieldToggle(self.panel_4,-1,BIB_FIELDS[self.template_fields.GetSelection()],FieldStyle=bibOOo_normal)
		wx.EVT_TOGGLEBUTTON(self,tmp.GetId(),self.onToggle)
		try:
			index = 1+self.template.index(self.lastInsertField)	# insert after current
			self.template.insert(index,tmp)
			self.scrollsizer.Insert(index,tmp)
		except ValueError:
			self.template.append(tmp)
			self.scrollsizer.Add(tmp)
		self.scrollsizer.Layout()
		self.panel_4.FitInside()
		self.__setAdDuplicateFields()	# update choices in duplicates/add field

	def __onAddText(self,evt):
		tmp = FieldText(self.panel_4,-1,'',FieldStyle=bibOOo_normal)
		wx.EVT_SET_FOCUS(tmp,self.onToggle)
		try:
			index = 1+self.template.index(self.lastInsertField)	# insert after current
			self.template.insert(index,tmp)
			self.scrollsizer.Insert(index,tmp)
		except ValueError:
			self.template.append(tmp)
			self.scrollsizer.Add(tmp)
		self.scrollsizer.Layout()
		self.panel_4.FitInside()

	def __onRemove(self,evt):
		if self.lastInsertField:
			index = self.template.index(self.lastInsertField)
			del self.template[index]
			self.scrollsizer.Remove(index)
			self.lastInsertField.Destroy()
			self.lastInsertField = None
			self.Layout()
			self.__setAdDuplicateFields()	# update choices in duplicates/add field
		self.scrollsizer.Layout()
		self.panel_4.FitInside()

	def __get_standardStyle(self):
		"""Return the currently selected standard style"""
		return \
		bibOOo_italic*self.base_italic.GetValue() \
		| bibOOo_bold*self.base_bold.GetValue() \
		| bibOOo_caps*self.base_caps.GetValue() \
		| bibOOo_smallcaps*self.base_smallcaps.GetValue() \
		| bibOOo_underline*self.base_underline.GetValue() \

	def __on_style(self,attribute):
		dlg = StyleDialog(self,-1,'',standard=self.__get_standardStyle(),editedStyle=getattr(self,attribute))
		try:
			ret = dlg.ShowModal()
			if ret == wx.ID_OK:
				setattr(self,attribute,dlg.style)
		finally:
			dlg.Destroy()

	def __on_style_abbrev(self,evt):
		self.__on_style('ad_abbreviateStyleValue')

	def __on_style_duplicate(self,evt):
		self.__on_style('ad_duplicateStyleValue')

	def __on_style_scroll(self,evt):
		"""To edit style of fields/TextCtrl of template (in self.scrollsizer)"""
		if self.lastInsertField:
			dlg = StyleDialog(self,-1,'',standard=self.__get_standardStyle(),editedStyle=self.lastInsertField.Style)
			try:
				ret = dlg.ShowModal()
				if ret == wx.ID_OK:
					self.lastInsertField.Style = dlg.style 			# we store the style
			finally:
				dlg.Destroy()

	def __on_separators(self,attribute):
		"""Set the value of separators of self.attribute. Return True if modified"""
		tmp_ret = False
		dlg = SeparatorsDialog(self,-1,'',separators=getattr(self,attribute))
		try:
			ret = dlg.ShowModal()
			if ret == wx.ID_OK and dlg.separators != getattr(self,attribute):
				setattr(self,attribute,dlg.separators)
				tmp_ret = True
		finally:
			dlg.Destroy()
		return tmp_ret

	def __on_separators_name(self,evt):
		if self.__on_separators("ad_nameseparatorsValue"):
			# author format
			savedstate = self.ad_name.GetSelection()
			self.ad_name.Clear()
			tmp = self.__AuthorFormat(self.ad_nameseparatorsValue)
			for i in tmp:
				self.ad_name.Append(i[0],i[1])
			self.ad_name.SetSelection(savedstate)

	def __on_separators_name_new(self,evt):
		if self.__on_separators("ad_nameseparators_newValue"):
			# change author list
			savedstate = self.ad_name_new.GetSelection()
			self.ad_name_new.Clear()
			tmp = self.__AuthorFormat(self.ad_nameseparators_newValue)
			for i in tmp:
				self.ad_name_new.Append(i[0],i[1])
			self.ad_name_new.SetSelection(savedstate)

	def __on_anonymous(self,evt):
		dlg = AnonymousDialog(self,-1,'',settings=self.conv['ad_author']['anonymous'].copy())
		try:
			ret = dlg.ShowModal()
			if ret == wx.ID_OK:
				self.conv['ad_author']['anonymous'] = dlg.settings
				#print self.conv['ad_author']['anonymous']
		finally:
			dlg.Destroy()

	def getConv(self):
		"""Return the current settings"""
		self.conv['base_style'] = self.__get_standardStyle(),-self.base_position.GetSelection() +1				# style, position
		self.conv['numbering'] = self.numbering_sort.GetValue(),self.numbering_fuse.GetValue(),self.numbering_range.GetValue(),self.numbering_sep.GetValue(),self.numbering_rangesep.GetValue()	# sort,fuse,range,separator
		#
		if self.ad_order.GetSelection() == 0:
			order = 'index'
		elif self.ad_order.GetSelection() == 1:
			order = None
		else:
			order = FIELD_NAME[self.ad_order.GetStringSelection()]
		self.conv['ad'] = self.ad_fuse.GetValue(),self.ad_sep.GetValue(),order,(self.ad_asc.GetSelection()==0)	# fuse,separator
		#self.conv['ad_template'] = ('field','Author',regular),('text',', ',regular),('field','Year',regular)
		self.conv['ad_template'] = tuple(map(lambda x:getattr(x,'getTuple')(),self.template))
		#self.conv['ad_author']['format'] = (('Format.Citation.Author.Author.author5',(' ',' ',' ','','')),\
		#					('Format.Citation.Author.Author.author5',(' ',' ',' ','','')),\
		#					('Format.Citation.Author.Author.author5',(' ',' ',' ','','')),\
		#					('Format.Citation.Author.Joining.joining2',('',', ',', ',' and ','',3,'et al.')))
		if self.ad_abbreviate.GetValue():
			tmp = self.ad_abbreviateFrom.GetValue()
		else:
			tmp = 0			# no abbreviation of the authors list
		self.conv['ad_author']['format'] = \
			((self.ad_name.GetClientData(self.ad_name.GetSelection()),self.ad_nameseparatorsValue),)*3 + \
			(('Format.Citation.Author.Joining.joining2',\
			('',self.ad_authorsSep.GetValue(),self.ad_authorsSep.GetValue(),self.ad_authorsLast.GetValue(),'',\
			tmp,self.ad_abbreviateText.GetValue())),)
		self.conv['ad_author']['etall_style'] = self.ad_abbreviateStyleValue		# 'et al.' style = italic
		self.conv['ad_author']['listall'] = (self.ad_listAllAuthors.GetValue(),self.ad_listUpTo.GetValue())		# list all author on first occurence, if > 5
		#self.conv['ad_author']['anonymous'] is set in self.__on_anonymous()
		self.conv['ad_duplicates']['type'] = self.ad_duplicate.GetSelection()			# 0 = add a letter; 1 = change author ; 2 = add field
		self.conv['ad_duplicates']['author']['type'] = not self.ad_duplicatListMoreAut.GetValue()	# 0 = list until unique ; 1 = new author format
		self.conv['ad_duplicates']['author']['format'] = self.ad_name_new.GetClientData(self.ad_name_new.GetSelection()),self.ad_nameseparators_newValue
		self.conv['ad_duplicates']['field']['add'] = ('text',self.ad_duplicateFieldText.GetValue(),self.ad_duplicateStyleValue),('field',BIB_FIELDS[self.ad_duplicateField.GetSelection()],self.ad_duplicateStyleValue)
		self.conv['ad_duplicates']['field']['after'] = FIELD_NAME[self.ad_duplicateAfter.GetStringSelection()]
		return self.conv

# end of class page_Citation

class FieldToggle(wx.ToggleButton):
	"""ToggleButton which stores the style in button.FieldStyle"""
	def __init__(self, parent, id, field, FieldStyle=0):
		self.Style = FieldStyle
		self.field = field
		wx.ToggleButton.__init__(self,parent,id,NAME_FIELD[self.field])
	def getTuple(self):
		"""return the tuple containing the values"""
		return ('field', self.field, self.Style)
	def select(self,state=True):
		"""Set the state selected/unselected"""
		self.SetValue(state)

class FieldText(wx.TextCtrl):
	"""TextCtrl which stores the style in textctrl.FieldStyle"""
	def __init__(self, *args, **kwds):
		try:
			self.Style = kwds['FieldStyle']
			del kwds['FieldStyle']
		except:
			self.FieldStyle = 0	# style normal. If style = -1 => style = base style
		kwds['size'] = (30,-1)
		wx.TextCtrl.__init__(self,*args, **kwds)
	def getTuple(self):
		"""return the tuple containing the values"""
		return ('text', self.GetValue(), self.Style)
	def select(self,state=True):
		"""Set the state selected/unselected"""
		if state:
			s = self.GetSize()			#
			self.SetSize((0,0))			# needed to get blinking caret
			self.SetSize(s)				#
