//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/InstrumentItemCatalog.cpp
//! @brief     Implements class InstrumentItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Device/InstrumentItemCatalog.h"
#include "GUI/Model/Device/InstrumentItems.h"

InstrumentItem* InstrumentItemCatalog::create(Type type)
{
    switch (type) {
    case Type::GISAS:
        return new GISASInstrumentItem();
    case Type::Offspec:
        return new OffspecInstrumentItem();
    case Type::Specular:
        return new SpecularInstrumentItem();
    case Type::Depthprobe:
        return new DepthprobeInstrumentItem();
    }
    ASSERT(false);
}

QVector<InstrumentItemCatalog::Type> InstrumentItemCatalog::types()
{
    return {Type::GISAS, Type::Offspec, Type::Specular, Type::Depthprobe};
}

UiInfo InstrumentItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::GISAS:
        return {"GISAS", "", ""};
    case Type::Offspec:
        return {"Off specular", "", ""};
    case Type::Specular:
        return {"Specular", "", ""};
    case Type::Depthprobe:
        return {"Depth probe", "", ""};
    }
    ASSERT(false);
}

InstrumentItemCatalog::Type InstrumentItemCatalog::type(const InstrumentItem* item)
{
    if (dynamic_cast<const GISASInstrumentItem*>(item))
        return Type::GISAS;
    if (dynamic_cast<const OffspecInstrumentItem*>(item))
        return Type::Offspec;
    if (dynamic_cast<const SpecularInstrumentItem*>(item))
        return Type::Specular;
    if (dynamic_cast<const DepthprobeInstrumentItem*>(item))
        return Type::Depthprobe;

    ASSERT(false);
}
