//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Model/RealModel.h
//! @brief     Defines class RealModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_MODEL_REALMODEL_H
#define BORNAGAIN_GUI_MODEL_MODEL_REALMODEL_H

#include "GUI/Model/Model/DataFilesCleaner.h"
#include <QObject>
#include <QXmlStreamWriter>

class DataItem;
class InstrumentModel;
class MessageService;
class RealItem;

//! The RealModel class is a model to store all imported RealItem's.
class RealModel : public QObject {
    Q_OBJECT
public:
    explicit RealModel(InstrumentModel* instrumentModel = nullptr, QObject* parent = nullptr);
    ~RealModel();

    QVector<DataItem*> dataItems() const;
    void clear();

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

    void writeDataFiles(const QString& projectDir);
    void readDataFiles(const QString& projectDir, MessageService* messageService);

    RealItem* insertDataItem(int rank);
    QVector<RealItem*> realItems() const;
    QVector<RealItem*> realItems(int rank) const;

    QVector<RealItem*> realItems1D() const;
    QVector<RealItem*> realItems2D() const;

    void removeRealItem(RealItem* realItem);

    QStringList realItemNames() const;

    int selectedIndex() const { return m_selectedIndex; }
    void setSelectedIndex(int index) { m_selectedIndex = index; }

    int selectedRank() const { return m_selectedRank; }
    void setSelectedRank(int rank) { m_selectedRank = rank; }

    RealItem* pushNewItem(); // private except for test

private:
    DataFilesCleaner dataFilesCleaner;
    InstrumentModel* m_instrumentModel;
    std::vector<std::unique_ptr<RealItem>> m_realItems;
    int m_selectedIndex = -1;
    int m_selectedRank = -1;
};

#endif // BORNAGAIN_GUI_MODEL_MODEL_REALMODEL_H
