//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/FitWorker.cpp
//! @brief     Implements class FitWorker
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Fit/FitWorker.h"
#include "GUI/View/Fit/FitObjectiveBuilder.h"

void FitWorker::startFit()
{
    emit started();
    try {
        m_fit_objective->runFit();
    } catch (const std::exception& ex) {
        emit error(QString::fromLatin1(ex.what()));
    }
    emit finished();
}

void FitWorker::interruptFitting()
{
    if (m_fit_objective)
        m_fit_objective->interruptFitting();
}
