//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/RunFitControlWidget.h
//! @brief     Defines class RunFitControlWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_RUNFITCONTROLWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_RUNFITCONTROLWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class QPushButton;
class QSlider;
class CautionSign;
class QLabel;

//! The RunFitControlWidget contains elements to start/stop fitting and to provide minimal
//! diagnostic. Part of FitSuiteWidget.

class RunFitControlWidget : public DataAccessWidget {
    Q_OBJECT
public:
    RunFitControlWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

signals:
    void startFittingPushed();
    void stopFittingPushed();

public slots:
    void onFittingError(const QString& what);

private slots:
    void onSliderValueChanged(int value);

private:
    int sliderUpdateInterval();
    int sliderValueToUpdateInterval(int value);
    int updateIntervalToSliderValue(int updInterval);
    void initializeSlider();

    void updateControlElements(JobStatus status);
    FitSuiteItem* fitSuiteItem();
    bool isValidJobItem();
    void updateIterationsCountLabel(int iter);

    QPushButton* m_startButton;
    QPushButton* m_stopButton;
    QSlider* m_intervalSlider;
    QLabel* m_updateIntervalLabel;
    QLabel* m_iterationsCountLabel;
    CautionSign* m_cautionSign;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_RUNFITCONTROLWIDGET_H
