//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/InstrumentListView.h
//! @brief     Defines class InstrumentListView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTVIEW_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTVIEW_H

#include "GUI/Model/Device/InstrumentLibrary.h"
#include <QListView>

class InstrumentItem;
class InstrumentListModel;
class ProjectDocument;

//! Instrument selector on the left side of InstrumentView.

class InstrumentListView : public QWidget {
    Q_OBJECT

public:
    InstrumentListView(ProjectDocument* document, QWidget* parent = nullptr,
                       Qt::WindowFlags f = Qt::WindowFlags());
    ~InstrumentListView();

    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

    QList<QAction*> toolbarActions() const;

    InstrumentItem* currentInstrumentItem() const;

signals:
    void instrumentSelected(InstrumentItem* instrument);

private slots:
    void onItemSelectionChanged();
    void onNewGisas();
    void onNewOffspec();
    void onNewSpecular();
    void onNewDepthprobe();

    void onRemove();
    void onCopy();

    void onStoreInLibrary();
    void onLoadFromLibrary();

private:
    //! Show/hide UI elements according to settings in current project
    void updateFunctionalityNarrowing();

    void updateActions();
    void ensureItemSelected();
    void restoreSelection();

private:
    InstrumentLibrary m_instrumentLibrary;
    ProjectDocument* m_document;
    QListView* m_listView;
    InstrumentListModel* m_model;
    QAction* m_newGisasAction;
    QAction* m_newOffspecAction;
    QAction* m_newSpecularAction;
    QAction* m_newDepthprobeAction;
    QAction* m_separatorAction1;
    QAction* m_removeAction;
    QAction* m_copyAction;
    QAction* m_separatorAction2;
    QAction* m_storeInLibraryAction;
    QAction* m_loadFromLibraryAction;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTVIEW_H
