//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/EllipseView.h
//! @brief     Defines EllipseView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_ELLIPSEVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_ELLIPSEVIEW_H

#include "GUI/View/Mask/RectangleBaseView.h"

class EllipseItem;

//! This is a View of ellipse mask (represented by EllipseItem) on GraphicsScene.
//! Given view follows standard QGraphicsScene notations: (x,y) is top left corner.

class EllipseView : public RectangleBaseView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::ELLIPSE; }

    explicit EllipseView(EllipseItem* item);

    MaskItemObject* parameterizedItem() const override;

protected slots:
    void onChangedX() override;
    void onChangedY() override;
    void onPropertyChange() override;

protected:
    QPainterPath shape() const override;
    void mouseMoveEvent(QGraphicsSceneMouseEvent* event) override;

private:
    void update_position() override;
    QRectF mask_rectangle() override;
    qreal left() const override;
    qreal right() const override;
    qreal top() const override;
    qreal bottom() const override;

private:
    EllipseItem* m_item;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_ELLIPSEVIEW_H
