//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotSpecular/SpecularPlotCanvas.h
//! @brief     Defines class ColorMapCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARPLOTCANVAS_H
#define BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARPLOTCANVAS_H

#include <QWidget>

class DataItem;
class FontScalingEvent;
class PlotStatusLabel;
class QCustomPlot;
class SpecularDataItem;
class SpecularPlot;

//! Contains SpecularPlot for specular data presentation, and provides status string appearance.

class SpecularPlotCanvas : public QWidget {
    Q_OBJECT
public:
    explicit SpecularPlotCanvas(QWidget* parent = nullptr);

    void setSpecularItems(const QList<SpecularDataItem*>& specularItems);

    SpecularPlot* specularPlot();
    QCustomPlot* customPlot();

    void setStatusLabelEnabled(bool flag);

private:
    SpecularPlot* m_plot;
    FontScalingEvent* m_canvasEvent;
    PlotStatusLabel* m_statusLabel;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARPLOTCANVAS_H
