//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotUtil/PlotConstants.h
//! @brief     Defines various constants for plotting
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTCONSTANTS_H
#define BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTCONSTANTS_H

#include "GUI/Support/Util/Style.h"
#include <QSize>

namespace GUI::Constants {

inline int plot_tick_label_size()
{
    return GUI::Style::SystemPointSize() * 0.9;
}

inline int plot_axes_label_size()
{
    return GUI::Style::SystemPointSize();
}

inline int plot_colorbar_size()
{
    return GUI::Style::SizeOfLetterM().width();
}

} // namespace GUI::Constants

#endif // BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTCONSTANTS_H
