//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Img3D/Model/Layer.cpp
//! @brief     Implements Layer class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Img3D/Model/Layer.h"

namespace Img3D {

Layer::Layer(F3Range d)
    : PlottableBody(GeometricID::Key(GeometricID::BaseShape::Box))
{
    transform(d.size(), F3(0, 0, 0), d.mid());
}

} // namespace Img3D
