//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Particle/ReParticle.h
//! @brief     Defines interface class ReParticle.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_RESAMPLE_PARTICLE_REPARTICLE_H
#define BORNAGAIN_RESAMPLE_PARTICLE_REPARTICLE_H

#include "Base/Vector/RotMatrix.h"
#include "Resample/Particle/IReParticle.h"
#include <heinz/Vectors3D.h>
#include <memory>

class IFormFactor;
class Material;

//! A reprocessed simple particle, with shape m_ff.

class ReParticle : public IReParticle {
public:
    ReParticle(const IFormFactor* ff, const R3* position, const RotMatrix* rot);
    ~ReParticle() override;

    ReParticle* clone() const override;

    //! Sets the material of the scatterer
    void setMaterial(const Material& material);

    //! Sets the ambient material
    void setAmbientMaterial(const Material& ambient_material) override;

    complex_t theFF(const WavevectorInfo& wavevectors) const override;
    SpinMatrix thePolFF(const WavevectorInfo& wavevectors) const override;

    double volume() const override;

    double radialExtension() const override;

    Span zSpan() const override;

    const IFormFactor* iformfactor() const;

    virtual complex_t formfactor(C3 q) const;

private:
    const std::unique_ptr<const IFormFactor> m_ff;
    std::unique_ptr<const Material> m_material;
    std::unique_ptr<const Material> m_ambient_material;
    const std::unique_ptr<const R3> m_position;
    const std::unique_ptr<const RotMatrix> m_rotMatrix;

    ReParticle(const std::optional<size_t>& i_layer, const IFormFactor* ff,
               const Material* material, const Material* ambient_material, const R3* position,
               const RotMatrix* rotMatrix);
};

#endif // BORNAGAIN_RESAMPLE_PARTICLE_REPARTICLE_H
