//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/HardParticle/IFormFactorPrism.cpp
//! @brief     Implements interface IFormFactorPrism.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Sample/HardParticle/IFormFactorPrism.h"
#include "Base/Util/Assert.h"
#include "Sample/Particle/PolyhedralUtil.h"
#include <ff/Prism.h>

IFormFactorPrism::IFormFactorPrism(const std::vector<double>& PValues)
    : IFormFactorPolyhedron(PValues)
{
}

IFormFactorPrism::~IFormFactorPrism() = default;

void IFormFactorPrism::setPrism(bool symmetry_Ci, const std::vector<R3>& base_vertices) const
{
    pimpl =
        std::make_unique<ff::Prism>(symmetry_Ci, height(), base_vertices, R3(0, 0, height() / 2));
}
