//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/SizeDistributionModelsBuilder.h
//! @brief     Defines various sample builder classes to test DA, LMA, SSCA approximations
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_SIZEDISTRIBUTIONMODELSBUILDER_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_SIZEDISTRIBUTIONMODELSBUILDER_H

class MultiLayer;


//! Creates the sample demonstrating size distribution model in decoupling approximation.
//! Equivalent of Examples/Python/simulation/ex03_Interferences/ApproximationDA.py

namespace ExemplarySamples {

MultiLayer* createSizeDistributionDAModel();

} // namespace ExemplarySamples

//! Creates the sample demonstrating size distribution model in local monodisperse approximation.
//! Equivalent of Examples/Python/simulation/ex03_Interferences/ApproximationLMA.py

namespace ExemplarySamples {

MultiLayer* createSizeDistributionLMAModel();

} // namespace ExemplarySamples

//! Creates the sample demonstrating size distribution model in size space coupling approximation.
//! Equivalent of Examples/Python/simulation/ex03_Interferences/ApproximationSSCA.py

namespace ExemplarySamples {

MultiLayer* createSizeDistributionSSCAModel();

} // namespace ExemplarySamples

//! Builds sample: size spacing correlation approximation (IsGISAXS example #15).

namespace ExemplarySamples {

MultiLayer* createCylindersInSSCA();

} // namespace ExemplarySamples

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_SIZEDISTRIBUTIONMODELSBUILDER_H
