set(BA_PLATFORM mac)

if(NOT CMAKE_SYSTEM_NAME MATCHES Darwin)
    message(FATAL_ERROR "Found a non-Darwin system, currently unsupported")
endif()

execute_process(COMMAND sw_vers "-productVersion"
    COMMAND cut -d . -f 1-2
    OUTPUT_VARIABLE MACOSX_VERSION OUTPUT_STRIP_TRAILING_WHITESPACE)
execute_process(COMMAND sw_vers "-productVersion"
    COMMAND cut -d . -f 2
    OUTPUT_VARIABLE MACOSX_MINOR OUTPUT_STRIP_TRAILING_WHITESPACE)
message(STATUS "Found a MacOS System ${MACOSX_VERSION}, minor ${MACOSX_MINOR}")

if(${MACOSX_VERSION} LESS 11)
    message(FATAL_ERROR "Found a MacOS < 11.0, which is unsupported")
endif()

#TODO: check haveconfig and rpath -> set rpath true
#TODO: check Thread, define link command
#TODO: more stuff check configure script
execute_process(COMMAND /usr/sbin/sysctl machdep.cpu.extfeatures OUTPUT_VARIABLE SYSCTL_OUTPUT)
if(NOT ${SYSCTL_OUTPUT} MATCHES 64)
    message(FATAL "Found a 32bit system - no longer supported")
endif()

if(${CMAKE_SYSTEM_PROCESSOR} MATCHES arm)
    # arch = arm64
    set(BA_ARCHITECTURE "${BA_PLATFORM}_arm")
else()
    # arch = x86_64
    set(BA_ARCHITECTURE "${BA_PLATFORM}_x64")
endif()

# On OS X, the `-dead_strip` flag removes unneeded symbols/object files, and
# `-dead_strip_dylibs` flag removes unneeded libraries [see `man ld` on OSX]
set(DEADSTRIP_LFLAGS "-dead_strip -dead_strip_dylibs")
set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS}")
string(APPEND CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS " -m64 ${DEADSTRIP_LFLAGS}")
string(APPEND CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS " -m64 ${DEADSTRIP_LFLAGS}")
string(APPEND CMAKE_CXX_FLAGS " -m64 -I${CMAKE_SOURCE_DIR}/Wrap")
string(APPEND CMAKE_C_FLAGS " -m64")
# string(APPEND CMAKE_C_LINK_FLAGS " -bind_at_load -m64")
# string(APPEND CMAKE_CXX_LINK_FLAGS " -bind_at_load -m64")


if(CMAKE_COMPILER_IS_GNUCXX)
    message(STATUS "Found GNU compiler collection")
    execute_process(COMMAND ${CMAKE_C_COMPILER} -dumpversion OUTPUT_VARIABLE GCC_VERSION OUTPUT_STRIP_TRAILING_WHITESPACE)

    string(APPEND CMAKE_CXX_FLAGS " -pipe -W -Wall -Woverloaded-virtual -fsigned-char -fno-common")
    string(APPEND CMAKE_C_FLAGS " -pipe -W -Wall -fsigned-char -fno-common")
    set(CINT_CXX_DEFINITIONS "-DG__REGEXP -DG__UNIX -DG__SHAREDLIB -DG__ROOT -DG__REDIRECTIO -DG__OSFDLL -DG__STD_EXCEPTION")
    set(CINT_C_DEFINITIONS "-DG__REGEXP -DG__UNIX -DG__SHAREDLIB -DG__ROOT -DG__REDIRECTIO -DG__OSFDLL -DG__STD_EXCEPTION")

    string(APPEND CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS " -flat_namespace -single_module -undefined dynamic_lookup")
    string(APPEND CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS " -flat_namespace -single_module -undefined dynamic_lookup")

    # Select flags.
    set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -g")
    set(CMAKE_CXX_FLAGS_RELEASE        "-O2")
    set(CMAKE_CXX_FLAGS_DEBUG          "-g -O2 -fno-reorder-blocks -fno-inline")
    set(CMAKE_CXX_FLAGS_DEBUGFULL      "-g3 -fno-inline")
    set(CMAKE_CXX_FLAGS_PROFILE        "-g3 -fno-inline -ftest-coverage -fprofile-arcs")
    set(CMAKE_C_FLAGS_RELWITHDEBINFO   "-O2 -g")
    set(CMAKE_C_FLAGS_RELEASE          "-O2")
    set(CMAKE_C_FLAGS_DEBUG            "-g -O2 -fno-reorder-blocks -fno-inline")
    set(CMAKE_C_FLAGS_DEBUGFULL        "-g3 -fno-inline")
    set(CMAKE_C_FLAGS_PROFILE          "-g3 -fno-inline -ftest-coverage -fprofile-arcs")

    #settings for cint
    set(CPPPREP "${CMAKE_CXX_COMPILER} -E -C")
    set(CXXOUT "-o ")
    set(EXEEXT "")
    set(SOEXT "so")

elseif(${CMAKE_CXX_COMPILER_ID} STREQUAL Clang OR ${CMAKE_CXX_COMPILER_ID} STREQUAL AppleClang)
    message(STATUS "Found LLVM compiler collection")
    execute_process(COMMAND ${CMAKE_C_COMPILER} -dumpversion OUTPUT_VARIABLE GCC_VERSION OUTPUT_STRIP_TRAILING_WHITESPACE)

    string(APPEND CMAKE_CXX_FLAGS " -pipe -W -Wall -Woverloaded-virtual -fsigned-char -fno-common")
    string(APPEND CMAKE_C_FLAGS " -pipe -W -Wall -fsigned-char -fno-common")

    string(APPEND CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS " -flat_namespace -single_module -undefined dynamic_lookup")
    string(APPEND CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS " -flat_namespace -single_module -undefined dynamic_lookup")

    # Select flags.
    set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -g")
    set(CMAKE_CXX_FLAGS_RELEASE        "-O2")
    set(CMAKE_CXX_FLAGS_DEBUG          "-g -O2 -fno-inline")
    set(CMAKE_CXX_FLAGS_DEBUGFULL      "-g3 -fno-inline")
    set(CMAKE_CXX_FLAGS_PROFILE        "-g3 -fno-inline -ftest-coverage -fprofile-arcs")
    set(CMAKE_C_FLAGS_RELWITHDEBINFO   "-O2 -g")
    set(CMAKE_C_FLAGS_RELEASE          "-O2")
    set(CMAKE_C_FLAGS_DEBUG            "-g -O2 -fno-inline")
    set(CMAKE_C_FLAGS_DEBUGFULL        "-g3 -fno-inline")
    set(CMAKE_C_FLAGS_PROFILE          "-g3 -fno-inline -ftest-coverage -fprofile-arcs")

    #settings for cint
    set(CPPPREP "${CMAKE_CXX_COMPILER} -E -C")
    set(CXXOUT "-o ")
    set(EXEEXT "")
    set(SOEXT "so")

else()
    message(FATAL_ERROR "Found unsupported compiler.")

endif()
