+++
title = "EllipsoidalCylinder"
+++

### EllipsoidalCylinder

An upright cylinder whose cross section is an ellipse.

<img src="/img/draw/ff/3d/EllipsoidalCylinder.png" width="30%" >
<img src="/img/draw/ff/2d/EllipsoidalCylinder_xy.svg" width="30%">
<img src="/img/draw/ff/2d/EllipsoidalCylinder_xz.svg" width="30%">

#### Constructor

```python
EllipsoidalCylinder(R_a, R_b, H)
```

Parameters:
- R_a, radius $R_{a}$ in $x$ direction
- R_b, radius $R_{b}$ in $y$ direction
- H, height

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "EllipsoidalCylinder" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor is computed as

$$ F(\mathbf{q})=2\pi R_aR_b H \space \exp\Big(iq_z\dfrac{H}{2}\Big) \text{sinc}\Big(q_z\dfrac{H}{2}\Big) 
\dfrac{J_1(\gamma)}{\gamma} , $$
with the notation 
$$ \gamma := \sqrt{(q_xR_a)^2 + (q_yR_b)^2}. $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$V=\pi R_aR_bH.$$

#### Related shapes

More special:
- [Cylinder](/ref/sample/particle/ff/hard/cylinder), if base is circular.
 
#### Example

Scattering by uncorrelated, oriented cylinders for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/EllipsoidalCylinder.png">

Generated by {{% ref-ex "ff/EllipsoidalCylinder.py" %}}.

#### History

Agrees with "Ellipsoid" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.40, wrongly labeled in Fig. 2.4] and "Ellipsoidal Cylinder" [[Renaud 2009](/lit/renaud2009), Eq. 224]
