// Copyright © 2015-2017 winapi-rs developers
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! This module defines the SQL extension APIs
use um::sql::{
    SQL_CHAR, SQL_DOUBLE, SQL_INTEGER, SQL_NUMERIC, SQL_REAL, SQL_SMALLINT, SQL_TYPE_DATE,
    SQL_TYPE_TIME, SQL_TYPE_TIMESTAMP
};
use um::sqltypes::{SQLINTEGER, SQLSMALLINT, SQLUSMALLINT};
pub const SQL_ATTR_ODBC_VERSION: SQLINTEGER = 200;
pub const SQL_ATTR_CONNECTION_POOLING: SQLINTEGER = 201;
pub const SQL_ATTR_CP_MATCH: SQLINTEGER = 202;
pub const SQL_OV_ODBC2: SQLINTEGER = 2;
pub const SQL_OV_ODBC3: SQLINTEGER = 3;
pub const SQL_OV_ODBC3_80: SQLINTEGER = 380;
pub const SQL_ACCESS_MODE: SQLINTEGER = 101;
pub const SQL_AUTOCOMMIT: SQLINTEGER = 102;
pub const SQL_LOGIN_TIMEOUT: SQLINTEGER = 103;
pub const SQL_OPT_TRACE: SQLINTEGER = 104;
pub const SQL_OPT_TRACEFILE: SQLINTEGER = 105;
pub const SQL_TRANSLATE_DLL: SQLINTEGER = 106;
pub const SQL_TRANSLATE_OPTION: SQLINTEGER = 107;
pub const SQL_TXN_ISOLATION: SQLINTEGER = 108;
pub const SQL_CURRENT_QUALIFIER: SQLINTEGER = 109;
pub const SQL_ODBC_CURSORS: SQLINTEGER = 110;
pub const SQL_QUIET_MODE: SQLINTEGER = 111;
pub const SQL_PACKET_SIZE: SQLINTEGER = 112;
pub const SQL_ATTR_ACCESS_MODE: SQLINTEGER = SQL_ACCESS_MODE;
pub const SQL_ATTR_AUTOCOMMIT: SQLINTEGER = SQL_AUTOCOMMIT;
pub const SQL_ATTR_CONNECTION_TIMEOUT: SQLINTEGER = 113;
pub const SQL_ATTR_CURRENT_CATALOG: SQLINTEGER = SQL_CURRENT_QUALIFIER;
pub const SQL_ATTR_DISCONNECT_BEHAVIOR: SQLINTEGER = 114;
pub const SQL_ATTR_ENLIST_IN_DTC: SQLINTEGER = 1207;
pub const SQL_ATTR_ENLIST_IN_XA: SQLINTEGER = 1208;
pub const SQL_ATTR_LOGIN_TIMEOUT: SQLINTEGER = SQL_LOGIN_TIMEOUT;
pub const SQL_ATTR_ODBC_CURSORS: SQLINTEGER = SQL_ODBC_CURSORS;
pub const SQL_ATTR_PACKET_SIZE: SQLINTEGER = SQL_PACKET_SIZE;
pub const SQL_ATTR_QUIET_MODE: SQLINTEGER = SQL_QUIET_MODE;
pub const SQL_ATTR_TRACE: SQLINTEGER = SQL_OPT_TRACE;
pub const SQL_ATTR_TRACEFILE: SQLINTEGER = SQL_OPT_TRACEFILE;
pub const SQL_ATTR_TRANSLATE_LIB: SQLINTEGER = SQL_TRANSLATE_DLL;
pub const SQL_ATTR_TRANSLATE_OPTION: SQLINTEGER = SQL_TRANSLATE_OPTION;
pub const SQL_ATTR_TXN_ISOLATION: SQLINTEGER = SQL_TXN_ISOLATION;
pub const SQL_ATTR_CONNECTION_DEAD: SQLINTEGER = 1209;
pub const SQL_IS_POINTER: SQLINTEGER = -4;
pub const SQL_IS_UINTEGER: SQLINTEGER = -5;
pub const SQL_IS_INTEGER: SQLINTEGER = -6;
pub const SQL_IS_USMALLINT: SQLINTEGER = -7;
pub const SQL_IS_SMALLINT: SQLINTEGER = -8;
pub const SQL_DATE: SQLSMALLINT = 9;
pub const SQL_INTERVAL: SQLSMALLINT = 10;
pub const SQL_TIME: SQLSMALLINT = 10;
pub const SQL_TIMESTAMP: SQLSMALLINT = 11;
pub const SQL_LONGVARCHAR: SQLSMALLINT = -1;
pub const SQL_BINARY: SQLSMALLINT = -2;
pub const SQL_VARBINARY: SQLSMALLINT = -3;
pub const SQL_LONGVARBINARY: SQLSMALLINT = -4;
pub const SQL_BIGINT: SQLSMALLINT = -5;
pub const SQL_TINYINT: SQLSMALLINT = -6;
pub const SQL_BIT: SQLSMALLINT = -7;
pub const SQL_GUID: SQLSMALLINT = -11;
pub const SQL_C_CHAR: SQLSMALLINT = SQL_CHAR;
pub const SQL_C_LONG: SQLSMALLINT = SQL_INTEGER;
pub const SQL_C_SHORT: SQLSMALLINT = SQL_SMALLINT;
pub const SQL_C_FLOAT: SQLSMALLINT = SQL_REAL;
pub const SQL_C_DOUBLE: SQLSMALLINT = SQL_DOUBLE;
pub const SQL_C_NUMERIC: SQLSMALLINT = SQL_NUMERIC;
pub const SQL_C_DEFAULT: SQLSMALLINT = 99;
pub const SQL_SIGNED_OFFSET: SQLSMALLINT = -20;
pub const SQL_UNSIGNED_OFFSET: SQLSMALLINT = -22;
pub const SQL_C_DATE: SQLSMALLINT = SQL_DATE;
pub const SQL_C_TIME: SQLSMALLINT = SQL_TIME;
pub const SQL_C_TIMESTAMP: SQLSMALLINT = SQL_TIMESTAMP;
pub const SQL_C_TYPE_DATE: SQLSMALLINT = SQL_TYPE_DATE;
pub const SQL_C_TYPE_TIME: SQLSMALLINT = SQL_TYPE_TIME;
pub const SQL_C_TYPE_TIMESTAMP: SQLSMALLINT = SQL_TYPE_TIMESTAMP;
pub const SQL_C_BINARY: SQLSMALLINT = SQL_BINARY;
pub const SQL_C_BIT: SQLSMALLINT = SQL_BIT;
pub const SQL_C_SBIGINT: SQLSMALLINT = SQL_BIGINT + SQL_SIGNED_OFFSET;
pub const SQL_C_UBIGINT: SQLSMALLINT = SQL_BIGINT + SQL_UNSIGNED_OFFSET;
pub const SQL_C_TINYINT: SQLSMALLINT = SQL_TINYINT;
pub const SQL_C_SLONG: SQLSMALLINT = SQL_C_LONG + SQL_SIGNED_OFFSET;
pub const SQL_C_SSHORT: SQLSMALLINT = SQL_C_SHORT + SQL_SIGNED_OFFSET;
pub const SQL_C_STINYINT: SQLSMALLINT = SQL_TINYINT + SQL_SIGNED_OFFSET;
pub const SQL_C_ULONG: SQLSMALLINT = SQL_C_LONG + SQL_UNSIGNED_OFFSET;
pub const SQL_C_USHORT: SQLSMALLINT = SQL_C_SHORT + SQL_UNSIGNED_OFFSET;
pub const SQL_C_UTINYINT: SQLSMALLINT = SQL_TINYINT + SQL_UNSIGNED_OFFSET;
pub const SQL_C_GUID: SQLSMALLINT = SQL_GUID;
pub const SQL_TYPE_NULL: SQLSMALLINT = 0;
pub const SQL_DRIVER_NOPROMPT: SQLUSMALLINT = 0;
pub const SQL_DRIVER_COMPLETE: SQLUSMALLINT = 1;
pub const SQL_DRIVER_PROMPT: SQLUSMALLINT = 2;
pub const SQL_DRIVER_COMPLETE_REQUIRED: SQLUSMALLINT = 3;