/* Copyright (C) 2000-2018 Peter Selinger.
   This file is part of ccrypt. It is free software and it is covered
   by the GNU general public license. See the file COPYING for details. */

/* rijndael.h */

/* derived from original source: rijndael-alg-ref.h   v2.0   August '99
 * Reference ANSI C code for NIST competition
 * authors: Paulo Barreto
 *          Vincent Rijmen
 */

#ifndef __RIJNDAEL_H
#define __RIJNDAEL_H

#ifdef HAVE_CONFIG_H
#include <config.h>		/* generated by configure */
#endif

typedef unsigned char xword8;

#ifdef UINT32_TYPE
typedef UINT32_TYPE xword32;
#else
typedef int xword32;		/* should be a 32-bit integer type */
#endif

/* a type to hold 32 bits accessible as 1 integer or 4 bytes */
union xword8x4_u {
  xword8 w8[4];
  xword32 w32;
};
typedef union xword8x4_u xword8x4;

#define MAXBC		(256/32)
#define MAXKC		(256/32)
#define MAXROUNDS	14
#define MAXRK           ((MAXROUNDS+1)*MAXBC)

typedef struct {
  int BC;
  int KC;
  int ROUNDS;
  int shift[2][4];
  xword32 rk[MAXRK];
} roundkey;

/* keys and blocks are externally treated as xword32 arrays, to
   make sure they are aligned on 4-byte boundaries on architectures
   that require it. */

/* make a roundkey rkk from key. key must have appropriate size given
   by keyBits. keyBits and blockBits may only be 128, 196, or
   256. Returns non-zero if arguments are invalid. */

int xrijndaelKeySched(xword32 key[], int keyBits, int blockBits,
		      roundkey *rkk);

/* encrypt, resp. decrypt, block using rijndael roundkey rkk. rkk must
   have been created with xrijndaelKeySched. Size of block, in bits,
   must be equal to blockBits parameter that was used to make rkk. In
   all other cases, behavior is undefined - for reasons of speed, no
   check for error conditions is done. */

void xrijndaelEncrypt(xword32 block[], roundkey *rkk);
void xrijndaelDecrypt(xword32 block[], roundkey *rkk);

#endif				/* __RIJNDAEL_H */
