/****************************************************************************
 *    lib/main.h - This file is part of coala								*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include <iostream>
#include <string>
#include "options.h"

using namespace std;

namespace Coala {


class AbstractCompiler {
	public:
		virtual int compile() = 0;
};


class Compiler : public AbstractCompiler {
	public:
		Compiler();
		virtual ~Compiler();
		
		int compile();
		
		void setLanguage(string);
		void setInputStream(istream&);
		void setOutputStream(ostream&);
		void setFakeClassicalNegation(bool);
		void setDebug(int);
		void setDirectEncoding(bool);
		void setIncremental(bool);
		void setReverseIncremental(bool);
		void setWhereCheck(bool);
		
	private:
		AbstractCompiler* compiler_;
		CompilerOptions* options_;
	
};

};

#endif // MAIN_H
