#!/bin/bash

. ../MasterTest.sh

CleanFiles runavg.in runavg.crd R1.dat
TESTNAME='Coordinate running average tests'
Requires netcdf maxthreads 20
TOP="../tz2.parm7"
INPUT="runavg.in"

cat > $INPUT <<EOF
trajin ../tz2.nc
runavg window 5
rms R1 :1-13&!@H= out R1.dat
EOF
RunCpptraj "Coordinate Running Average test."
DoTest R1.dat.save R1.dat

UNITNAME='Coordinate Running Average Traj Write'
CheckFor notparallel
if [ $? -eq 0 ] ; then
  cat > $INPUT <<EOF
trajin ../tz2.nc 1 14
runavg window 5
trajout runavg.crd nobox title "trajectory generated by ptraj"
EOF
  RunCpptraj "$UNITNAME"
  DoTest runavg.crd.save runavg.crd
fi
EndTest

exit 0
